/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.clm.dto.model.ide;

import com.sonatype.clm.dto.model.ComponentInfo;
import com.sonatype.clm.dto.model.SecurityVulnerability;
import com.sonatype.clm.dto.model.component.ComponentCategory;
import com.sonatype.clm.dto.model.component.ComponentIdentifier;
import com.sonatype.clm.dto.model.component.HygieneRating;
import com.sonatype.clm.dto.model.component.IntegrityRating;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MatchedComponent
implements Serializable,
ComponentInfo {
    private static final long serialVersionUID = -5668336799541344660L;
    private Integer waitDelta;
    private boolean simpleMatch;
    private String matchState;
    private ComponentIdentifier componentIdentifier;
    @Deprecated
    private String groupId;
    @Deprecated
    private String artifactId;
    @Deprecated
    private String version;
    @Deprecated
    private String classifier;
    private List<SecurityVulnerability> securityVulnerabilities;
    private String hash;
    private Set<String> observedLicenseIds;
    private Set<String> declaredLicenseIds;
    private Long catalogDate;
    private Integer relativePopularity;
    private String identificationSource;
    private List<ComponentCategory> componentCategories;
    private HygieneRating hygieneRating;
    private IntegrityRating integrityRating;

    public Integer getWaitDelta() {
        return this.waitDelta;
    }

    public void setWaitDelta(Integer waitDelta) {
        this.waitDelta = waitDelta;
    }

    public boolean isSimpleMatch() {
        return this.simpleMatch;
    }

    public void setSimpleMatch(boolean simpleMatch) {
        this.simpleMatch = simpleMatch;
    }

    @Override
    public String getMatchState() {
        return this.matchState;
    }

    public void setMatchState(String matchState) {
        this.matchState = matchState;
    }

    @Override
    public ComponentIdentifier getComponentIdentifier() {
        return this.componentIdentifier;
    }

    public void setComponentIdentifier(ComponentIdentifier componentIdentifier) {
        this.componentIdentifier = componentIdentifier;
        if (this.componentIdentifier != null && componentIdentifier.isMaven()) {
            this.groupId = this.componentIdentifier.get("groupId");
            this.artifactId = this.componentIdentifier.get("artifactId");
            this.version = this.componentIdentifier.get("version");
            this.classifier = this.componentIdentifier.get("classifier");
        }
    }

    @Override
    @Deprecated
    public String getGroupId() {
        return this.groupId;
    }

    @Deprecated
    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @Override
    @Deprecated
    public String getArtifactId() {
        return this.artifactId;
    }

    @Deprecated
    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    @Override
    @Deprecated
    public String getVersion() {
        return this.version;
    }

    @Deprecated
    public void setVersion(String version) {
        this.version = version;
    }

    @Deprecated
    public String getClassifier() {
        return this.classifier;
    }

    @Deprecated
    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public Float getSecurityThreat() {
        if (this.securityVulnerabilities == null) {
            return null;
        }
        Float retVal = null;
        for (SecurityVulnerability issue : this.securityVulnerabilities) {
            if (retVal == null) {
                retVal = issue.getSeverity();
                continue;
            }
            if (issue.getSeverity() == null) continue;
            retVal = Float.valueOf(Math.max(retVal.floatValue(), issue.getSeverity().floatValue()));
        }
        return retVal;
    }

    public int getSecurityIssues() {
        return this.securityVulnerabilities == null ? 0 : this.securityVulnerabilities.size();
    }

    void setSecurityIssues(int num) {
    }

    void setSecurityThreat(Float fl) {
    }

    public void addSecurityVulnerability(SecurityVulnerability issue) {
        if (this.securityVulnerabilities == null) {
            this.securityVulnerabilities = new ArrayList<SecurityVulnerability>();
        }
        this.securityVulnerabilities.add(issue);
    }

    @Override
    public List<SecurityVulnerability> getSecurityVulnerabilities() {
        return this.securityVulnerabilities;
    }

    public void setSecurityVulnerabilities(List<SecurityVulnerability> securityVulnerabilities) {
        this.securityVulnerabilities = securityVulnerabilities;
    }

    @Override
    public Long getCatalogDate() {
        return this.catalogDate;
    }

    public void setCatalogDate(Long catalogDate) {
        this.catalogDate = catalogDate;
    }

    @Override
    public Integer getRelativePopularity() {
        return this.relativePopularity;
    }

    public void setRelativePopularity(Integer relativePopularity) {
        this.relativePopularity = relativePopularity;
    }

    @Override
    public Set<String> getDeclaredLicenseIds() {
        return this.declaredLicenseIds;
    }

    public void setDeclaredLicenseIds(Set<String> declaredLicenseIds) {
        this.declaredLicenseIds = declaredLicenseIds;
    }

    @Override
    public Set<String> getObservedLicenseIds() {
        return this.observedLicenseIds;
    }

    public void setObservedLicenseIds(Set<String> observedLicenseIds) {
        this.observedLicenseIds = observedLicenseIds;
    }

    public void addObservedLicenseId(String observedLicenseId) {
        if (this.observedLicenseIds == null) {
            this.observedLicenseIds = new HashSet<String>();
        }
        this.observedLicenseIds.add(observedLicenseId);
    }

    public void addDeclaredLicenseId(String declaredLicenseId) {
        if (this.declaredLicenseIds == null) {
            this.declaredLicenseIds = new HashSet<String>();
        }
        this.declaredLicenseIds.add(declaredLicenseId);
    }

    @Override
    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    @Override
    public String getIdentificationSource() {
        return this.identificationSource;
    }

    public void setIdentificationSource(String identificationSource) {
        this.identificationSource = identificationSource;
    }

    @Override
    public List<ComponentCategory> getComponentCategories() {
        return this.componentCategories;
    }

    public void setComponentCategories(List<ComponentCategory> componentCategories) {
        this.componentCategories = componentCategories;
    }

    @Override
    public HygieneRating getHygieneRating() {
        return this.hygieneRating;
    }

    public void setHygieneRating(HygieneRating hygieneRating) {
        this.hygieneRating = hygieneRating;
    }

    @Override
    public IntegrityRating getIntegrityRating() {
        return this.integrityRating;
    }

    public void setIntegrityRating(IntegrityRating integrityRating) {
        this.integrityRating = integrityRating;
    }
}

