/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.clm.dto.model.policy;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.sonatype.clm.dto.model.policy.ComponentFact;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PolicyFact {
    private String policyId;
    private String policyName;
    private int threatLevel;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String policyViolationId;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<ComponentFact> componentFacts;

    public PolicyFact() {
    }

    public PolicyFact(String policyId, String policyName, int threatLevel) {
        this.policyId = policyId;
        this.policyName = policyName;
        this.threatLevel = threatLevel;
    }

    public PolicyFact(String policyId, String policyName, int threatLevel, String policyViolationId) {
        this(policyId, policyName, threatLevel);
        this.policyViolationId = policyViolationId;
    }

    public String getPolicyId() {
        return this.policyId;
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public int getThreatLevel() {
        return this.threatLevel;
    }

    public String getPolicyViolationId() {
        return this.policyViolationId;
    }

    public List<ComponentFact> getComponentFacts() {
        return this.componentFacts != null ? Collections.unmodifiableList(this.componentFacts) : Collections.EMPTY_LIST;
    }

    public void setComponentFacts(List<ComponentFact> componentFacts) {
        this.componentFacts = componentFacts;
    }

    public void addComponentFact(ComponentFact componentFact) {
        if (this.componentFacts == null) {
            this.componentFacts = new ArrayList<ComponentFact>();
        }
        this.componentFacts.add(componentFact);
    }

    public String toString() {
        return "\nPolicy(" + this.policyName + ") " + this.componentFacts;
    }
}

