/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.clm.dto.model.policy;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class Stage {
    public static final String ID_DEVELOP = "develop";
    public static final String ID_SOURCE = "source";
    public static final String ID_BUILD = "build";
    public static final String ID_STAGE_RELEASE = "stage-release";
    public static final String ID_RELEASE = "release";
    public static final String ID_OPERATE = "operate";
    public static final String ID_PROXY = "proxy";
    public static final String ID_COMPLIANCE = "compliance";
    private String stageTypeId;
    private String stageName;
    private static final Set<String> validStages;

    public Stage() {
    }

    public Stage(String stageTypeId) {
        this.stageTypeId = stageTypeId;
    }

    public Stage(String stageTypeId, String stageName) {
        this.stageTypeId = stageTypeId;
        this.stageName = stageName;
    }

    public String getStageTypeId() {
        return this.stageTypeId;
    }

    public void setStageTypeId(String stageTypeId) {
        this.stageTypeId = stageTypeId;
    }

    public String getStageName() {
        return this.stageName;
    }

    public void setStageName(String stageName) {
        this.stageName = stageName;
    }

    public static boolean isValidStageTypeId(String stageTypeId) {
        return validStages.contains(stageTypeId);
    }

    public String toString() {
        return String.valueOf(this.stageTypeId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Stage stage = (Stage)o;
        return Objects.equals(this.stageTypeId, stage.stageTypeId) && Objects.equals(this.stageName, stage.stageName);
    }

    public int hashCode() {
        return Objects.hash(this.stageTypeId, this.stageName);
    }

    static {
        HashSet<String> stages = new HashSet<String>();
        stages.add(ID_DEVELOP);
        stages.add(ID_SOURCE);
        stages.add(ID_BUILD);
        stages.add(ID_STAGE_RELEASE);
        stages.add(ID_RELEASE);
        stages.add(ID_OPERATE);
        stages.add(ID_COMPLIANCE);
        validStages = Collections.unmodifiableSet(stages);
    }
}

