/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.clm.dto.model.signature;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.List;
import java.util.Locale;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class VulnerabilitySignatureAnalysisDTO {
    public AnalyzerDTO analyzer;
    public List<SignatureDTO> signatures;
    public MetricsDTO metricsDTO;

    public static class TraceDTO {
        public String functionDescriptor;
        public List<Integer> functionParameters;
        public Integer lineNumber;
        public List<TraceDTO> traces;
    }

    public static enum Reachability {
        USER_CONTROLLED_INPUT,
        INVOKED;


        @JsonValue
        public String toString() {
            return this.name().toLowerCase(Locale.ENGLISH).replace('_', '-');
        }
    }

    public static class SignatureDTO {
        public String anchor;
        public Set<Reachability> reachability;
        public List<TraceDTO> traces;
        public int totalTraceCount;
        public String analysisDetailsUrl;
    }

    public static class AnalyzerDTO {
        public String name;
        public String version;
    }

    public static class MetricsDTO {
        public long numberOfContainers;
        public long bytesOfContainers;
        public long numberOfClassFiles;
        public long numberOfProcessors;
        public long bytesOfMaxHeapSize;
        public long bytesOfAvailableDiskSpaceInTempBefore;
        public long bytesOfAvailableDiskSpaceInTempAfter;
        public long millisecondsOfRuntime;
    }
}

