/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.scan;

import com.sonatype.insight.scan.archive.TFileUtils;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TVFS;
import java.io.Closeable;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public final class ArchiveReader
implements Closeable {
    private final TFile file;
    private Iterator<Map.Entry<String, TFile>> iterator;
    private Map.Entry<String, TFile> current;

    public ArchiveReader(File file) {
        this.file = new TFile(file, TFileUtils.getArchiveDetector(Collections.emptyMap(), null));
        LinkedHashMap<String, TFile> entries = new LinkedHashMap<String, TFile>();
        ArchiveReader.index(this.file, "", entries);
        this.iterator = entries.entrySet().iterator();
    }

    private static void index(TFile file, String pathPrefix, Map<String, TFile> entries) {
        TFile[] children = file.listFiles();
        if (children != null) {
            for (TFile child : children) {
                String path = pathPrefix + child.getName();
                if (child.isArchive() || child.isFile()) {
                    entries.put(path, child);
                    continue;
                }
                ArchiveReader.index(child, path + "/", entries);
            }
        }
    }

    public boolean next() {
        if (this.iterator == null) {
            throw new IllegalStateException("archive reader has been closed");
        }
        if (!this.iterator.hasNext()) {
            this.current = null;
            return false;
        }
        this.current = this.iterator.next();
        return true;
    }

    private Map.Entry<String, TFile> getCurrent() {
        if (this.current == null) {
            throw new IllegalStateException("iteration finished or not yet started");
        }
        return this.current;
    }

    public File getEntry() {
        return (File)this.getCurrent().getValue();
    }

    public String getEntryPath() {
        return this.getCurrent().getKey();
    }

    public boolean isNestedArchive() {
        return this.getCurrent().getValue().isArchive();
    }

    @Override
    public void close() {
        this.iterator = null;
        this.current = null;
        ArchiveReader.unmount(this.file);
    }

    private static void unmount(TFile file) {
        try {
            TVFS.umount((TFile)file);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Set<String> index(File file) {
        TreeSet<String> directories = new TreeSet<String>();
        TFile tfile = new TFile(file, TFileUtils.getArchiveDetector(Collections.emptyMap(), null));
        try {
            ArchiveReader.index(tfile, "", directories);
        }
        finally {
            ArchiveReader.unmount(tfile);
        }
        directories.remove("META-INF");
        if (directories.size() > 1) {
            Iterator it = directories.descendingIterator();
            String last = (String)it.next();
            while (it.hasNext()) {
                String current = (String)it.next();
                if (last.startsWith(current)) {
                    it.remove();
                    continue;
                }
                last = current;
            }
        }
        return directories;
    }

    private static void index(TFile file, String pathPrefix, Set<String> directories) {
        TFile[] children = file.listFiles();
        if (children != null) {
            for (TFile child : children) {
                Object path = pathPrefix + child.getName();
                if (child.isFile()) {
                    int slash = ((String)path).lastIndexOf(47);
                    if (slash < 0) continue;
                    path = ((String)path).substring(0, slash);
                    directories.add((String)path);
                    continue;
                }
                ArchiveReader.index(child, (String)(child.isArchive() ? "" : (String)path + "/"), directories);
            }
        }
    }
}

