/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.scan;

import com.sonatype.insight.ide.scan.DigestException;
import com.sonatype.insight.scan.archive.TFileUtils;
import com.sonatype.insight.scan.hash.Hash;
import com.sonatype.insight.scan.hash.HashType;
import com.sonatype.insight.scan.hash.IMatchable;
import com.sonatype.insight.scan.hash.internal.DefaultDigester;
import com.sonatype.insight.scan.hash.internal.JavaDigester;
import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public class Digester {
    private static final Set<HashType> CONTENT = EnumSet.of(HashType.CONTENT);
    private final com.sonatype.insight.scan.hash.Digester digester;
    private final Set<HashType> hashTypes;
    private final TArchiveDetector archiveDetector;

    public Digester(Logger log) {
        this.digester = new DefaultDigester(new JavaDigester(), log);
        this.hashTypes = EnumSet.noneOf(HashType.class);
        boolean hashJavaTypes = true;
        boolean hashJavaTypeMembers = false;
        this.hashTypes.add(HashType.CONTENT);
        if (hashJavaTypes) {
            this.hashTypes.add(HashType.BYTECODE);
            this.hashTypes.add(HashType.SIGNATURE);
            this.hashTypes.add(HashType.NOPKG_BYTECODE);
            this.hashTypes.add(HashType.NOPKG_SIGNATURE);
        }
        if (hashJavaTypeMembers) {
            this.hashTypes.add(HashType.TYPE);
            this.hashTypes.add(HashType.FIELD);
            this.hashTypes.add(HashType.METHOD);
            this.hashTypes.add(HashType.METHOD_SIGNATURE);
            this.hashTypes.add(HashType.NOPKG_TYPE);
            this.hashTypes.add(HashType.NOPKG_FIELD);
            this.hashTypes.add(HashType.NOPKG_METHOD);
            this.hashTypes.add(HashType.NOPKG_METHOD_SIGNATURE);
        }
        this.archiveDetector = TFileUtils.getArchiveDetector(Collections.emptyMap(), null);
    }

    public String digestSimple(File file) throws DigestException {
        return this.digest(file, CONTENT).get(HashType.CONTENT.getId());
    }

    public Map<String, String> digestEnhanced(File file) throws DigestException {
        return this.digest(file, this.hashTypes);
    }

    private Map<String, String> digest(File file, Set<HashType> hashTypes) throws DigestException {
        HashMap<String, String> hashMap;
        block9: {
            InputStream is = this.open(file);
            try {
                Map<HashType, IMatchable> hashes = this.digester.digest(is, file.getName(), hashTypes);
                HashMap<String, String> result = new HashMap<String, String>();
                for (Map.Entry<HashType, IMatchable> entry : hashes.entrySet()) {
                    String hex = this.toHexString(entry.getValue());
                    if (hex == null) continue;
                    result.put(entry.getKey().getId(), hex);
                }
                hashMap = result;
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new DigestException("Could not calculate digest for " + file, e);
                }
            }
            is.close();
        }
        return hashMap;
    }

    private InputStream open(File file) throws Exception {
        if (file instanceof TFile) {
            return TFileUtils.openInputStream((TFile)file);
        }
        if (file.exists()) {
            return new FileInputStream(file);
        }
        return TFileUtils.openInputStream(new TFile(file, this.archiveDetector));
    }

    private String toHexString(IMatchable hash) {
        String hex;
        if (hash == null) {
            hex = null;
        } else if (hash instanceof Hash) {
            hex = ((Hash)hash).toHexString();
        } else {
            int hashes = hash.getHashes().size();
            if (hashes > 0) {
                StringBuilder buffer = new StringBuilder(hashes * 21);
                for (Hash h : hash.getHashes()) {
                    if (buffer.length() > 0) {
                        buffer.append(',');
                    }
                    buffer.append(h.toHexString());
                }
                hex = buffer.toString();
            } else {
                hex = null;
            }
        }
        return hex;
    }
}

