/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.scan;

import com.sonatype.insight.scan.archive.CompoundSelector;
import com.sonatype.insight.scan.archive.PathSelector;
import com.sonatype.insight.scan.archive.RegexSelector;
import com.sonatype.insight.scan.archive.Selector;
import java.util.Collection;

public class ProprietaryComponentDetector {
    private final Selector selector;

    public ProprietaryComponentDetector(Collection<String> packages, Collection<String> regexes) {
        this.selector = new CompoundSelector("proprietary", PathSelector.forProprietaryPackages(packages), RegexSelector.forProprietaryRegexes(regexes));
    }

    public boolean isProprietary(String ... pathnames) {
        for (String pathname : pathnames) {
            if (!this.isProprietary(pathname)) continue;
            return true;
        }
        return false;
    }

    public boolean isProprietary(String pathname) {
        return this.selector.isSelected(pathname) != Selector.Selection.SELECTED;
    }
}

