/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.archive;

import com.sonatype.insight.scan.archive.Selector;
import com.sonatype.insight.scan.archive.SelectorUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class PathSelector
implements Selector {
    public static final String PROPERTY_NAME = "proprietaryPackages";
    private final String name;
    private final String[] includes;
    private final String[] excludes;
    private final boolean caseSensitive;

    public PathSelector(String includes, String excludes) {
        this(includes, excludes, null);
    }

    public PathSelector(String includes, String excludes, String name) {
        this(PathSelector.split(includes), PathSelector.split(excludes), name);
    }

    public PathSelector(String[] includes, String[] excludes, String name) {
        this.includes = PathSelector.normalizePatterns(includes);
        this.excludes = PathSelector.normalizePatterns(excludes);
        this.caseSensitive = true;
        this.name = name;
    }

    public static PathSelector forProprietaryPackages(String packages) {
        return new PathSelector(null, PathSelector.toPatterns(packages), PROPERTY_NAME);
    }

    public static PathSelector forProprietaryPackages(Collection<String> packages) {
        return new PathSelector(null, PathSelector.toPatterns(packages), PROPERTY_NAME);
    }

    @Override
    public Selector.Selection isSelected(String path) {
        path = PathSelector.normalizedPath(path);
        if (this.excludes.length > 0 && this.isMatched(path, this.excludes)) {
            return Selector.Selection.EXCLUDED;
        }
        if (this.includes.length > 0 && !this.isMatched(path, this.includes)) {
            return Selector.Selection.NOT_INCLUDED;
        }
        return Selector.Selection.SELECTED;
    }

    private boolean isMatched(String path, String[] patterns) {
        for (int i = patterns.length - 1; i >= 0; --i) {
            String pattern = patterns[i];
            if (!SelectorUtils.matchPath(pattern, path, this.caseSensitive)) continue;
            return true;
        }
        return false;
    }

    private static String[] split(String list) {
        if (list == null || list.isEmpty()) {
            return new String[0];
        }
        return list.split("[, ]+");
    }

    private static String[] normalizePatterns(String[] patterns) {
        String[] normalized;
        if (patterns != null) {
            normalized = new String[patterns.length];
            for (int i = patterns.length - 1; i >= 0; --i) {
                normalized[i] = PathSelector.normalizePattern(patterns[i]);
            }
        } else {
            normalized = new String[]{};
        }
        return normalized;
    }

    private static String normalizePattern(String pattern) {
        String normalized = PathSelector.normalizedPath(pattern);
        if (normalized.endsWith(File.separator)) {
            normalized = normalized + "**";
        } else if (normalized.startsWith("." + File.separator)) {
            normalized = normalized.substring(2);
        } else if (!normalized.isEmpty() && normalized.indexOf(File.separatorChar) < 0) {
            normalized = "**" + File.separator + normalized + File.separator + "**";
        }
        return normalized;
    }

    private static String normalizedPath(String path) {
        String normalized = path == null ? "" : path.replace(File.separatorChar == '/' ? (char)'\\' : '/', File.separatorChar);
        return normalized;
    }

    private static String[] toPatterns(String packages) {
        if (packages == null || packages.isEmpty()) {
            return new String[0];
        }
        String[] pkgs = packages.split("[, ]+");
        return PathSelector.toPatterns(Arrays.asList(pkgs));
    }

    private static String[] toPatterns(Collection<String> packages) {
        ArrayList<String> patterns = new ArrayList<String>();
        for (String pkg : packages) {
            if (pkg.indexOf(47) >= 0 || pkg.indexOf(92) >= 0) {
                patterns.add(pkg);
                continue;
            }
            String pattern = pkg.replace('.', '/');
            if (!pattern.startsWith("**/")) {
                pattern = "**/" + pattern;
            }
            if (!pattern.endsWith("/**")) {
                pattern = pattern + "/**";
            }
            patterns.add(pattern);
            pattern = pkg.replace("**", "*");
            patterns.add("**/" + pattern + "/**");
            patterns.add("**/" + pattern + ".*/**");
        }
        return patterns.toArray(new String[patterns.size()]);
    }

    @Override
    public String getName() {
        return this.name;
    }
}

