/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.archive;

import com.sonatype.insight.scan.archive.TFileUtils;
import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.fs.FsScheme;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupportedArchiveTypes {
    private final Logger log;

    public SupportedArchiveTypes() {
        this(LoggerFactory.getLogger(SupportedArchiveTypes.class));
    }

    public SupportedArchiveTypes(Logger log) {
        this.log = log;
    }

    public Set<String> getSupportedArchiveTypes(Properties configProperties) {
        TArchiveDetector detector = this.getArchiveDetector(configProperties);
        TreeSet<String> extensions = new TreeSet<String>();
        for (Map.Entry entry : detector.get().entrySet()) {
            extensions.add(((FsScheme)entry.getKey()).toString());
        }
        extensions.remove("file");
        extensions.remove("exe");
        return extensions;
    }

    public TArchiveDetector getArchiveDetector(Properties configProperties) {
        HashMap<TFileUtils.Driver, String> driverMappings = new HashMap<TFileUtils.Driver, String>();
        for (TFileUtils.Driver driver : TFileUtils.Driver.values()) {
            driverMappings.put(driver, SupportedArchiveTypes.getString(configProperties, driver.name().toLowerCase(Locale.ENGLISH)));
        }
        TreeSet<String> badExtensions = new TreeSet<String>();
        TArchiveDetector detector = TFileUtils.getArchiveDetector(driverMappings, badExtensions);
        if (!badExtensions.isEmpty()) {
            this.log.warn("Ignored invalid file extensions {}", badExtensions);
        }
        return detector;
    }

    private static String getString(Properties properties, String key) {
        if (properties == null) {
            return null;
        }
        Object value = properties.get(key);
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }
}

