/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.archive;

import com.sonatype.insight.scan.archive.InsightJarDriver;
import com.sonatype.insight.scan.archive.InsightReadOnlySfxDriver;
import com.sonatype.insight.scan.archive.InsightTarBZip2Driver;
import com.sonatype.insight.scan.archive.InsightTarDriver;
import com.sonatype.insight.scan.archive.InsightTarGZipDriver;
import com.sonatype.insight.scan.archive.InsightTarXZDriver;
import com.sonatype.insight.scan.archive.InsightZipDriver;
import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsScheme;
import de.schlichtherle.truezip.fs.archive.tar.TarBZip2Driver;
import de.schlichtherle.truezip.fs.archive.tar.TarDriver;
import de.schlichtherle.truezip.fs.archive.tar.TarGZipDriver;
import de.schlichtherle.truezip.fs.archive.tar.TarXZDriver;
import de.schlichtherle.truezip.fs.archive.zip.JarDriver;
import de.schlichtherle.truezip.fs.archive.zip.OdfDriver;
import de.schlichtherle.truezip.fs.archive.zip.ReadOnlySfxDriver;
import de.schlichtherle.truezip.fs.archive.zip.ZipDriver;
import de.schlichtherle.truezip.fs.sl.FsDriverLocator;
import de.schlichtherle.truezip.socket.IOPoolProvider;
import de.schlichtherle.truezip.socket.sl.IOPoolLocator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TFileUtils {
    public static long dataLength(TFile file) {
        TFile parent = file.getEnclArchive();
        if (parent == null) {
            return new File(file.getPath()).length();
        }
        TFile innerArchive = file.getInnerArchive();
        if (null != innerArchive) {
            return new TFile((File)file.getParentFile(), file.getName(), TArchiveDetector.NULL).length();
        }
        return file.getFile().length();
    }

    public static InputStream openInputStream(TFile file) throws IOException {
        if (file.isArchive()) {
            TFile parent = file.getEnclArchive();
            if (parent == null) {
                return new FileInputStream((File)file);
            }
            return new TFileInputStream((File)new TFile((File)file.getParentFile(), file.getName(), TArchiveDetector.NULL));
        }
        return new TFileInputStream((File)file);
    }

    public static TArchiveDetector getArchiveDetector(Map<Driver, String> driverMappings, Collection<String> badExtensions) {
        HashMap<FsScheme, InsightZipDriver> drivers = new HashMap<FsScheme, InsightZipDriver>(FsDriverLocator.SINGLETON.get());
        InsightZipDriver zipDriver = new InsightZipDriver((IOPoolProvider)IOPoolLocator.SINGLETON);
        InsightJarDriver jarDriver = new InsightJarDriver((IOPoolProvider)IOPoolLocator.SINGLETON);
        InsightReadOnlySfxDriver sfxDriver = new InsightReadOnlySfxDriver((IOPoolProvider)IOPoolLocator.SINGLETON);
        InsightTarDriver tarDriver = new InsightTarDriver((IOPoolProvider)IOPoolLocator.SINGLETON);
        InsightTarBZip2Driver tarBZip2Driver = new InsightTarBZip2Driver((IOPoolProvider)IOPoolLocator.SINGLETON);
        InsightTarGZipDriver tarGZipDriver = new InsightTarGZipDriver((IOPoolProvider)IOPoolLocator.SINGLETON);
        InsightTarXZDriver tarXZDriver = new InsightTarXZDriver((IOPoolProvider)IOPoolLocator.SINGLETON);
        Iterator it = drivers.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (entry.getValue() instanceof OdfDriver) {
                it.remove();
                continue;
            }
            if (entry.getValue() instanceof JarDriver) {
                entry.setValue((Object)((Object)jarDriver));
                continue;
            }
            if (entry.getValue() instanceof ReadOnlySfxDriver) {
                entry.setValue((Object)((Object)sfxDriver));
                continue;
            }
            if (entry.getValue() instanceof ZipDriver) {
                entry.setValue((Object)((Object)zipDriver));
                continue;
            }
            if (entry.getValue() instanceof TarBZip2Driver) {
                entry.setValue((Object)((Object)tarBZip2Driver));
                continue;
            }
            if (entry.getValue() instanceof TarGZipDriver) {
                entry.setValue((Object)((Object)tarGZipDriver));
                continue;
            }
            if (entry.getValue() instanceof TarXZDriver) {
                entry.setValue((Object)((Object)tarXZDriver));
                continue;
            }
            if (!(entry.getValue() instanceof TarDriver)) continue;
            entry.setValue((Object)((Object)tarDriver));
        }
        for (FsScheme fsScheme : TFileUtils.toSchemes("hpi,wsr,har,sar,aar,rar,mar,nbm,whl", null)) {
            drivers.put(fsScheme, jarDriver);
        }
        for (FsScheme fsScheme : TFileUtils.toSchemes("nupkg", null)) {
            drivers.put(fsScheme, zipDriver);
        }
        for (Map.Entry entry : driverMappings.entrySet()) {
            Object driver;
            List<FsScheme> schemes = TFileUtils.toSchemes((String)entry.getValue(), badExtensions);
            if (schemes.isEmpty()) continue;
            switch ((Driver)((Object)entry.getKey())) {
                case ZIP: {
                    driver = zipDriver;
                    break;
                }
                case JAR: {
                    driver = jarDriver;
                    break;
                }
                case TAR: {
                    driver = tarDriver;
                    break;
                }
                case TBZ: {
                    driver = tarBZip2Driver;
                    break;
                }
                case TGZ: {
                    driver = tarGZipDriver;
                    break;
                }
                case TXZ: {
                    driver = tarXZDriver;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown driver " + entry.getKey());
                }
            }
            for (FsScheme scheme : schemes) {
                drivers.put(scheme, (InsightZipDriver)((Object)driver));
            }
        }
        return new TArchiveDetector(() -> drivers, (String)null);
    }

    private static List<FsScheme> toSchemes(String suffixes, Collection<String> badExtensions) {
        ArrayList<FsScheme> schemes = new ArrayList<FsScheme>();
        if (suffixes != null && !suffixes.isEmpty()) {
            String[] tokens = suffixes.trim().split("[, ]+");
            for (int i = 0; i < tokens.length; ++i) {
                if (tokens[i].startsWith(".")) {
                    tokens[i] = tokens[i].substring(1);
                }
                try {
                    schemes.add(new FsScheme(tokens[i]));
                    continue;
                }
                catch (URISyntaxException e) {
                    if (badExtensions == null) continue;
                    badExtensions.add(tokens[i]);
                }
            }
        }
        return schemes;
    }

    public static String getDriverErrorMessage(FsModel model, IOException exception) {
        return String.format("Error loading file %s. Exception: %s", model.getMountPoint().getPath().getEntryName(), exception.getMessage());
    }

    public static enum Driver {
        ZIP,
        JAR,
        TAR,
        TGZ,
        TBZ,
        TXZ;

    }
}

