/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.hash;

import com.sonatype.insight.scan.hash.Hash;
import com.sonatype.insight.scan.hash.HashType;
import com.sonatype.insight.scan.hash.IMatchable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class MultiHash
implements IMatchable {
    private final Collection<Hash> hashes;
    private final HashType type;

    public MultiHash(HashType type, Collection<Hash> hashes) {
        this.type = type;
        ArrayList<Hash> sortedHashes = new ArrayList<Hash>(hashes);
        Collections.sort(sortedHashes);
        this.hashes = Collections.unmodifiableList(sortedHashes);
    }

    @Override
    public Collection<Hash> getHashes() {
        return this.hashes;
    }

    @Override
    public HashType getType() {
        return this.type;
    }

    public int hashCode() {
        return this.hashes.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MultiHash)) {
            return false;
        }
        MultiHash other = (MultiHash)obj;
        return this.type.equals((Object)other.type) && this.hashes.equals(other.hashes);
    }

    public String toString() {
        return "MULTIHASH " + this.hashes.toString();
    }
}

