/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.hash.internal;

import com.sonatype.insight.scan.hash.internal.Bytes;

public class JavaClassDigestStats {
    private static final int VALUE_SIZE = 16;
    public final int superclasses;
    public final int fields;
    public final int methods;
    public final int instructions;

    public JavaClassDigestStats(byte[] value) {
        this(Bytes.decodeUInt32(value, 0), Bytes.decodeUInt32(value, 4), Bytes.decodeUInt32(value, 8), Bytes.decodeUInt32(value, 12));
        if (value.length != 16) {
            throw new IllegalArgumentException();
        }
    }

    public JavaClassDigestStats(int superclasses, int fields, int methods, int instructions) {
        this.superclasses = superclasses;
        this.fields = fields;
        this.methods = methods;
        this.instructions = instructions;
    }

    public byte[] toByteArray() {
        byte[] result = new byte[16];
        Bytes.encodeInt32(result, 0, this.superclasses);
        Bytes.encodeInt32(result, 4, this.fields);
        Bytes.encodeInt32(result, 8, this.methods);
        Bytes.encodeInt32(result, 12, this.instructions);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("superclasses=").append(this.superclasses);
        sb.append(" fields=").append(this.fields);
        sb.append(" methods=").append(this.methods);
        sb.append(" instructions=").append(this.instructions);
        return sb.toString();
    }
}

