/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.hash.internal;

import com.sonatype.insight.scan.hash.internal.Bytes;

public class JavaMethodDigestStats {
    private static final int VALUE_SIZE = 4;
    public final int instructions;

    public JavaMethodDigestStats(int instructions) {
        this.instructions = instructions;
    }

    public JavaMethodDigestStats(byte[] value) {
        this(Bytes.decodeUInt32(value, 0));
        if (value.length != 4) {
            throw new IllegalArgumentException();
        }
    }

    public static byte[] asByteArray(int instructions) {
        if (instructions > 0) {
            return new JavaMethodDigestStats(instructions).toByteArray();
        }
        return null;
    }

    public byte[] toByteArray() {
        byte[] result = new byte[4];
        Bytes.encodeInt32(result, 0, this.instructions);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("instructions=").append(this.instructions);
        return sb.toString();
    }
}

