/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.hash.internal.asm;

import com.sonatype.insight.scan.hash.Hash;
import com.sonatype.insight.scan.hash.HashType;
import com.sonatype.insight.scan.hash.internal.JavaClassDigestStats;
import com.sonatype.insight.scan.hash.internal.JavaMethodDigestStats;
import com.sonatype.insight.scan.hash.internal.asm.AsmClassNode;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.objectweb.asm.v60.Asm4StyleClassWriter;
import org.objectweb.asm.v60.ClassWriter;
import org.objectweb.asm.v60.tree.ClassNode;
import org.objectweb.asm.v60.tree.FieldNode;
import org.objectweb.asm.v60.tree.InnerClassNode;
import org.objectweb.asm.v60.tree.InsnList;
import org.objectweb.asm.v60.tree.LocalVariableNode;
import org.objectweb.asm.v60.tree.MethodNode;
import org.objectweb.asm.v60.tree.TryCatchBlockNode;

public class Asm60ClassNode
extends AsmClassNode {
    final ClassNode classNode;

    Asm60ClassNode(ClassNode classNode) {
        this.classNode = classNode;
        this.normalizeBytecode();
    }

    @Override
    public boolean hasBytecode() {
        if (this.classNode.methods == null || this.classNode.methods.isEmpty()) {
            return false;
        }
        for (MethodNode m : this.classNode.methods) {
            if (m.instructions == null || m.instructions.getFirst() == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void stripMethodBodies() {
        if (this.classNode.methods != null) {
            ArrayList<MethodNode> filtered = new ArrayList<MethodNode>();
            for (MethodNode method : this.classNode.methods) {
                if ((method.access & 0x40) != 0) continue;
                method.instructions = new InsnList();
                method.tryCatchBlocks = new ArrayList<TryCatchBlockNode>();
                method.localVariables = new ArrayList<LocalVariableNode>();
                filtered.add(method);
            }
            this.classNode.methods = filtered;
        }
    }

    @Override
    public void stripMembers() {
        this.classNode.methods = Collections.emptyList();
        this.classNode.fields = Collections.emptyList();
    }

    @Override
    public Hash getClassHash(HashType hashType) throws NoSuchAlgorithmException {
        MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
        ClassWriter cw = this.newClassWriter();
        this.classNode.accept(cw);
        sha1.update(cw.toByteArray());
        JavaClassDigestStats stats = this.getClassStats();
        return new Hash(hashType, sha1.digest(), stats.toByteArray());
    }

    @Override
    public Set<Hash> getMethodHashes(HashType hashType) throws NoSuchAlgorithmException {
        LinkedHashSet<Hash> hashes = new LinkedHashSet<Hash>();
        for (MethodNode mn : this.classNode.methods) {
            hashes.add(this.toHash(mn, hashType));
        }
        return hashes;
    }

    @Override
    public Set<Hash> getFieldHashes(HashType hashType) throws NoSuchAlgorithmException {
        LinkedHashSet<Hash> hashes = new LinkedHashSet<Hash>();
        for (FieldNode fn : this.classNode.fields) {
            hashes.add(this.toHash(fn, hashType));
        }
        return hashes;
    }

    private Hash toHash(FieldNode fn, HashType hashType) throws NoSuchAlgorithmException {
        MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
        ClassWriter cw = this.newClassWriter();
        fn.accept(cw);
        sha1.update(cw.toByteArray());
        return new Hash(hashType, sha1.digest(), null);
    }

    private ClassWriter newClassWriter() {
        return new Asm4StyleClassWriter(0);
    }

    private Hash toHash(MethodNode mn, HashType hashType) throws NoSuchAlgorithmException {
        MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
        ClassWriter cw = this.newClassWriter();
        mn.accept(cw);
        sha1.update(cw.toByteArray());
        byte[] stats = JavaMethodDigestStats.asByteArray(mn.instructions.size());
        return new Hash(hashType, sha1.digest(), stats);
    }

    private void normalizeBytecode() {
        if (this.isSynthetic(this.classNode.access)) {
            this.classNode.access = this.normalizeClassAccess(this.classNode.access);
            this.classNode.outerClass = null;
        }
        this.classNode.version = 0;
        if (this.classNode.innerClasses != null) {
            Iterator<MethodNode> sorted = new ArrayList<InnerClassNode>(this.classNode.innerClasses);
            Collections.sort(sorted, new Comparator<InnerClassNode>(){

                @Override
                public int compare(InnerClassNode o1, InnerClassNode o2) {
                    return o1.name.compareTo(o2.name);
                }
            });
            this.classNode.innerClasses = sorted;
            for (InnerClassNode innerClass : this.classNode.innerClasses) {
                innerClass.access = this.normalizeClassAccess(innerClass.access);
            }
        }
        if ((this.classNode.access & 0x4000) != 0 && this.classNode.methods != null) {
            for (MethodNode method : this.classNode.methods) {
                if (!"values".equals(method.name)) continue;
                method.access &= 0xFFFFFFEF;
            }
        }
        if (this.classNode.outerClass != null && this.classNode.methods != null) {
            for (MethodNode method : this.classNode.methods) {
                if (!"<init>".equals(method.name)) continue;
                method.exceptions = new ArrayList<String>();
            }
        }
        if (this.classNode.fields != null && !this.classNode.fields.isEmpty()) {
            Iterator<FieldNode> iterFields = this.classNode.fields.iterator();
            while (iterFields.hasNext()) {
                FieldNode field = iterFields.next();
                if (!this.isSyntheticFieldOrMethod(field.access)) continue;
                iterFields.remove();
            }
        }
        if (this.classNode.methods != null && !this.classNode.methods.isEmpty()) {
            Iterator<MethodNode> iterMethods = this.classNode.methods.iterator();
            while (iterMethods.hasNext()) {
                MethodNode method;
                method = iterMethods.next();
                if (!this.isSyntheticFieldOrMethod(method.access)) continue;
                iterMethods.remove();
            }
        }
    }

    private JavaClassDigestStats getClassStats() {
        int superclasses = (this.hasSuperclass() ? 1 : 0) + this.size(this.classNode.interfaces);
        int fields = this.size(this.classNode.fields);
        int methods = this.size(this.classNode.methods);
        int instructions = 0;
        if (this.classNode.methods != null) {
            for (MethodNode m : this.classNode.methods) {
                if (m.instructions == null) continue;
                instructions += m.instructions.size();
            }
        }
        return new JavaClassDigestStats(superclasses, fields, methods, instructions);
    }

    private boolean hasSuperclass() {
        return this.classNode.superName != null && "java/lang/Class".equals(this.classNode.superName);
    }
}

