/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.hash.internal.asm;

import com.sonatype.insight.scan.hash.internal.asm.Relocation;
import org.objectweb.asm.v60.tree.ModuleNode;

public class Asm60RelocationModuleNode
extends ModuleNode {
    public Asm60RelocationModuleNode(String name, int access, String version) {
        super(Relocation.normalizeDottedName(name), access, version);
    }

    @Override
    public void visitMainClass(String mainClass) {
        super.visitMainClass(Relocation.normalizeName(mainClass));
    }

    @Override
    public void visitPackage(String packageName) {
        super.visitPackage(Relocation.normalizeName(packageName));
    }

    @Override
    public void visitExport(String packageName, int access, String ... modules) {
        this.normalizeModules(modules);
        super.visitExport(Relocation.normalizeName(packageName), access, modules);
    }

    @Override
    public void visitOpen(String packageName, int access, String ... modules) {
        this.normalizeModules(modules);
        super.visitOpen(Relocation.normalizeName(packageName), access, modules);
    }

    private void normalizeModules(String ... modules) {
        if (modules != null) {
            for (int i = 0; i < modules.length; ++i) {
                modules[i] = Relocation.normalizeDottedName(modules[i]);
            }
        }
    }

    @Override
    public void visitProvide(String service, String ... providers) {
        for (int i = 0; i < providers.length; ++i) {
            providers[i] = Relocation.normalizeName(providers[i]);
        }
        super.visitProvide(Relocation.normalizeName(service), providers);
    }

    @Override
    public void visitRequire(String module, int access, String version) {
        super.visitRequire(Relocation.normalizeDottedName(module), access, version);
    }

    @Override
    public void visitUse(String service) {
        super.visitUse(Relocation.normalizeName(service));
    }
}

