/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.hash.internal.asm;

import com.sonatype.insight.scan.hash.Hash;
import com.sonatype.insight.scan.hash.HashType;
import com.sonatype.insight.scan.hash.internal.JavaClassDigestStats;
import com.sonatype.insight.scan.hash.internal.JavaMethodDigestStats;
import com.sonatype.insight.scan.hash.internal.asm.Asm90ClassVisitor;
import com.sonatype.insight.scan.hash.internal.asm.AsmClassNode;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LocalVariableAnnotationNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;

public class Asm90ClassNode
extends AsmClassNode {
    final ClassNode classNode;
    private final int api;

    Asm90ClassNode(int api, ClassNode classNode) {
        this.classNode = classNode;
        this.api = api;
        this.normalizeBytecode();
    }

    @Override
    public boolean hasBytecode() {
        if (this.classNode.methods == null || this.classNode.methods.isEmpty()) {
            return false;
        }
        for (MethodNode m : this.classNode.methods) {
            if (m.instructions == null || m.instructions.getFirst() == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public Hash getClassHash(HashType hashType) throws NoSuchAlgorithmException {
        Asm90ClassVisitor cv = new Asm90ClassVisitor(this.api);
        this.classNode.accept(cv);
        JavaClassDigestStats stats = this.getClassStats();
        return new Hash(hashType, cv.digest(), stats.toByteArray());
    }

    @Override
    public Set<Hash> getMethodHashes(HashType hashType) throws NoSuchAlgorithmException {
        LinkedHashSet<Hash> hashes = new LinkedHashSet<Hash>();
        for (MethodNode mn : this.classNode.methods) {
            hashes.add(this.toHash(mn, hashType));
        }
        return hashes;
    }

    @Override
    public Set<Hash> getFieldHashes(HashType hashType) throws NoSuchAlgorithmException {
        LinkedHashSet<Hash> hashes = new LinkedHashSet<Hash>();
        for (FieldNode fn : this.classNode.fields) {
            hashes.add(this.toHash(fn, hashType));
        }
        return hashes;
    }

    @Override
    public void stripMethodBodies() {
        if (this.classNode.methods != null) {
            ArrayList<MethodNode> filtered = new ArrayList<MethodNode>();
            for (MethodNode method : this.classNode.methods) {
                if ((method.access & 0x40) != 0) continue;
                method.instructions = new InsnList();
                method.tryCatchBlocks = new ArrayList<TryCatchBlockNode>();
                method.localVariables = new ArrayList<LocalVariableNode>();
                method.visibleLocalVariableAnnotations = new ArrayList<LocalVariableAnnotationNode>();
                method.invisibleLocalVariableAnnotations = new ArrayList<LocalVariableAnnotationNode>();
                method.maxLocals = 0;
                method.maxStack = 0;
                filtered.add(method);
            }
            this.classNode.methods = filtered;
        }
    }

    @Override
    public void stripMembers() {
        this.classNode.methods = Collections.emptyList();
        this.classNode.fields = Collections.emptyList();
    }

    private Hash toHash(FieldNode fn, HashType hashType) throws NoSuchAlgorithmException {
        Asm90ClassVisitor cv = new Asm90ClassVisitor(this.api);
        fn.accept(cv);
        return new Hash(hashType, cv.digest(), null);
    }

    private Hash toHash(MethodNode mn, HashType hashType) throws NoSuchAlgorithmException {
        Asm90ClassVisitor cv = new Asm90ClassVisitor(this.api);
        mn.accept(cv);
        byte[] stats = JavaMethodDigestStats.asByteArray(mn.instructions.size());
        return new Hash(hashType, cv.digest(), stats);
    }

    private void normalizeBytecode() {
        if (this.isSynthetic(this.classNode.access)) {
            this.classNode.access = this.normalizeClassAccess(this.classNode.access);
            this.classNode.outerClass = null;
        }
        this.classNode.version = 0;
        if (this.classNode.innerClasses != null) {
            Iterator<Object> iterInnerClasses = this.classNode.innerClasses.iterator();
            while (iterInnerClasses.hasNext()) {
                InnerClassNode innerClassNode = iterInnerClasses.next();
                if (!this.isSynthetic(innerClassNode.access)) continue;
                iterInnerClasses.remove();
            }
        }
        if ((this.classNode.access & 0x4000) != 0 && this.classNode.methods != null) {
            for (MethodNode method : this.classNode.methods) {
                if (!"values".equals(method.name)) continue;
                method.access &= 0xFFFFFFEF;
            }
        }
        if (this.classNode.outerClass != null && this.classNode.methods != null) {
            for (MethodNode method : this.classNode.methods) {
                if (!"<init>".equals(method.name)) continue;
                method.exceptions = new ArrayList<String>();
            }
        }
        if (this.classNode.fields != null && !this.classNode.fields.isEmpty()) {
            Iterator<FieldNode> iterFields = this.classNode.fields.iterator();
            while (iterFields.hasNext()) {
                FieldNode field = iterFields.next();
                if (!this.isSynthetic(field.access)) continue;
                iterFields.remove();
            }
        }
        if (this.classNode.methods != null && !this.classNode.methods.isEmpty()) {
            Iterator<MethodNode> iterMethods = this.classNode.methods.iterator();
            while (iterMethods.hasNext()) {
                MethodNode method;
                method = iterMethods.next();
                if (!this.isSynthetic(method.access)) continue;
                iterMethods.remove();
            }
        }
    }

    private JavaClassDigestStats getClassStats() {
        int superclasses = (this.hasSuperclass() ? 1 : 0) + this.size(this.classNode.interfaces);
        int fields = this.size(this.classNode.fields);
        int methods = this.size(this.classNode.methods);
        int instructions = 0;
        if (this.classNode.methods != null) {
            for (MethodNode m : this.classNode.methods) {
                if (m.instructions == null) continue;
                instructions += m.instructions.size();
            }
        }
        return new JavaClassDigestStats(superclasses, fields, methods, instructions);
    }

    private boolean hasSuperclass() {
        return this.classNode.superName != null && !"java/lang/Object".equals(this.classNode.superName);
    }
}

