/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.hash.internal.asm;

import com.sonatype.insight.scan.hash.internal.asm.Asm90AnnotationVisitor;
import com.sonatype.insight.scan.hash.internal.asm.DefaultAnnotationData;
import com.sonatype.insight.scan.hash.internal.asm.FieldMethodAnnotationData;
import com.sonatype.insight.scan.hash.internal.asm.LocalVariableAnnotationData;
import com.sonatype.insight.scan.hash.internal.asm.MethodData;
import com.sonatype.insight.scan.hash.internal.asm.ParameterAnnotationData;
import com.sonatype.insight.scan.hash.internal.asm.TypeAnnotationData;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.TypePath;

public class Asm90MethodVisitor
extends MethodVisitor {
    private final MethodData methodData;

    Asm90MethodVisitor(int api, MethodData methodData) {
        super(api);
        this.methodData = methodData;
    }

    @Override
    public void visitParameter(String name, int access) {
        this.methodData.addParameter(name, access);
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        this.methodData.setMaxs(maxStack, maxLocals);
    }

    @Override
    public void visitInsn(int opcode) {
        this.methodData.addInstruction(opcode, new Object[0]);
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        this.methodData.addInstruction(opcode, operand);
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        this.methodData.addInstruction(opcode, var);
    }

    @Override
    public void visitTypeInsn(int opcode, String type) {
        this.methodData.addInstruction(opcode, type);
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
        this.methodData.addInstruction(opcode, owner, name, descriptor);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        this.methodData.addInstruction(opcode, owner, name, descriptor, isInterface);
    }

    @Override
    public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
        this.methodData.addInstruction(186, name, descriptor, bootstrapMethodHandle, bootstrapMethodArguments);
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        this.methodData.addInstruction(opcode, label);
    }

    @Override
    public void visitIincInsn(int var, int increment) {
        this.methodData.addInstruction(132, var, increment);
    }

    @Override
    public void visitMultiANewArrayInsn(String descriptor, int numDimensions) {
        this.methodData.addInstruction(197, descriptor, numDimensions);
    }

    @Override
    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.methodData.addTryCatchBlock(start, end, handler, type);
    }

    @Override
    public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
        this.methodData.addLocalVariable(name, descriptor, signature, start, end, index);
    }

    @Override
    public void visitLineNumber(int line, Label start) {
    }

    @Override
    public void visitLabel(Label label) {
        this.methodData.addLabel(label);
    }

    @Override
    public AnnotationVisitor visitAnnotationDefault() {
        return new Asm90AnnotationVisitor(this.api, this.methodData.setAnnotationDefault(new DefaultAnnotationData()));
    }

    @Override
    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        return new Asm90AnnotationVisitor(this.api, this.methodData.addAnnotation(new FieldMethodAnnotationData(descriptor, visible)));
    }

    @Override
    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        return new Asm90AnnotationVisitor(this.api, this.methodData.addTypeAnnotation(new TypeAnnotationData(typeRef, typePath, descriptor, visible)));
    }

    @Override
    public void visitAnnotableParameterCount(int parameterCount, boolean visible) {
    }

    @Override
    public AnnotationVisitor visitParameterAnnotation(int parameter, String descriptor, boolean visible) {
        return new Asm90AnnotationVisitor(this.api, this.methodData.addParameterAnnotation(new ParameterAnnotationData(parameter, descriptor, visible)));
    }

    @Override
    public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        return new Asm90AnnotationVisitor(this.api, this.methodData.addInsnAnnotation(new TypeAnnotationData(typeRef, typePath, descriptor, visible)));
    }

    @Override
    public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        return new Asm90AnnotationVisitor(this.api, this.methodData.addTryCatchAnnotation(new TypeAnnotationData(typeRef, typePath, descriptor, visible)));
    }

    @Override
    public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String descriptor, boolean visible) {
        return new Asm90AnnotationVisitor(this.api, this.methodData.addLocalVariableAnnotation(new LocalVariableAnnotationData(typeRef, typePath, start, end, index, descriptor, visible)));
    }

    @Override
    public void visitLdcInsn(Object value) {
        this.methodData.addInstruction(18, value);
    }

    @Override
    public void visitAttribute(Attribute attribute) {
    }

    @Override
    public void visitCode() {
    }

    @Override
    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
    }

    @Override
    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        this.methodData.addInstruction(170, min, max, dflt, labels);
    }

    @Override
    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.methodData.addInstruction(171, dflt, keys, labels);
    }
}

