/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.hash.internal.asm;

import com.sonatype.insight.scan.hash.internal.asm.ClassFileData;
import com.sonatype.insight.scan.hash.internal.asm.ClassFileDigest;
import com.sonatype.insight.scan.hash.internal.asm.ClassHeaderData;
import com.sonatype.insight.scan.hash.internal.asm.DataDigestUtils;
import com.sonatype.insight.scan.hash.internal.asm.FieldData;
import com.sonatype.insight.scan.hash.internal.asm.FieldMethodAnnotationData;
import com.sonatype.insight.scan.hash.internal.asm.InnerClassData;
import com.sonatype.insight.scan.hash.internal.asm.ListPopulator;
import com.sonatype.insight.scan.hash.internal.asm.MethodData;
import com.sonatype.insight.scan.hash.internal.asm.ModuleData;
import com.sonatype.insight.scan.hash.internal.asm.OuterClassData;
import com.sonatype.insight.scan.hash.internal.asm.TypeAnnotationData;

class ClassData
implements ClassFileData {
    ClassHeaderData classHeader;
    ModuleData module;
    OuterClassData outerClass;
    ListPopulator<FieldData> fields = new ListPopulator<FieldData>(FieldData.COMPARATOR);
    ListPopulator<MethodData> methods = new ListPopulator<MethodData>(MethodData.COMPARATOR);
    ListPopulator<InnerClassData> innerClasses = new ListPopulator<InnerClassData>(InnerClassData.COMPARATOR);
    ListPopulator<FieldMethodAnnotationData> annotations = new ListPopulator<FieldMethodAnnotationData>(FieldMethodAnnotationData.COMPARATOR);
    ListPopulator<TypeAnnotationData> typeAnnotations = new ListPopulator<TypeAnnotationData>(TypeAnnotationData.COMPARATOR);
    ListPopulator<String> permittedSubclasses = new ListPopulator<String>(DataDigestUtils.DUPLICATABLE_STRING_COMPARATOR);

    ClassData() {
    }

    void setHeader(ClassHeaderData classHeader) {
        this.classHeader = classHeader;
    }

    FieldData addField(FieldData field) {
        return this.fields.add(field);
    }

    MethodData addMethod(MethodData method) {
        return this.methods.add(method);
    }

    void addInnerClass(InnerClassData innerClass) {
        this.innerClasses.add(innerClass);
    }

    ModuleData setModule(ModuleData module) {
        this.module = module;
        return module;
    }

    void setOuterClass(OuterClassData outerClass) {
        this.outerClass = outerClass;
    }

    FieldMethodAnnotationData addAnnotation(FieldMethodAnnotationData annotation) {
        return this.annotations.add(annotation);
    }

    TypeAnnotationData addTypeAnnotation(TypeAnnotationData typeAnnotation) {
        return this.typeAnnotations.add(typeAnnotation);
    }

    void addPermittedSubclass(String permittedSubclass) {
        this.permittedSubclasses.add(permittedSubclass);
    }

    @Override
    public void digest(ClassFileDigest digester) {
        digester.putData(this.classHeader);
        digester.putData(this.module);
        digester.putData(this.outerClass);
        digester.putData(this.fields);
        digester.putData(this.methods);
        digester.putData(this.innerClasses);
        digester.putData(this.annotations);
        digester.putData(this.typeAnnotations);
        digester.putStrings(this.permittedSubclasses);
    }
}

