/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.hash.internal.asm;

import org.objectweb.asm.Handle;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureWriter;
import org.objectweb.asm.v71.Type;

public class Relocation {
    public static String normalizeName(String name) {
        return Relocation.normalizeName(name, '/');
    }

    public static String normalizeDottedName(String name) {
        return Relocation.normalizeName(name, '.');
    }

    private static String normalizeName(String name, char separator) {
        if (name == null || "".equals(name.trim())) {
            return name;
        }
        if (name.startsWith("java" + separator) || name.startsWith("javax" + separator)) {
            return name;
        }
        int idx = name.lastIndexOf(separator);
        return idx > 0 ? name.substring(idx + 1) : name;
    }

    public static String[] normalizeNames(String[] names) {
        if (names == null || names.length == 0) {
            return names;
        }
        String[] result = new String[names.length];
        for (int i = 0; i < names.length; ++i) {
            result[i] = Relocation.normalizeName(names[i]);
        }
        return result;
    }

    public static String normalizeDesc(String desc) {
        if (desc == null || "".equals(desc.trim())) {
            return desc;
        }
        SignatureReader sr = new SignatureReader(desc);
        NormalizingSignatureWriter sw = new NormalizingSignatureWriter();
        sr.accept(sw);
        return sw.toString();
    }

    public static org.objectweb.asm.v71.Handle normalizeHandle(org.objectweb.asm.v71.Handle handle) {
        if (handle == null) {
            return null;
        }
        return new org.objectweb.asm.v71.Handle(handle.getTag(), Relocation.normalizeName(handle.getOwner()), handle.getName(), Relocation.normalizeDesc(handle.getDesc()), handle.isInterface());
    }

    public static Handle normalizeHandle(Handle handle) {
        if (handle == null) {
            return null;
        }
        return new Handle(handle.getTag(), Relocation.normalizeName(handle.getOwner()), handle.getName(), Relocation.normalizeDesc(handle.getDesc()), handle.isInterface());
    }

    public static Type normalizeType(Type type) {
        if (type == null) {
            return null;
        }
        switch (type.getSort()) {
            case 11: {
                return Type.getMethodType(Relocation.normalizeDesc(type.getDescriptor()));
            }
            case 10: {
                return Type.getObjectType(Relocation.normalizeName(type.getInternalName()));
            }
        }
        return type;
    }

    public static org.objectweb.asm.Type normalizeType(org.objectweb.asm.Type type) {
        if (type == null) {
            return null;
        }
        switch (type.getSort()) {
            case 11: {
                return org.objectweb.asm.Type.getMethodType(Relocation.normalizeDesc(type.getDescriptor()));
            }
            case 10: {
                return org.objectweb.asm.Type.getObjectType(Relocation.normalizeName(type.getInternalName()));
            }
        }
        return type;
    }

    private static class NormalizingSignatureWriter
    extends SignatureWriter {
        private NormalizingSignatureWriter() {
        }

        @Override
        public void visitClassType(String name) {
            super.visitClassType(Relocation.normalizeName(name));
        }

        @Override
        public void visitFormalTypeParameter(String name) {
            super.visitFormalTypeParameter(Relocation.normalizeName(name));
        }

        @Override
        public void visitInnerClassType(String name) {
            super.visitInnerClassType(Relocation.normalizeName(name));
        }

        @Override
        public void visitTypeVariable(String name) {
            super.visitTypeVariable(Relocation.normalizeName(name));
        }
    }
}

