/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse;

import com.sonatype.insight.ide.eclipse.internal.Messages;
import com.sonatype.insight.ide.eclipse.internal.rest.InsightClientManager;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.sonatype.clm.ide.eclipse";
    public static final String PREF_SASH_WEIGHT1 = "dependenciesView.sashWeight1";
    public static final String PREF_SASH_WEIGHT2 = "dependenciesView.sashWeight2";
    public static Activator plugin;
    private ServiceTracker proxyServiceTracker;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.proxyServiceTracker = new ServiceTracker(context, IProxyService.class.getName(), null);
        this.proxyServiceTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        InsightClientManager insightClientManager = InsightClientManager.getInstance();
        insightClientManager.sendUserInteractionTelemetry();
        insightClientManager.closeClient();
        plugin = null;
        try {
            this.proxyServiceTracker.close();
            this.proxyServiceTracker = null;
        }
        finally {
            super.stop(context);
        }
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static void addImageDescriptor(String key, ImageDescriptor descriptor) {
        plugin.getImageRegistry().put(key, descriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image getImage(String path) {
        ImageRegistry imageRegistry;
        ImageRegistry imageRegistry2 = imageRegistry = plugin.getImageRegistry();
        synchronized (imageRegistry2) {
            Image image = imageRegistry.get(path);
            if (image != null) {
                return image;
            }
            image = Activator.getImageDescriptor(path).createImage();
            imageRegistry.put(path, image);
            return image;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image getImage(ImageDescriptor descriptor) {
        ImageRegistry imageRegistry;
        ImageRegistry imageRegistry2 = imageRegistry = plugin.getImageRegistry();
        synchronized (imageRegistry2) {
            Image image = imageRegistry.get(descriptor.toString());
            if (image != null) {
                return image;
            }
            imageRegistry.put(descriptor.toString(), descriptor);
            return imageRegistry.get(descriptor.toString());
        }
    }

    public static final void openUrl(String url) {
        Activator.openUrl(url, false);
    }

    public static final void openUrl(String url, boolean external) {
        try {
            IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
            IWebBrowser browser = !external && support.isInternalWebBrowserAvailable() ? support.createBrowser(46, null, url, url) : support.getExternalBrowser();
            browser.openURL(new URL(url));
        }
        catch (PartInitException partInitException) {
            StatusManager.getManager().handle((CoreException)partInitException, PLUGIN_ID);
        }
        catch (MalformedURLException malformedURLException) {
            StatusManager.getManager().handle((IStatus)new Status(4, PLUGIN_ID, NLS.bind((String)Messages.Activator_invalidURL, (Object)url), (Throwable)malformedURLException), 3);
        }
    }

    public static IProxyService getProxyService() {
        return (IProxyService)Activator.plugin.proxyServiceTracker.getService();
    }

    public static void setDefaultRepositories(String[] defaultRepositories) {
        StringBuilder pref = new StringBuilder();
        String[] stringArray = defaultRepositories;
        int n = defaultRepositories.length;
        int n2 = 0;
        while (n2 < n) {
            String repo = stringArray[n2];
            if (pref.length() > 0) {
                pref.append(',');
            }
            pref.append(repo);
            ++n2;
        }
        InstanceScope.INSTANCE.getNode(PLUGIN_ID).put("com.sonatype.clm.ide.eclipse.eclipse.default.repo", pref.toString());
    }

    public static boolean getBooleanPreference(String key, boolean defaultValue) {
        return InstanceScope.INSTANCE.getNode(PLUGIN_ID).getBoolean(key, defaultValue);
    }

    public static void setBooleanPreference(String key, boolean value) {
        InstanceScope.INSTANCE.getNode(PLUGIN_ID).putBoolean(key, value);
    }

    public static String[] getDefaultRepositories() {
        String repos = InstanceScope.INSTANCE.getNode(PLUGIN_ID).get("com.sonatype.clm.ide.eclipse.eclipse.default.repo", null);
        if (repos != null) {
            return repos.split(",");
        }
        return new String[0];
    }

    public static String getStringPreference(String key, String defaultValue) {
        return InstanceScope.INSTANCE.getNode(PLUGIN_ID).get(key, defaultValue);
    }

    public static void setStringPreference(String key, String value) {
        if (value == null) {
            InstanceScope.INSTANCE.getNode(PLUGIN_ID).remove(key);
        } else {
            InstanceScope.INSTANCE.getNode(PLUGIN_ID).put(key, value);
        }
    }

    public static String getVersion() {
        return plugin.getBundle().getVersion().toString();
    }

    public static <T> T getExtension(String point) throws CoreException {
        IConfigurationElement[] elements;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(point);
        if (elements.length != 0) {
            IConfigurationElement element = iConfigurationElementArray[0];
            return (T)element.createExecutableExtension("class");
        }
        return null;
    }
}

