/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal;

import java.io.File;
import java.util.Objects;

public final class ArtifactKey {
    private final String groupId;
    private final String artifactId;
    private final String extension;
    private final String classifier;
    private final String version;

    public ArtifactKey(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.extension = null;
        this.classifier = null;
    }

    public ArtifactKey(String groupId, String artifactId, String version, String classifier, String extension) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.classifier = classifier;
        this.extension = extension;
    }

    public ArtifactKey(String groupId, String artifactId, String version, String classifier, File file) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.classifier = classifier != null ? classifier : "";
        String name = file.getName();
        int i = name.indexOf(artifactId);
        i = i < 0 ? i : name.indexOf(version, i + artifactId.length());
        i = i < 0 ? name.lastIndexOf(46) : name.indexOf(46, i + version.length());
        this.extension = i < 0 ? "" : name.substring(i + 1);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isSameGav(ArtifactKey key) {
        return key != null && Objects.equals(this.groupId, key.groupId) && Objects.equals(this.artifactId, key.artifactId) && Objects.equals(this.version, key.version);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ArtifactKey)) {
            return false;
        }
        ArtifactKey that = (ArtifactKey)obj;
        return Objects.equals(this.artifactId, that.artifactId) && Objects.equals(this.groupId, that.groupId) && Objects.equals(this.version, that.version) && Objects.equals(this.extension, that.extension) && Objects.equals(this.classifier, that.classifier);
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId, this.extension, this.classifier, this.version);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(this.groupId != null ? this.groupId : "");
        buffer.append(':').append(this.artifactId != null ? this.artifactId : "");
        buffer.append(':').append(this.extension != null ? this.extension : "");
        if (this.classifier != null && !this.classifier.isEmpty()) {
            buffer.append(':').append(this.classifier);
        }
        buffer.append(':').append(this.version != null ? this.version : "");
        return buffer.toString();
    }
}

