/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.edit;

import com.sonatype.insight.ide.eclipse.internal.edit.RandomUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.m2e.core.ui.internal.editing.PomEdits;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CollectVersionPropertiesOperation
implements PomEdits.Operation {
    private List<String> activatedProfiles;
    private Map<String, List<String>> result = new HashMap<String, List<String>>();
    private final Map<String, List<String>> definedProperties = new HashMap<String, List<String>>();

    public CollectVersionPropertiesOperation(List<String> activatedProfiles) {
        this.activatedProfiles = activatedProfiles;
    }

    public void process(Document document) {
        Element rootElement = document.getDocumentElement();
        Element profiles = PomEdits.findChild((Element)rootElement, (String)"profiles");
        if (profiles != null && this.activatedProfiles != null && this.activatedProfiles.size() > 0) {
            for (String profileId : this.activatedProfiles) {
                Element profile = PomEdits.findChild((Element)profiles, (String)"profile", (PomEdits.Matcher[])new PomEdits.Matcher[]{PomEdits.childEquals((String)"id", (String)profileId)});
                if (profile == null) continue;
                List deps = PomEdits.findChilds((Element)PomEdits.findChild((Element)profile, (String)"dependencies"), (String)"dependency");
                for (Element dep : deps) {
                    this.processDependency(dep);
                }
                deps = PomEdits.findChilds((Element)PomEdits.findChild((Element)PomEdits.findChild((Element)profile, (String)"dependencyManagement"), (String)"dependencies"), (String)"dependency");
                for (Element dep : deps) {
                    this.processDependency(dep);
                }
                this.processProperties(profileId, profile);
            }
        }
        List deps = PomEdits.findChilds((Element)PomEdits.findChild((Element)rootElement, (String)"dependencies"), (String)"dependency");
        for (Element dep : deps) {
            this.processDependency(dep);
        }
        deps = PomEdits.findChilds((Element)PomEdits.findChild((Element)PomEdits.findChild((Element)rootElement, (String)"dependencyManagement"), (String)"dependencies"), (String)"dependency");
        for (Element dep : deps) {
            this.processDependency(dep);
        }
        this.processProperties(null, rootElement);
    }

    private void processProperties(String profileId, Element parent) {
        NodeList nl;
        Element props = PomEdits.findChild((Element)parent, (String)"properties");
        if (props != null && (nl = props.getChildNodes()) != null) {
            int i = 0;
            while (i < nl.getLength()) {
                if (nl.item(i) instanceof Element) {
                    RandomUtils.addToMap(this.getDefinedProperties(), ((Element)nl.item(i)).getNodeName(), profileId);
                }
                ++i;
            }
        }
    }

    private void processDependency(Element dep) {
        String versionText;
        Element version = PomEdits.findChild((Element)dep, (String)"version");
        if (version != null && (versionText = PomEdits.getTextValue((Node)version)).startsWith("${") && versionText.endsWith("}")) {
            String propertyName = versionText.substring("${".length(), versionText.length() - "}".length());
            String rawGroupId = PomEdits.getTextValue((Node)PomEdits.findChild((Element)dep, (String)"groupId"));
            String rawArtifactId = PomEdits.getTextValue((Node)PomEdits.findChild((Element)dep, (String)"artifactId"));
            this.addToResult(propertyName, rawGroupId, rawArtifactId);
        }
    }

    private void addToResult(String property, String rawGroupId, String rawArtifactId) {
        List<String> list = this.result.get(property);
        if (list == null) {
            list = new ArrayList<String>();
            this.result.put(property, list);
        }
        list.add(rawGroupId + ":" + rawArtifactId);
    }

    public Map<String, List<String>> getResult() {
        return this.result;
    }

    public Map<String, List<String>> getDefinedProperties() {
        return this.definedProperties;
    }
}

