/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.edit;

import com.sonatype.insight.ide.eclipse.internal.edit.RandomUtils;
import com.sonatype.insight.ide.eclipse.internal.ui.elements.UIDependencyElement;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.eclipse.m2e.core.ui.internal.editing.PomEdits;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FindDependencyOperation
implements PomEdits.Operation {
    private boolean found = false;
    private boolean managed = false;
    private String profile = null;
    private String rawGroupId = null;
    private String rawArtifactId = null;
    private String rawVersion = null;
    private String rawPropertyValue = null;
    private String propertyName = null;
    private boolean propertyDefined = false;
    private String propertyProfile = null;
    private final MavenProject project;
    private final List<String> activatedProfiles;
    private final String resolvedGroupId;
    private final String resolvedArtifactId;
    private final String newVersion;
    private UIDependencyElement element;

    public FindDependencyOperation(UIDependencyElement el, MavenProject project, List<String> activatedProfiles, String newVersion) {
        this(project, el.getMavenArtifactKey().getGroupId(), el.getMavenArtifactKey().getArtifactId(), activatedProfiles, newVersion);
        this.element = el;
    }

    public FindDependencyOperation(MavenProject project, String groupId, String artifactId, List<String> activatedProfiles, String newVersion) {
        this.project = project;
        this.activatedProfiles = activatedProfiles;
        this.resolvedGroupId = groupId;
        this.resolvedArtifactId = artifactId;
        this.newVersion = newVersion;
    }

    public void process(Document document) {
        Element profile;
        Element rootElement = document.getDocumentElement();
        Element profiles = PomEdits.findChild((Element)rootElement, (String)"profiles");
        if (profiles != null && this.activatedProfiles != null && this.activatedProfiles.size() > 0) {
            for (String profileId : this.activatedProfiles) {
                profile = PomEdits.findChild((Element)profiles, (String)"profile", (PomEdits.Matcher[])new PomEdits.Matcher[]{PomEdits.childEquals((String)"id", (String)profileId)});
                if (profile == null) continue;
                this.findDependency(profile);
                if (!this.found) continue;
                this.profile = profileId;
                break;
            }
        }
        if (!this.found) {
            this.findDependency(rootElement);
        }
        if (!this.found) {
            if (profiles != null && this.activatedProfiles != null && this.activatedProfiles.size() > 0) {
                for (String profileId : this.activatedProfiles) {
                    profile = PomEdits.findChild((Element)profiles, (String)"profile", (PomEdits.Matcher[])new PomEdits.Matcher[]{PomEdits.childEquals((String)"id", (String)profileId)});
                    if (profile == null) continue;
                    this.findManaged(profile);
                    if (!this.found) continue;
                    this.profile = profileId;
                    break;
                }
            }
            if (!this.found) {
                this.findManaged(rootElement);
            }
        }
        if (!this.propertyDefined && this.propertyName != null) {
            Element prop;
            if (profiles != null && this.activatedProfiles != null && this.activatedProfiles.size() > 0) {
                for (String profileId : this.activatedProfiles) {
                    Element prop2;
                    profile = PomEdits.findChild((Element)profiles, (String)"profile", (PomEdits.Matcher[])new PomEdits.Matcher[]{PomEdits.childEquals((String)"id", (String)profileId)});
                    if (profile == null || (prop2 = PomEdits.findChild((Element)PomEdits.findChild((Element)profile, (String)"properties"), (String)this.propertyName)) == null) continue;
                    this.propertyDefined = true;
                    this.propertyProfile = profileId;
                    this.rawPropertyValue = PomEdits.getTextValue((Node)prop2);
                }
            }
            if (!this.propertyDefined && (prop = PomEdits.findChild((Element)PomEdits.findChild((Element)rootElement, (String)"properties"), (String)this.propertyName)) != null) {
                this.propertyDefined = true;
                this.propertyProfile = null;
                this.rawPropertyValue = PomEdits.getTextValue((Node)prop);
            }
        }
    }

    private void findManaged(Element rootElement) {
        Element version;
        Element deps = PomEdits.findChild((Element)PomEdits.findChild((Element)rootElement, (String)"dependencyManagement"), (String)"dependencies");
        Element dep = PomEdits.findChild((Element)deps, (String)"dependency", (PomEdits.Matcher[])new PomEdits.Matcher[]{RandomUtils.interpolatedChildEquals("groupId", this.getResolvedGroupId(), this.project), RandomUtils.interpolatedChildEquals("artifactId", this.getResolvedArtifactId(), this.project)});
        if (dep != null && (version = PomEdits.findChild((Element)dep, (String)"version")) != null) {
            String versionText = PomEdits.getTextValue((Node)version);
            if (versionText.startsWith("${") && versionText.endsWith("}")) {
                this.propertyName = versionText.substring("${".length(), versionText.length() - "}".length());
            }
            this.managed = true;
            this.rawGroupId = PomEdits.getTextValue((Node)PomEdits.findChild((Element)dep, (String)"groupId"));
            this.rawArtifactId = PomEdits.getTextValue((Node)PomEdits.findChild((Element)dep, (String)"artifactId"));
            this.rawVersion = versionText;
            this.found = true;
        }
    }

    private void findDependency(Element rootElement) {
        Element deps = PomEdits.findChild((Element)rootElement, (String)"dependencies");
        Element dep = PomEdits.findChild((Element)deps, (String)"dependency", (PomEdits.Matcher[])new PomEdits.Matcher[]{RandomUtils.interpolatedChildEquals("groupId", this.getResolvedGroupId(), this.project), RandomUtils.interpolatedChildEquals("artifactId", this.getResolvedArtifactId(), this.project)});
        if (dep != null) {
            Element version = PomEdits.findChild((Element)dep, (String)"version");
            if (version == null) {
                this.managed = true;
            } else {
                String versionText = PomEdits.getTextValue((Node)version);
                if (versionText.startsWith("${") && versionText.endsWith("}")) {
                    this.propertyName = versionText.substring("${".length(), versionText.length() - "}".length());
                }
                this.rawGroupId = PomEdits.getTextValue((Node)PomEdits.findChild((Element)dep, (String)"groupId"));
                this.rawArtifactId = PomEdits.getTextValue((Node)PomEdits.findChild((Element)dep, (String)"artifactId"));
                this.rawVersion = versionText;
                this.found = true;
            }
        }
    }

    public void resetState() {
        this.found = false;
        this.managed = false;
        this.profile = null;
        this.rawGroupId = null;
        this.rawArtifactId = null;
        this.rawVersion = null;
        this.propertyName = null;
        this.propertyDefined = false;
        this.propertyProfile = null;
        this.rawPropertyValue = null;
    }

    public boolean isFound() {
        return this.found;
    }

    public boolean isManaged() {
        return this.managed;
    }

    public String getProfile() {
        return this.profile;
    }

    public String getRawGroupId() {
        return this.rawGroupId;
    }

    public String getRawArtifactId() {
        return this.rawArtifactId;
    }

    public String getRawVersion() {
        return this.rawVersion;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public boolean isPropertyDefined() {
        return this.propertyDefined;
    }

    public String getPropertyProfile() {
        return this.propertyProfile;
    }

    public String getRawPropertyValue() {
        return this.rawPropertyValue;
    }

    public String getResolvedGroupId() {
        return this.resolvedGroupId;
    }

    public String getResolvedArtifactId() {
        return this.resolvedArtifactId;
    }

    public String getNewVersion() {
        return this.newVersion;
    }

    public UIDependencyElement getElement() {
        return this.element;
    }
}

