/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.edit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.PrefixedObjectValueSource;
import org.codehaus.plexus.interpolation.PropertiesBasedValueSource;
import org.codehaus.plexus.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.eclipse.m2e.core.ui.internal.editing.PomEdits;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class RandomUtils {
    public static String simpleInterpolate(MavenProject project, String text) {
        if (text != null && text.contains("${")) {
            if (project == null) {
                return null;
            }
            Properties props = project.getProperties();
            RegexBasedInterpolator inter = new RegexBasedInterpolator();
            if (props != null) {
                inter.addValueSource((ValueSource)new PropertiesBasedValueSource(props));
            }
            inter.addValueSource((ValueSource)new PrefixedObjectValueSource(Arrays.asList("pom.", "project."), (Object)project.getModel(), false));
            try {
                text = inter.interpolate(text);
            }
            catch (InterpolationException interpolationException) {
                text = null;
            }
        }
        return text;
    }

    public static PomEdits.Matcher interpolatedChildEquals(final String elementName, final String matchingValue, final MavenProject project) {
        return new PomEdits.Matcher(){

            public boolean matches(Element child) {
                String toMatch = PomEdits.getTextValue((Node)PomEdits.findChild((Element)child, (String)elementName));
                return (toMatch = RandomUtils.simpleInterpolate(project, toMatch)) != null && toMatch.trim().equals(matchingValue);
            }
        };
    }

    public static <K, L> void addToMap(Map<K, List<L>> map, K key, L value) {
        List<L> upds = map.get(key);
        if (upds == null) {
            upds = new ArrayList<L>();
            map.put(key, upds);
        }
        upds.add(value);
    }

    public static <K, L> void addToMapSet(Map<K, Set<L>> map, K key, L value) {
        Set<L> upds = map.get(key);
        if (upds == null) {
            upds = new HashSet<L>();
            map.put(key, upds);
        }
        upds.add(value);
    }
}

