/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.helpers;

import com.sonatype.insight.ide.eclipse.internal.ProjectConfigurationDTO;
import com.sonatype.insight.ide.eclipse.internal.helpers.ConfigHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.ui.statushandlers.StatusManager;

public class ClasspathHelper {
    public static IStatus visitWorkspaceClasspath(IProject[] scope, IClasspathEntryVisitor visitor, IProgressMonitor monitor) {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)scope.length);
        try {
            IProject[] iProjectArray = scope;
            int n = scope.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                ClasspathHelper.visitClasspath(project, visitor, (IProgressMonitor)mon.newChild(1));
                ++n2;
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            mon.done();
        }
    }

    public static IStatus visitClasspath(IProject project, IClasspathEntryVisitor visitor, IProgressMonitor monitor) {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            if (project.isOpen() && project.hasNature("org.eclipse.jdt.core.javanature")) {
                ProjectConfigurationDTO projectConfiguration = ConfigHelper.getProjectConfiguration(project);
                if (projectConfiguration.applicationId != null) {
                    IJavaProject javaProject = JavaCore.create((IProject)project);
                    IClasspathEntry[] rawEntries = javaProject.getRawClasspath();
                    SubMonitor monLoop = mon.newChild(99).setWorkRemaining(rawEntries.length);
                    IClasspathEntry[] iClasspathEntryArray = rawEntries;
                    int n = rawEntries.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IClasspathEntry entry = iClasspathEntryArray[n2];
                        SubMonitor monEntry = monLoop.newChild(1);
                        if (entry.getEntryKind() == 5) {
                            IClasspathContainer container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)javaProject);
                            if (container != null && container.getKind() < 2) {
                                IClasspathEntry[] containerEntries = container.getClasspathEntries();
                                monEntry.setWorkRemaining(containerEntries.length);
                                IClasspathEntry[] iClasspathEntryArray2 = containerEntries;
                                int n3 = containerEntries.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    IClasspathEntry dependency = iClasspathEntryArray2[n4];
                                    visitor.visit(dependency, project, container, projectConfiguration, (IProgressMonitor)monEntry.newChild(1));
                                    if (monitor.isCanceled()) {
                                        IStatus iStatus = Status.CANCEL_STATUS;
                                        return iStatus;
                                    }
                                    ++n4;
                                }
                            }
                        } else if (entry.getEntryKind() == 1) {
                            visitor.visit(entry, project, null, projectConfiguration, (IProgressMonitor)monEntry);
                        }
                        if (monitor.isCanceled()) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        ++n2;
                    }
                }
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (CoreException e) {
            StatusManager.getManager().handle(e, "com.sonatype.clm.ide.eclipse");
            Status status = new Status(4, "com.sonatype.clm.ide.eclipse", e.getMessage(), (Throwable)e);
            return status;
        }
        finally {
            mon.done();
        }
    }

    public static interface IClasspathEntryVisitor {
        public void visit(IClasspathEntry var1, IProject var2, IClasspathContainer var3, ProjectConfigurationDTO var4, IProgressMonitor var5);
    }
}

