/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.helpers;

import com.sonatype.insight.ide.eclipse.internal.AdditionalScope;
import com.sonatype.insight.ide.eclipse.internal.Messages;
import com.sonatype.insight.ide.eclipse.internal.ProjectConfigurationDTO;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.EnumSet;
import java.util.Properties;
import java.util.Set;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.statushandlers.StatusManager;

public class ConfigHelper {
    public static final String FILENAME = ".sonatype";
    private static final String KEY_APP_ID = "application.id";
    private static final String KEY_ADDITIONAL_SCOPES = "additionalScopes";

    private ConfigHelper() {
    }

    public static ProjectConfigurationDTO getProjectConfiguration(IProject project) {
        File file = ConfigHelper.getConfigFile(project);
        Properties props = ConfigHelper.load(file);
        ProjectConfigurationDTO configuration = new ProjectConfigurationDTO();
        configuration.applicationId = ConfigHelper.getApplicationId(props);
        configuration.additionalScopes = ConfigHelper.getAdditionalScopes(props, project);
        return configuration;
    }

    public static void setProjectConfiguration(IProject project, ProjectConfigurationDTO configuration) {
        File file = ConfigHelper.getConfigFile(project);
        Properties props = ConfigHelper.load(file);
        ConfigHelper.setApplicationId(props, configuration.applicationId);
        ConfigHelper.setAdditionalScopes(props, configuration.additionalScopes);
        ConfigHelper.save(file, props);
        ConfigHelper.refresh(project, file.getName());
    }

    private static String getApplicationId(Properties props) {
        return props.getProperty(KEY_APP_ID);
    }

    private static void setApplicationId(Properties props, String appId) {
        if (appId == null || appId.isEmpty()) {
            props.remove(KEY_APP_ID);
        } else {
            props.setProperty(KEY_APP_ID, appId);
        }
    }

    private static Set<AdditionalScope> getAdditionalScopes(Properties props, IProject project) {
        String scopesString = props.getProperty(KEY_ADDITIONAL_SCOPES);
        EnumSet<AdditionalScope> result = EnumSet.noneOf(AdditionalScope.class);
        if (!StringUtils.isBlank((String)scopesString)) {
            String[] scopes = scopesString.split(",");
            result = EnumSet.noneOf(AdditionalScope.class);
            String[] stringArray = scopes;
            int n = scopes.length;
            int n2 = 0;
            while (n2 < n) {
                String scope = stringArray[n2];
                try {
                    result.add(AdditionalScope.fromString(scope.trim()));
                }
                catch (Exception e) {
                    String errorMessage = NLS.bind((String)Messages.ProjectAssociationDialog_errorParsingAdditionalScopes, (Object[])new Object[]{scope, project.getName()});
                    StatusManager.getManager().handle((IStatus)new Status(4, "com.sonatype.clm.ide.eclipse", errorMessage, (Throwable)e));
                }
                ++n2;
            }
        }
        return result;
    }

    private static void setAdditionalScopes(Properties props, Set<AdditionalScope> scopes) {
        if (scopes == null || scopes.isEmpty()) {
            props.remove(KEY_ADDITIONAL_SCOPES);
        } else {
            StringBuilder scopesString = new StringBuilder();
            String delimiter = "";
            for (AdditionalScope scope : scopes) {
                scopesString.append(delimiter).append(scope.toString());
                delimiter = ",";
            }
            props.setProperty(KEY_ADDITIONAL_SCOPES, scopesString.toString());
        }
    }

    private static File getConfigFile(IProject project) {
        return new File(project.getLocation().toFile(), FILENAME);
    }

    private static Properties load(File file) {
        Properties props;
        block11: {
            props = new Properties();
            try {
                if (!file.exists()) break block11;
                Throwable throwable = null;
                Object var3_5 = null;
                try (FileInputStream fis = new FileInputStream(file);){
                    props.load(fis);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                Status status = new Status(4, "com.sonatype.clm.ide.eclipse", "Failed to load configuration from " + String.valueOf(file), (Throwable)e);
                StatusManager.getManager().handle((IStatus)status);
            }
        }
        return props;
    }

    private static void save(File file, Properties props) {
        block12: {
            try {
                if (props.isEmpty()) {
                    file.delete();
                    break block12;
                }
                Throwable throwable = null;
                Object var3_5 = null;
                try (FileOutputStream fos = new FileOutputStream(file);){
                    props.store(fos, "Sonatype CLM");
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                Status status = new Status(4, "com.sonatype.clm.ide.eclipse", "Failed to save configuration to " + String.valueOf(file), (Throwable)e);
                StatusManager.getManager().handle((IStatus)status);
            }
        }
    }

    private static void refresh(IProject project, String filename) {
        IFile file = project.getFile(filename);
        try {
            file.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            Status status = new Status(2, "com.sonatype.clm.ide.eclipse", "Failed to refresh file " + String.valueOf(file.getFullPath()), (Throwable)e);
            StatusManager.getManager().handle((IStatus)status);
        }
    }
}

