/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.helpers;

import com.sonatype.insight.ide.eclipse.internal.ArtifactKey;
import com.sonatype.insight.ide.eclipse.internal.Messages;
import com.sonatype.insight.ide.eclipse.internal.ui.elements.UIDependencyElement;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.ui.internal.actions.OpenPomAction;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class MavenHelper {
    private static final NullProgressMonitor MONITOR = new NullProgressMonitor();

    public static IMavenProjectFacade getFacade(MavenProject project) {
        return MavenPlugin.getMavenProjectRegistry().getMavenProject(project.getGroupId(), project.getArtifactId(), project.getVersion());
    }

    public static boolean isTransitive(UIDependencyElement element) {
        if (element.getMavenArtifactKey() == null) {
            return false;
        }
        for (IProject project : element.getProjects()) {
            if (MavenHelper.isTransitive(element, project)) continue;
            return false;
        }
        return true;
    }

    public static boolean isTransitive(UIDependencyElement element, IProject project) {
        MavenProject mavenProject;
        block7: {
            IMavenProjectFacade facade;
            block6: {
                block5: {
                    try {
                        facade = MavenPlugin.getMavenProjectRegistry().getProject(project);
                        if (facade != null) break block5;
                        return false;
                    }
                    catch (CoreException e) {
                        StatusManager.getManager().handle(e, "com.sonatype.clm.ide.eclipse");
                        return false;
                    }
                }
                if (!project.hasNature("org.eclipse.pde.PluginNature")) break block6;
                return false;
            }
            mavenProject = facade.getMavenProject((IProgressMonitor)MONITOR);
            if (mavenProject != null) break block7;
            return false;
        }
        return MavenHelper.isTransitive(element, mavenProject);
    }

    public static boolean isTransitive(UIDependencyElement element, MavenProject mavenProject) {
        ArtifactKey artifactKey = element.getDeclaredArtifactKey();
        if (artifactKey == null || mavenProject == null) {
            return false;
        }
        List dependencies = mavenProject.getDependencies();
        if (dependencies != null) {
            for (Dependency d : dependencies) {
                if (!MavenHelper.equals(artifactKey, d)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean equals(ArtifactKey mavenArtifactKey, Dependency d) {
        return MavenHelper.equals(mavenArtifactKey.getGroupId(), d.getGroupId()) && MavenHelper.equals(mavenArtifactKey.getArtifactId(), d.getArtifactId()) && MavenHelper.equals(mavenArtifactKey.getVersion(), d.getVersion());
    }

    private static boolean equals(String a, String b) {
        return a == null ? b == null : a.equals(b);
    }

    public static void openPOM(ArtifactKey key) {
        if (key != null) {
            MavenHelper.openPOM(key.getGroupId(), key.getArtifactId(), key.getVersion());
        }
    }

    public static void openPOM(final String groupId, final String artifactId, final String version) {
        new Job(NLS.bind((String)Messages.MavenHelper_openPomJobName, (Object)(groupId + ":" + artifactId + ":" + version))){

            protected IStatus run(IProgressMonitor monitor) {
                OpenPomAction.openEditor((String)groupId, (String)artifactId, (String)version, (IProgressMonitor)monitor);
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public static Set<File> getOptionalDependencies(IProject project, IProgressMonitor monitor) {
        Set<File> optionals = Collections.emptySet();
        MavenProject mvnProject = MavenHelper.getMavenProject(project, monitor);
        if (mvnProject != null) {
            optionals = new HashSet<File>();
            for (Artifact artifact : mvnProject.getArtifacts()) {
                if (!artifact.isOptional()) continue;
                optionals.add(artifact.getFile());
            }
        }
        return optionals;
    }

    private static MavenProject getMavenProject(IProject project, IProgressMonitor monitor) {
        try {
            IMavenProjectFacade facade = MavenPlugin.getMavenProjectRegistry().getProject(project);
            if (facade != null) {
                return facade.getMavenProject(monitor);
            }
        }
        catch (CoreException e) {
            StatusManager.getManager().handle(e, "com.sonatype.clm.ide.eclipse");
        }
        return null;
    }
}

