/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.rest;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.HttpEntityWrapper;
import org.apache.http.message.BasicHeader;

class GzippedEntity
extends HttpEntityWrapper {
    private Header contentEncoding = new BasicHeader("Content-Encoding", "gzip");

    public GzippedEntity(HttpEntity entity) {
        super(entity);
    }

    public Header getContentEncoding() {
        return this.contentEncoding;
    }

    public long getContentLength() {
        return -1L;
    }

    public void writeTo(OutputStream outstream) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (GZIPOutputStream gos = new GZIPOutputStream(outstream);){
            super.writeTo((OutputStream)gos);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

