/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.rest;

import com.sonatype.clm.dto.model.component.ComponentIdentifier;
import com.sonatype.clm.dto.model.component.NamedComponentDetails;
import com.sonatype.clm.dto.model.ide.ComponentVersionInfo;
import com.sonatype.insight.ide.eclipse.internal.helpers.UserAgent;
import com.sonatype.insight.ide.eclipse.internal.rest.GzippedEntity;
import com.sonatype.insight.ide.eclipse.internal.rest.InsightClientManager;
import com.sonatype.insight.ide.eclipse.internal.rest.JsonUtils;
import com.sonatype.insight.ide.eclipse.internal.rest.RestClient;
import com.sonatype.insight.ide.eclipse.internal.rest.UrlBuilder;
import com.sonatype.insight.ide.eclipse.internal.rest.UserInteraction;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsightClient
implements Closeable,
RestClient {
    private static final Logger LOG = LoggerFactory.getLogger(InsightClient.class);
    private static final String MINIMAL_IQ_VERSION_FOR_TELEMETRY_V2 = "1.145";
    private static final String MINIMAL_IQ_VERSION_FOR_UI_TELEMETRY = "1.178";
    private CloseableHttpClient httpClient;
    private String userAgent;
    private Set<Header> defaultHeaders = new HashSet<Header>();
    private Credentials serverAuth;
    private HttpHost proxyHost;
    private Credentials proxyAuth;
    private int connectTimeout = 20000;
    private int requestTimeout = 60000;
    private boolean gzip;
    private boolean reset = true;
    private String csrfToken = "CSRF-ECLIPSE";
    private String iqVersion = "";
    private static final String COMPONENT_DETAILS_PATH = "rest/ide/componentDetails/application/";

    public synchronized InsightClient setCredentials(String username, String password) {
        this.serverAuth = username != null && username.trim().length() > 0 ? new UsernamePasswordCredentials(username, password) : null;
        this.reset = true;
        return this;
    }

    public synchronized InsightClient setProxy(String host, int port, String username, String password) {
        this.proxyHost = host != null && host.trim().length() > 0 && port > 0 ? new HttpHost(host, port) : null;
        this.proxyAuth = this.proxyHost != null && username != null && username.trim().length() > 0 ? new UsernamePasswordCredentials(username, password) : null;
        this.reset = true;
        return this;
    }

    public InsightClient setUserAgent(String tool, String version) {
        return this.setUserAgent(new UserAgent(tool, version).toString());
    }

    public synchronized InsightClient setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        this.defaultHeaders.add((Header)new BasicHeader("X-CLM-Client-User-Agent", userAgent));
        this.reset = true;
        return this;
    }

    public synchronized InsightClient setInstanceId(String instanceId) {
        this.defaultHeaders.add((Header)new BasicHeader("X-CLM-Client-Instance-Id", instanceId));
        return this;
    }

    public synchronized InsightClient setTimeouts(int connectTimeout, int requestTimeout) {
        this.connectTimeout = connectTimeout;
        this.requestTimeout = requestTimeout;
        this.reset = true;
        return this;
    }

    public synchronized InsightClient setGzip(boolean enabled) {
        this.gzip = enabled;
        return this;
    }

    private synchronized HttpClient getHttpClient() {
        if (this.reset) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            List<String> authSchemes = Arrays.asList("basic", "digest", "ntlm");
            RequestConfig.Builder requestConfigBuilder = RequestConfig.custom().setConnectTimeout(this.connectTimeout).setSocketTimeout(this.requestTimeout).setTargetPreferredAuthSchemes(authSchemes).setProxyPreferredAuthSchemes(authSchemes);
            if (this.proxyHost != null) {
                requestConfigBuilder.setProxy(this.proxyHost);
                InsightClient.setAuthentication((CredentialsProvider)credentialsProvider, this.proxyHost, this.proxyAuth);
            }
            HttpClientBuilder clientBuilder = HttpClientBuilder.create();
            clientBuilder.setUserAgent(this.userAgent).setDefaultRequestConfig(requestConfigBuilder.build()).setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).setDefaultHeaders(this.defaultHeaders).useSystemProperties();
            InsightClient.setAuthentication((CredentialsProvider)credentialsProvider, null, this.serverAuth);
            this.httpClient = clientBuilder.build();
            this.reset = false;
        } else if (this.httpClient == null) {
            throw new IllegalStateException("client has been closed");
        }
        return this.httpClient;
    }

    private static void setAuthentication(CredentialsProvider credsProvider, HttpHost host, Credentials auth) {
        String domain;
        if (auth == null) {
            return;
        }
        String username = auth.getUserPrincipal().getName();
        if (username == null || username.length() <= 0) {
            username = System.getProperty("user.name");
        }
        AuthScope authScope = new AuthScope(host != null ? host.getHostName() : AuthScope.ANY_HOST, host != null ? host.getPort() : -1);
        UsernamePasswordCredentials basicCredentials = new UsernamePasswordCredentials(username, auth.getPassword());
        credsProvider.setCredentials(authScope, (Credentials)basicCredentials);
        int backslash = username.indexOf(92);
        if (backslash < 0) {
            domain = InsightClient.guessNtmlDomain();
        } else {
            domain = username.substring(0, backslash);
            username = username.substring(backslash + 1);
        }
        String workstation = InsightClient.guessNtlmWorkstation();
        authScope = new AuthScope(host != null ? host.getHostName() : AuthScope.ANY_HOST, host != null ? host.getPort() : -1, AuthScope.ANY_REALM, "ntlm");
        NTCredentials ntlmCredentials = new NTCredentials(username, auth.getPassword(), workstation, domain);
        credsProvider.setCredentials(authScope, (Credentials)ntlmCredentials);
    }

    private static String guessNtmlDomain() {
        return InsightClient.safeNtlmString(System.getProperty("http.auth.ntlm.domain"), System.getenv("USERDOMAIN"));
    }

    private static String guessNtlmWorkstation() {
        String localHost = null;
        try {
            localHost = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {}
        return InsightClient.safeNtlmString(System.getProperty("http.auth.ntlm.host"), System.getenv("COMPUTERNAME"), localHost);
    }

    private static String safeNtlmString(String ... strings) {
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (string != null) {
                return string;
            }
            ++n2;
        }
        return "";
    }

    @Override
    public synchronized void close() {
        if (this.httpClient != null) {
            try {
                try {
                    this.httpClient.close();
                }
                catch (IOException e) {
                    LOG.error("Ignoring exception while closing client.", (Throwable)e);
                    this.httpClient = null;
                }
            }
            finally {
                this.httpClient = null;
            }
        }
    }

    @Override
    public <T> T get(String url, Class<T> responseType) throws IOException, URISyntaxException {
        HttpGet method = new HttpGet(this.toUri(url));
        return this.execute((HttpUriRequest)method, responseType);
    }

    @Override
    public <T> T getPki(String url, Class<T> responseType) throws IOException, URISyntaxException {
        HttpGet method = new HttpGet(this.toUri(url));
        return this.execute((HttpUriRequest)method, this.newHttpContext((HttpUriRequest)method, null), responseType);
    }

    @Override
    public <T> T get(String url, String username, String password, Class<T> responseType) throws IOException, URISyntaxException {
        HttpGet method = new HttpGet(this.toUri(url));
        return this.execute((HttpUriRequest)method, this.newHttpContext((HttpUriRequest)method, (Credentials)new UsernamePasswordCredentials(username, password)), responseType);
    }

    @Override
    public <T> T post(String url, Object entity, Class<T> responseType) throws IOException, URISyntaxException {
        HttpPost method = new HttpPost(this.toUri(url));
        method.setEntity((HttpEntity)new StringEntity(JsonUtils.toJson(entity), ContentType.APPLICATION_JSON));
        return this.execute((HttpUriRequest)method, responseType);
    }

    @Override
    public void post(String url, Object entity) throws IOException {
        HttpPost post = new HttpPost(url);
        post.setEntity((HttpEntity)new StringEntity(JsonUtils.toJson(entity), ContentType.APPLICATION_JSON));
        this.execute((HttpUriRequest)post, this.newHttpContext((HttpUriRequest)post, this.serverAuth));
    }

    @Override
    public NamedComponentDetails getComponentDetails(String applicationPublicId, ComponentIdentifier componentIdentifier, String matchState, String hash, boolean proprietary) throws IOException, URISyntaxException {
        UrlBuilder urlBuilder = new UrlBuilder(InsightClientManager.getInstance().getServerUrl());
        urlBuilder.appendPath(COMPONENT_DETAILS_PATH).appendSegment(applicationPublicId).appendQueryParam("componentIdentifier", JsonUtils.toJson(componentIdentifier));
        if (StringUtils.isNotBlank((String)matchState)) {
            urlBuilder.appendQueryParam("matchState", matchState);
        }
        if (StringUtils.isNotBlank((String)hash)) {
            urlBuilder.appendQueryParam("hash", hash);
        }
        if (proprietary) {
            urlBuilder.appendQueryParam("proprietary", "true");
        }
        String url = urlBuilder.build();
        return this.get(url, NamedComponentDetails.class);
    }

    @Override
    public ComponentVersionInfo getComponentVersionInfo(String applicationPublicId, ComponentIdentifier componentIdentifier) throws IOException, URISyntaxException {
        UrlBuilder urlBuilder = new UrlBuilder(InsightClientManager.getInstance().getServerUrl());
        String url = urlBuilder.appendPath(COMPONENT_DETAILS_PATH).appendSegment(applicationPublicId).appendSegment("allVersions").appendQueryParam("componentIdentifier", JsonUtils.toJson(componentIdentifier)).build();
        return this.get(url, ComponentVersionInfo.class);
    }

    @Override
    public void sendTelemetry(Map<String, Integer> componentCounts, String applicationId, boolean isDarkThemeInUse) {
        try {
            if (this.isIqVersionOnOrAfter(MINIMAL_IQ_VERSION_FOR_TELEMETRY_V2)) {
                this.sendTelemetryV2(componentCounts, applicationId, isDarkThemeInUse);
            } else {
                this.sendTelemetryV1(componentCounts, applicationId);
            }
        }
        catch (Exception e) {
            LOG.warn("Cannot send telemetry to IQ Server: {}", (Object)e.getMessage());
        }
    }

    private void sendTelemetryV2(Map<String, Integer> componentCounts, String applicationId, boolean isDarkThemeInUse) throws IOException {
        UrlBuilder uriBuilder = new UrlBuilder(InsightClientManager.getInstance().getServerUrl());
        uriBuilder.appendPath("rest/ide/v2/telemetry/");
        uriBuilder.appendSegment(applicationId);
        String uri = uriBuilder.build();
        String ideTheme = isDarkThemeInUse ? "dark" : "light";
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("component_counts", componentCounts);
        request.put("ide_theme", ideTheme);
        this.post(uri, request);
        LOG.debug("Sent telemetry analysis counts: {}, IDE theme is: {}", componentCounts, (Object)ideTheme);
    }

    private void sendTelemetryV1(Map<String, Integer> componentCounts, String applicationId) throws IOException {
        UrlBuilder uriBuilder = new UrlBuilder(InsightClientManager.getInstance().getServerUrl());
        uriBuilder.appendPath("rest/ide/telemetry/");
        uriBuilder.appendSegment(applicationId);
        String uri = uriBuilder.build();
        this.post(uri, componentCounts);
        LOG.debug("Sent telemetry analysis counts: {}", componentCounts);
    }

    @Override
    public void sendUserInteractionTelemetry(Map<UserInteraction, AtomicInteger> userInteractionMap) {
        if (this.isIqVersionOnOrAfter(MINIMAL_IQ_VERSION_FOR_UI_TELEMETRY)) {
            HashMap<String, Object> attributesMap = new HashMap<String, Object>();
            attributesMap.put("telemetry_purpose", "IDE_USER_INTERACTION_METRICS");
            UserInteraction[] userInteractionArray = UserInteraction.values();
            int n = userInteractionArray.length;
            int n2 = 0;
            while (n2 < n) {
                UserInteraction value = userInteractionArray[n2];
                attributesMap.put(value.getName(), userInteractionMap.get((Object)value).intValue());
                ++n2;
            }
            try {
                UrlBuilder uriBuilder = new UrlBuilder(InsightClientManager.getInstance().getServerUrl());
                uriBuilder.appendPath("api/v2/telemetry");
                String uri = uriBuilder.build();
                this.post(uri, attributesMap);
                LOG.debug("Sent user interaction telemetry: {}", attributesMap);
            }
            catch (Exception e) {
                LOG.warn("Cannot send user interaction telemetry to IQ Server: {}", (Object)e.getMessage());
            }
        }
    }

    private boolean isIqVersionOnOrAfter(String version) {
        return version.compareTo(this.getIQServerVersion()) <= 0;
    }

    @Override
    public String getIQServerVersion() {
        if (StringUtils.isEmpty((String)this.iqVersion)) {
            try {
                UrlBuilder uriBuilder = new UrlBuilder(InsightClientManager.getInstance().getServerUrl());
                uriBuilder.appendPath("rest/product/version/");
                this.iqVersion = this.get(uriBuilder.build(), Map.class).get("version").toString();
            }
            catch (Exception e) {
                LOG.warn("Cannot get IQ Server Version: {}", (Object)e.getMessage());
            }
        }
        return this.iqVersion;
    }

    private URI toUri(String url) throws URISyntaxException {
        URI uri = new URI(url).parseServerAuthority();
        if (!uri.isAbsolute()) {
            throw new URISyntaxException(url, "URL must be absolute");
        }
        if (uri.getHost() == null) {
            throw new URISyntaxException(url, "URL lacks host address");
        }
        return uri;
    }

    private <T> T execute(HttpUriRequest request, Class<T> responseType) throws IOException {
        return this.execute(request, this.newHttpContext(request, this.serverAuth), responseType);
    }

    private void setCsrfToken(HttpUriRequest request) throws IOException {
        HttpEntityEnclosingRequest req;
        HttpEntity entity;
        request.setHeader("X-CSRF-TOKEN", this.csrfToken);
        if (this.gzip && request instanceof HttpEntityEnclosingRequest && (entity = (req = (HttpEntityEnclosingRequest)request).getEntity()) != null) {
            req.setEntity((HttpEntity)new GzippedEntity(entity));
        }
    }

    private <T> T execute(HttpUriRequest request, HttpContext context, Class<T> responseType) throws IOException {
        HttpClient client = this.getHttpClient();
        this.setCsrfToken(request);
        return this.handleResponse(client.execute(request, context), responseType);
    }

    private void execute(HttpUriRequest request, HttpContext context) throws IOException {
        HttpClient client = this.getHttpClient();
        this.setCsrfToken(request);
        client.execute(request, context);
    }

    private void addCsrfTokenCookie(HttpClientContext ctx, String domain) {
        Date date = new Date(System.currentTimeMillis() + 604800000L);
        BasicClientCookie cookie = new BasicClientCookie("CLM-CSRF-TOKEN", this.csrfToken);
        cookie.setExpiryDate(date);
        cookie.setPath("/");
        cookie.setDomain(domain);
        ctx.getCookieStore().addCookie((Cookie)cookie);
    }

    private HttpContext newHttpContext(HttpUriRequest request, Credentials creds) {
        HttpClientContext clientContext = HttpClientContext.create();
        HttpHost host = URIUtils.extractHost((URI)request.getURI());
        if (host == null) {
            return clientContext;
        }
        BasicAuthCache authCache = new BasicAuthCache();
        authCache.put(host, (AuthScheme)new BasicScheme());
        clientContext.setAuthCache((AuthCache)authCache);
        if (creds == null) {
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            clientContext.setCredentialsProvider((CredentialsProvider)credsProvider);
        } else {
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            InsightClient.setAuthentication((CredentialsProvider)credsProvider, null, creds);
            if (this.proxyHost != null) {
                InsightClient.setAuthentication((CredentialsProvider)credsProvider, this.proxyHost, this.proxyAuth);
            }
            clientContext.setCredentialsProvider((CredentialsProvider)credsProvider);
        }
        clientContext.setCookieStore((CookieStore)new BasicCookieStore());
        this.addCsrfTokenCookie(clientContext, request.getURI().getHost());
        return clientContext;
    }

    private <T> T handleResponse(HttpResponse response, Class<T> responseType) throws IOException {
        int status = response.getStatusLine().getStatusCode();
        String reason = response.getStatusLine().getReasonPhrase();
        String body = this.getBody(response);
        if (status >= 300) {
            String msg = this.getErrorMessage(reason, body);
            throw new HttpResponseException(status, msg);
        }
        if (body == null || body.length() <= 0 || responseType == null) {
            return null;
        }
        if (String.class.equals(responseType)) {
            return responseType.cast(body);
        }
        return JsonUtils.fromJson(body, responseType);
    }

    private String getBody(HttpResponse response) throws IOException {
        HttpEntity entity = response.getEntity();
        try {
            String string = entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
            return string;
        }
        finally {
            EntityUtils.consume((HttpEntity)entity);
        }
    }

    private String getErrorMessage(String reason, String body) {
        if (body != null && body.length() > 0 && !body.contains("<html")) {
            return body;
        }
        return reason;
    }

    public Map<String, String> getDefaultHeaderMap() {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Header header : this.defaultHeaders) {
            headers.put(header.getName(), header.getValue());
        }
        return headers;
    }
}

