/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.rest;

import com.sonatype.insight.ide.eclipse.Activator;
import com.sonatype.insight.ide.eclipse.IDependencyConstants;
import com.sonatype.insight.ide.eclipse.internal.rest.InsightClient;
import com.sonatype.insight.ide.eclipse.internal.rest.RestClient;
import com.sonatype.insight.ide.eclipse.internal.rest.UserInteraction;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.prefs.Preferences;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.util.EncodingUtils;
import org.eclipse.core.net.proxy.IProxyChangeEvent;
import org.eclipse.core.net.proxy.IProxyChangeListener;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.ui.statushandlers.StatusManager;
import org.slf4j.LoggerFactory;

public class InsightClientManager {
    private static final String PREF_SERVER_URL = "SERVER_URL";
    private static final String PREF_SERVER_PERSIST_CREDENTIALS = "server.persistCredentials";
    private static final String PREF_PKI_AUTHENTICATION = "server.pkiAuthentication";
    private static final String SERVER_AUTH_PREF_PATH = "com.sonatype.clm.server.auth";
    private static final String PREF_SERVER_GZIP = "server.gzip";
    private static final String KEY_USERNAME = "username";
    private static final String KEY_PASSWORD = "password";
    private static final String PREF_NODE = "/com/sonatype/integrations";
    private static final String PREF_KEY = "Client-Instance-Id";
    private static InsightClientManager instance;
    private final String instanceId;
    private InsightClient insightClient;
    private IProxyChangeListener proxyListener;
    private String username = "";
    private String password = "";
    private final Map<UserInteraction, AtomicInteger> userInteractionCountMap = new HashMap<UserInteraction, AtomicInteger>();

    private InsightClientManager() {
        String instanceId;
        try {
            Preferences prefs = Preferences.userRoot().node(PREF_NODE);
            instanceId = prefs.get(PREF_KEY, null);
            if (instanceId == null) {
                instanceId = UUID.randomUUID().toString().replace("-", "");
                prefs.put(PREF_KEY, instanceId);
            }
        }
        catch (Exception e) {
            instanceId = "error";
            StatusManager.getManager().handle((IStatus)new Status(2, "com.sonatype.clm.ide.eclipse", "Could not read instance ID", (Throwable)e));
        }
        this.instanceId = instanceId;
        if (this.isPersistCredentials()) {
            try {
                this.loadSecurePreferences();
            }
            catch (StorageException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "com.sonatype.clm.ide.eclipse", "Could not read credentials for Nexus IQ Server", (Throwable)e));
            }
        }
        this.resetUserInteractionCounts();
    }

    public static synchronized InsightClientManager getInstance() {
        if (instance == null) {
            instance = new InsightClientManager();
        }
        return instance;
    }

    public static synchronized void setInstance(InsightClientManager instance) {
        InsightClientManager.instance = instance;
    }

    public Map<UserInteraction, AtomicInteger> getUserInteractionCountMap() {
        return this.userInteractionCountMap;
    }

    public synchronized void closeClient() {
        if (this.proxyListener != null) {
            Activator.getProxyService().removeProxyChangeListener(this.proxyListener);
            this.proxyListener = null;
        }
        if (this.insightClient != null) {
            this.insightClient.close();
            this.insightClient = null;
        }
    }

    public synchronized RestClient getClient() {
        if (this.insightClient == null) {
            this.insightClient = new InsightClient();
            this.insightClient.setUserAgent(IDependencyConstants.USER_AGENT).setInstanceId(this.instanceId).setGzip(this.isGzipEnabled()).setCredentials(this.getUsername(), this.getPassword());
            this.setProxy();
            IProxyService proxyService = Activator.getProxyService();
            if (proxyService != null) {
                this.proxyListener = new IProxyChangeListener(){

                    public void proxyInfoChanged(IProxyChangeEvent event) {
                        InsightClientManager.this.setProxy();
                    }
                };
                proxyService.addProxyChangeListener(this.proxyListener);
            } else {
                LoggerFactory.getLogger(InsightClientManager.class).warn("Proxy Service not available, network connections cannot be proxied!");
            }
        }
        return this.insightClient;
    }

    public Map<String, String> getHeaders() {
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        headers.put("User-Agent", IDependencyConstants.USER_AGENT);
        headers.put("X-CLM-Client-User-Agent", IDependencyConstants.USER_AGENT);
        if (!this.isPkiAuthentication()) {
            Object credentials = this.getUsername() + ":" + this.getPassword();
            credentials = Base64.encodeBase64String((byte[])EncodingUtils.getBytes((String)credentials, (String)"UTF-8"));
            headers.put("Authorization", "Basic " + (String)credentials);
        }
        return headers;
    }

    private void setProxy() {
        if (this.insightClient == null) {
            return;
        }
        try {
            IProxyData proxy = InsightClientManager.getProxy(new URI(this.getServerUrl()));
            if (proxy != null) {
                this.insightClient.setProxy(proxy.getHost(), proxy.getPort(), proxy.getUserId(), proxy.getPassword());
            } else {
                this.insightClient.setProxy(null, 0, null, null);
            }
        }
        catch (URISyntaxException e) {
            this.insightClient.setProxy(null, 0, null, null);
            StatusManager.getManager().handle((IStatus)new Status(2, "com.sonatype.clm.ide.eclipse", "Could not select proxy for Sonatype Nexus IQ Server", (Throwable)e));
        }
    }

    private static IProxyData getProxy(URI uri) {
        IProxyData[] proxies;
        IProxyService proxyService = Activator.getProxyService();
        if (proxyService != null && proxyService.isProxiesEnabled() && (proxies = proxyService.select(uri)).length > 0) {
            if (proxies.length == 1) {
                return proxies[0];
            }
            String protocol = uri.getScheme();
            IProxyData[] iProxyDataArray = proxies;
            int n = proxies.length;
            int n2 = 0;
            while (n2 < n) {
                IProxyData proxy = iProxyDataArray[n2];
                if (protocol.equalsIgnoreCase(proxy.getType())) {
                    return proxy;
                }
                ++n2;
            }
            return proxies[0];
        }
        return null;
    }

    public boolean setServerWithBasicAuthentication(String url, String username, String password, boolean persistCredentials) {
        boolean changed = false;
        changed |= this.setServerUrl(url);
        changed |= this.setPkiAuthentication(false);
        Activator.setBooleanPreference(PREF_SERVER_PERSIST_CREDENTIALS, persistCredentials);
        if (changed |= this.setCredentials(username, password, persistCredentials)) {
            this.closeClient();
        }
        return changed;
    }

    public boolean setServerWithPkiAuthentication(String url) {
        boolean changed = this.setServerUrl(url);
        changed |= this.setPkiAuthentication(true);
        this.username = "";
        this.password = "";
        Activator.setBooleanPreference(PREF_SERVER_PERSIST_CREDENTIALS, false);
        this.setCredentials(this.username, this.password, false);
        if (changed) {
            this.closeClient();
        }
        return changed;
    }

    private boolean setServerUrl(String url) {
        if (!this.getServerUrl().equals(url)) {
            Activator.setStringPreference(PREF_SERVER_URL, url);
            this.setProxy();
            return true;
        }
        return false;
    }

    private boolean setPkiAuthentication(boolean pkiAuthentication) {
        if (this.isPkiAuthentication() != pkiAuthentication) {
            Activator.setBooleanPreference(PREF_PKI_AUTHENTICATION, pkiAuthentication);
            return true;
        }
        return false;
    }

    private boolean setCredentials(String username, String password, boolean persist) {
        boolean changed = false;
        if (username == null) {
            username = "";
        }
        if (!this.getUsername().equals(username)) {
            this.username = username;
            changed = true;
        }
        if (password == null) {
            password = "";
        }
        if (!this.getPassword().equals(password)) {
            this.password = password;
            changed = true;
        }
        if (!persist) {
            this.removeSecurePreferences();
        } else {
            this.setSecurePreferences(username, password);
        }
        return changed;
    }

    private ISecurePreferences getSecurePreferences(boolean createIfMissing) {
        ISecurePreferences rootNode = SecurePreferencesFactory.getDefault();
        if (createIfMissing || rootNode.nodeExists(SERVER_AUTH_PREF_PATH)) {
            return rootNode.node(SERVER_AUTH_PREF_PATH);
        }
        return null;
    }

    private void setSecurePreferences(String username, String password) {
        try {
            ISecurePreferences authNode = this.getSecurePreferences(true);
            authNode.put(KEY_USERNAME, username, true);
            authNode.put(KEY_PASSWORD, password, true);
            authNode.flush();
        }
        catch (StorageException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void loadSecurePreferences() throws StorageException {
        ISecurePreferences authNode = this.getSecurePreferences(false);
        if (authNode != null) {
            this.username = authNode.get(KEY_USERNAME, "");
            this.password = authNode.get(KEY_PASSWORD, "");
        }
    }

    private void removeSecurePreferences() {
        ISecurePreferences authNode = this.getSecurePreferences(false);
        if (authNode != null) {
            authNode.removeNode();
            try {
                authNode.flush();
            }
            catch (IOException e) {
                StatusManager.getManager().handle((IStatus)new Status(2, "com.sonatype.clm.ide.eclipse", "Could not flush removal of credentials to persistent storage", (Throwable)e));
            }
        }
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getServerUrl() {
        Object toRet = Activator.getStringPreference(PREF_SERVER_URL, "");
        if (!((String)toRet).isEmpty() && !((String)toRet).endsWith("/")) {
            toRet = (String)toRet + "/";
        }
        return toRet;
    }

    public boolean isPersistCredentials() {
        return Activator.getBooleanPreference(PREF_SERVER_PERSIST_CREDENTIALS, true);
    }

    public boolean isPkiAuthentication() {
        return Activator.getBooleanPreference(PREF_PKI_AUTHENTICATION, false);
    }

    private boolean isGzipEnabled() {
        return Activator.getBooleanPreference(PREF_SERVER_GZIP, true);
    }

    public String getID() {
        return this.instanceId;
    }

    public void sendUserInteractionTelemetry() {
        if (this.shouldSendUiTelemetry()) {
            this.getClient().sendUserInteractionTelemetry(this.userInteractionCountMap);
            this.resetUserInteractionCounts();
        }
    }

    private boolean shouldSendUiTelemetry() {
        UserInteraction[] userInteractionArray = UserInteraction.values();
        int n = userInteractionArray.length;
        int n2 = 0;
        while (n2 < n) {
            UserInteraction value = userInteractionArray[n2];
            if (this.userInteractionCountMap.get((Object)value).intValue() > 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void resetUserInteractionCounts() {
        UserInteraction[] userInteractionArray = UserInteraction.values();
        int n = userInteractionArray.length;
        int n2 = 0;
        while (n2 < n) {
            UserInteraction value = userInteractionArray[n2];
            this.userInteractionCountMap.put(value, new AtomicInteger(0));
            ++n2;
        }
    }
}

