/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.rest;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class UrlBuilder {
    private final StringBuilder url = new StringBuilder(256);
    private boolean query;

    public UrlBuilder(String baseUrl) {
        this.url.append(baseUrl);
    }

    public String build() {
        return this.url.toString();
    }

    public UrlBuilder appendPath(String path) {
        if (this.query) {
            throw new IllegalStateException("Cannot append path after query parameters");
        }
        if (this.url.length() > 0 && this.url.charAt(this.url.length() - 1) != '/') {
            this.url.append('/');
        }
        if (this.url.length() > 0 && path.startsWith("/")) {
            this.url.append(path.substring(1));
        } else {
            this.url.append(path);
        }
        return this;
    }

    public UrlBuilder appendSegment(String segment) {
        return this.appendPath(UrlBuilder.encodeUrlComponent(segment));
    }

    public UrlBuilder appendQueryParam(String name, String value) {
        if (value != null && value.length() > 0) {
            this.url.append(this.query ? (char)'&' : '?');
            this.url.append(name).append('=').append(UrlBuilder.encodeUrlComponent(value));
            this.query = true;
        }
        return this;
    }

    static String encodeUrlComponent(String token) {
        try {
            return URLEncoder.encode(token, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toString() {
        return this.url.toString();
    }
}

