/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.scan;

import com.sonatype.clm.dto.model.ide.ScannedComponent;
import com.sonatype.insight.ide.eclipse.Activator;
import com.sonatype.insight.ide.eclipse.internal.scan.EntryHashCache;
import com.sonatype.insight.ide.eclipse.internal.scan.OuterHashCache;
import com.sonatype.insight.ide.eclipse.internal.scan.PackageIndexCache;
import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.statushandlers.StatusManager;

public class CacheManager {
    private static CacheManager instance;
    private final File directory = new File(Activator.getDefault().getStateLocation().toFile(), "hashes");
    private final File file = new File(this.directory, "outer-hashes.ser");
    private final OuterHashCache outerHashCache = new OuterHashCache();
    private final EntryHashCache entryHashCache;
    private final PackageIndexCache packageIndexCache;
    private final Job saveJob;

    private CacheManager() {
        try {
            if (this.file.exists()) {
                this.outerHashCache.load(this.file);
            }
        }
        catch (Exception e) {
            StatusManager.getManager().handle(CacheManager.warning("Could not load component hash cache from " + String.valueOf(this.file), e));
        }
        this.entryHashCache = new EntryHashCache(this.directory);
        this.packageIndexCache = new PackageIndexCache(this.directory);
        this.saveJob = new Job("Saving component hash cache"){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("", 100);
                try {
                    try {
                        if (CacheManager.this.outerHashCache.isDirty()) {
                            CacheManager.this.outerHashCache.save(CacheManager.this.file);
                        }
                    }
                    catch (Exception e) {
                        CacheManager.this.file.delete();
                        IStatus iStatus = CacheManager.warning("Could not save component hash cache to " + String.valueOf(CacheManager.this.file), e);
                        monitor.done();
                        return iStatus;
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        this.saveJob.setSystem(true);
        Job purgeJob = new Job("Purging component hash caches"){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("", 100);
                try {
                    CacheManager.this.outerHashCache.purgeStaleEntries();
                    if (CacheManager.this.outerHashCache.isDirty()) {
                        CacheManager.this.saveCache();
                    }
                    CacheManager.this.entryHashCache.purgeStaleEntries();
                    CacheManager.this.packageIndexCache.purgeStaleEntries();
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        purgeJob.setSystem(true);
        purgeJob.schedule(60000L);
    }

    private static IStatus warning(String message, Throwable cause) {
        return new Status(2, "com.sonatype.clm.ide.eclipse", message, cause);
    }

    public static synchronized CacheManager getInstance() {
        if (instance == null) {
            instance = new CacheManager();
        }
        return instance;
    }

    public String get(File file) {
        return this.outerHashCache.get(file);
    }

    public void put(File file, String hash) {
        this.outerHashCache.put(file, hash);
        this.saveCache();
    }

    private void saveCache() {
        this.saveJob.schedule(30000L);
    }

    public ScannedComponent get(String hash) {
        try {
            return (ScannedComponent)this.entryHashCache.get(hash);
        }
        catch (Exception e) {
            StatusManager.getManager().handle(CacheManager.warning("Could not load component entry hash cache for " + hash, e));
            return null;
        }
    }

    public void put(String hash, ScannedComponent scan) {
        try {
            this.entryHashCache.put(hash, scan);
        }
        catch (Exception e) {
            StatusManager.getManager().handle(CacheManager.warning("Could not save component entry hash cache for " + hash, e));
        }
    }

    public String[] getPackages(String hash) {
        try {
            return (String[])this.packageIndexCache.get(hash);
        }
        catch (Exception e) {
            StatusManager.getManager().handle(CacheManager.warning("Could not load component package index cache for " + hash, e));
            return null;
        }
    }

    public void put(String hash, String[] packages) {
        try {
            this.packageIndexCache.put(hash, packages);
        }
        catch (Exception e) {
            StatusManager.getManager().handle(CacheManager.warning("Could not save component package index cache for " + hash, e));
        }
    }
}

