/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.scan;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

abstract class DiskBasedCache<V> {
    private final File directory;
    private final String extension;

    protected DiskBasedCache(File directory, String extension) {
        if (directory == null) {
            throw new IllegalArgumentException("cache directory missing");
        }
        if (extension == null || extension.isEmpty()) {
            throw new IllegalArgumentException("cache file extensions missing");
        }
        this.directory = directory;
        this.extension = extension;
    }

    private File getEntry(String hash) {
        return new File(this.directory, hash + "." + this.extension);
    }

    public V get(String hash) throws IOException {
        File entry = this.getEntry(hash);
        if (entry.exists()) {
            entry.setLastModified(System.currentTimeMillis());
            try {
                Throwable throwable = null;
                Object var4_7 = null;
                try (ObjectInputStream ois = new ObjectInputStream(new GZIPInputStream(new FileInputStream(entry)));){
                    return (V)ois.readObject();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (ClassCastException e) {
                throw new IOException(e);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
        }
        return null;
    }

    public void put(String hash, V data) throws IOException {
        File entry = this.getEntry(hash);
        entry.getParentFile().mkdirs();
        Throwable throwable = null;
        Object var5_6 = null;
        try (ObjectOutputStream oos = new ObjectOutputStream(new GZIPOutputStream(new FileOutputStream(entry)));){
            oos.writeObject(data);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void purgeStaleEntries() {
        final Pattern pattern = Pattern.compile("[0-9a-fA-F]{20,40}\\." + this.extension);
        File[] entries = this.directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return pattern.matcher(name).matches();
            }
        });
        if (entries != null) {
            long maxAge = 432000000L;
            long now = System.currentTimeMillis();
            File[] fileArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                File entry = fileArray[n2];
                if (now - entry.lastModified() > maxAge) {
                    entry.delete();
                }
                ++n2;
            }
        }
    }
}

