/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.scan;

import com.sonatype.clm.dto.model.component.ComponentIdentifier;
import com.sonatype.clm.dto.model.ide.IdeMatchedComponent;
import com.sonatype.clm.dto.model.ide.ScannedComponent;
import com.sonatype.insight.ide.eclipse.internal.ArtifactKey;
import com.sonatype.insight.ide.eclipse.internal.Messages;
import com.sonatype.insight.ide.eclipse.internal.rest.InsightClientManager;
import com.sonatype.insight.ide.eclipse.internal.rest.JsonUtils;
import com.sonatype.insight.ide.eclipse.internal.rest.UrlBuilder;
import com.sonatype.insight.ide.eclipse.internal.scan.CacheManager;
import com.sonatype.insight.ide.eclipse.internal.scan.LoggerBridge;
import com.sonatype.insight.ide.eclipse.internal.ui.elements.UIDependencyElement;
import com.sonatype.insight.ide.scan.ArchiveReader;
import com.sonatype.insight.ide.scan.DigestException;
import com.sonatype.insight.ide.scan.Digester;
import com.sonatype.insight.ide.scan.ProprietaryComponentDetector;
import java.io.File;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.conn.ConnectTimeoutException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.statushandlers.StatusManager;
import org.slf4j.Logger;

public class InsightLookupCallable
implements Runnable {
    private static Digester digester;
    protected final UIDependencyElement element;
    protected final Listener listener;
    private final ScheduledExecutorService executor;

    public InsightLookupCallable(UIDependencyElement element, Listener listener, ScheduledExecutorService executor) {
        this.element = element;
        this.listener = listener;
        this.executor = executor;
    }

    @Override
    public void run() {
        if (!this.listener.shouldRun(this.element)) {
            return;
        }
        try {
            this.work();
        }
        catch (DigestException e) {
            this.listener.lookupFailed(this.element, 2, NLS.bind((String)Messages.InsightLookupCallable_errorDigest, (Object)this.element.getFileLocation()), e);
        }
        catch (HttpResponseException e) {
            int code = e.getStatusCode();
            if (code == 400) {
                this.listener.lookupFailed(this.element, code, e.getMessage(), e);
            } else if (code == 401) {
                this.listener.credentialsInvalid(code, Messages.InsightLookupCallable_Invalid_Credentials, e);
            } else if (code == 403 || code == 404) {
                this.listener.appIdInvalid(this.element.getApplicationId(), code, NLS.bind((String)Messages.InsightLookupCallable_Invalid_App_token, (Object)this.element.getApplicationId()), e);
            } else if (code == 503) {
                this.listener.serverUnreachable(code, Messages.InsightLookupCallable_Server_down, e);
            } else {
                this.listener.lookupFailed(this.element, code, Messages.InsightLookupCallable_unknownError, e);
            }
        }
        catch (UnknownHostException e) {
            this.listener.serverUnreachable(10, Messages.InsightLookupCallable_invalidHost, e);
        }
        catch (ConnectException e) {
            this.listener.serverUnreachable(10, Messages.InsightLookupCallable_invalidHost, e);
        }
        catch (ConnectTimeoutException e) {
            this.listener.serverUnreachable(10, Messages.InsightLookupCallable_invalidHost, e);
        }
        catch (Throwable e) {
            this.listener.lookupFailed(this.element, 1, Messages.InsightLookupCallable_unknownError, e);
        }
    }

    protected void work() throws Exception {
        String[] packages;
        File file = this.element.getFileLocation();
        if (file == null || !file.isFile()) {
            return;
        }
        String hash = CacheManager.getInstance().get(file);
        if (hash == null) {
            hash = this.getDigester().digestSimple(file);
            CacheManager.getInstance().put(file, hash);
        }
        if ((packages = CacheManager.getInstance().getPackages(hash)) == null) {
            Set pkgs = ArchiveReader.index((File)file);
            packages = pkgs.toArray(new String[pkgs.size()]);
            CacheManager.getInstance().put(hash, packages);
        }
        boolean proprietary = this.listener.getProprietaryDetector().isProprietary(packages);
        this.element.setProprietary(proprietary);
        new GetSimpleMatch(this, hash).work();
    }

    protected void handle(IStatus status, int style) {
        StatusManager.getManager().handle(status, style);
    }

    protected void schedule(Runnable task, int delay) {
        this.executor.schedule(task, (long)delay, TimeUnit.SECONDS);
    }

    protected String scanUrl(boolean enhanced, String hash, File file) {
        UrlBuilder url = new UrlBuilder(InsightClientManager.getInstance().getServerUrl());
        url.appendPath("rest/ide/scan/");
        url.appendSegment(enhanced ? "enhanced" : "simple");
        url.appendSegment(this.element.getApplicationId());
        url.appendSegment(hash);
        url.appendQueryParam("filename", file.getName());
        ArtifactKey mvnKey = this.element.getMavenArtifactKey();
        if (mvnKey != null) {
            url.appendQueryParam("componentIdentifier", JsonUtils.toJson(ComponentIdentifier.createMavenCoordinates((String)mvnKey.getGroupId(), (String)mvnKey.getArtifactId(), (String)mvnKey.getVersion(), (String)mvnKey.getClassifier(), (String)mvnKey.getExtension())));
        }
        if (this.element.isProprietary()) {
            url.appendQueryParam("proprietary", Boolean.toString(this.element.isProprietary()));
        }
        return url.build();
    }

    protected void loadElement(IdeMatchedComponent component) {
        this.element.setHash(component.getHash());
        try {
            this.element.setMatchState(UIDependencyElement.MatchState.valueOf(UIDependencyElement.MatchState.class, component.getMatchState().toUpperCase(Locale.ENGLISH)));
        }
        catch (RuntimeException runtimeException) {
            this.element.setMatchState(UIDependencyElement.MatchState.UNKNOWN);
        }
        this.element.setPolicyAlerts(component.getAlerts());
        ComponentIdentifier identifier = component.getComponentIdentifier();
        if (identifier != null && identifier.isMaven()) {
            ArtifactKey declared = this.element.getMavenArtifactKey();
            ArtifactKey matched = new ArtifactKey(identifier.get("groupId"), identifier.get("artifactId"), identifier.get("version"), identifier.get("classifier"), identifier.get("extension"));
            if (declared == null || !declared.isSameGav(matched)) {
                this.element.setMavenArtifactKey(matched);
            }
        }
        this.element.markAsLoaded();
        this.listener.lookupCompleted(this.element);
    }

    protected Digester getDigester() {
        if (digester == null) {
            digester = new Digester((Logger)new LoggerBridge());
        }
        return digester;
    }

    public static class GetEnhancedMatch
    extends InsightLookupCallable {
        private final String hash;
        private final long start;

        public GetEnhancedMatch(InsightLookupCallable template, String hash) {
            super(template.element, template.listener, template.executor);
            this.hash = hash;
            this.start = System.currentTimeMillis();
        }

        @Override
        protected void work() throws Exception {
            String url = this.scanUrl(true, this.hash, this.element.getFileLocation());
            try {
                IdeMatchedComponent match = InsightClientManager.getInstance().getClient().get(url, IdeMatchedComponent.class);
                if (match.getMatchState() != null) {
                    this.loadElement(match);
                } else {
                    if (System.currentTimeMillis() - this.start > 180000L) {
                        throw new TimeoutException("Timeout while waiting for scan results from server");
                    }
                    this.schedule(this, match.getWaitDelta());
                }
            }
            catch (HttpResponseException e) {
                if (e.getStatusCode() == 404) {
                    this.schedule(new ScanArchiveEntries(this, this.hash), 0);
                    return;
                }
                throw e;
            }
        }
    }

    public static class GetSimpleMatch
    extends InsightLookupCallable {
        private final String hash;

        public GetSimpleMatch(InsightLookupCallable template, String hash) {
            super(template.element, template.listener, template.executor);
            this.hash = hash;
        }

        @Override
        protected void work() throws Exception {
            String url = this.scanUrl(false, this.hash, this.element.getFileLocation());
            IdeMatchedComponent match = InsightClientManager.getInstance().getClient().get(url, IdeMatchedComponent.class);
            if (match.isSimpleMatch() && UIDependencyElement.MatchState.UNKNOWN.name().equalsIgnoreCase(match.getMatchState())) {
                this.schedule(new ScanArchiveEntries(this, this.hash), 0);
            } else {
                this.loadElement(match);
            }
        }
    }

    public static interface Listener {
        public ProprietaryComponentDetector getProprietaryDetector();

        public boolean shouldRun(UIDependencyElement var1);

        public void lookupCompleted(UIDependencyElement var1);

        public void lookupFailed(UIDependencyElement var1, int var2, String var3, Throwable var4);

        public void appIdInvalid(String var1, int var2, String var3, Throwable var4);

        public void serverUnreachable(int var1, String var2, Throwable var3);

        public void credentialsInvalid(int var1, String var2, Throwable var3);
    }

    public static class ScanArchiveEntries
    extends InsightLookupCallable {
        private final String hash;

        public ScanArchiveEntries(InsightLookupCallable template, String hash) {
            super(template.element, template.listener, template.executor);
            this.hash = hash;
        }

        @Override
        protected void work() throws Exception {
            File file = this.element.getFileLocation();
            ScannedComponent scan = CacheManager.getInstance().get(this.hash);
            if (scan == null) {
                scan = this.scan(file);
                CacheManager.getInstance().put(this.hash, scan);
            }
            this.hideProprietaryPaths(scan);
            String url = this.scanUrl(true, this.hash, file);
            IdeMatchedComponent match = InsightClientManager.getInstance().getClient().post(url, scan, IdeMatchedComponent.class);
            if (match.getMatchState() != null) {
                this.loadElement(match);
            } else {
                this.schedule(new GetEnhancedMatch(this, this.hash), match.getWaitDelta());
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private ScannedComponent scan(File file) {
            ScannedComponent scan = new ScannedComponent();
            Throwable throwable = null;
            Object var4_5 = null;
            try (ArchiveReader reader = new ArchiveReader(file);){
                while (true) {
                    if (!reader.next()) {
                        return scan;
                    }
                    try {
                        Map hashes = this.getDigester().digestEnhanced(reader.getEntry());
                        scan.add(reader.getEntryPath(), hashes);
                    }
                    catch (Exception e) {
                        this.handle((IStatus)new Status(2, "com.sonatype.clm.ide.eclipse", NLS.bind((String)Messages.InsightLookupCallable_errorDigest, (Object)reader.getEntry()), (Throwable)e), 1);
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }

        private void hideProprietaryPaths(ScannedComponent scan) {
            if (scan.getEntries() == null) {
                return;
            }
            ProprietaryComponentDetector proprietaryDetector = this.listener.getProprietaryDetector();
            for (ScannedComponent.ScannedComponentEntry entry : scan.getEntries()) {
                if (!proprietaryDetector.isProprietary(entry.getPath())) continue;
                entry.setPath(null);
            }
        }
    }
}

