/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.scan;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class OuterHashCache {
    private volatile ConcurrentMap<File, Entry> entries = new ConcurrentHashMap<File, Entry>(1024);
    private volatile boolean dirty;

    public String get(File file) {
        Entry entry = (Entry)this.entries.get(file);
        if (entry == null) {
            return null;
        }
        if (entry.modified != file.lastModified() || entry.size != file.length()) {
            if (this.entries.remove(file, entry)) {
                this.dirty = true;
                return null;
            }
            return this.get(file);
        }
        return entry.hash;
    }

    public void put(File file, String hash) {
        Entry entry = new Entry(hash, file.lastModified(), file.length());
        this.entries.put(file, entry);
        this.dirty = true;
    }

    public void purgeStaleEntries() {
        ArrayList stale = new ArrayList();
        for (Map.Entry entry : this.entries.entrySet()) {
            File file = (File)entry.getKey();
            if (file.lastModified() == ((Entry)entry.getValue()).modified && file.length() == ((Entry)entry.getValue()).size) continue;
            stale.add(entry);
        }
        for (Map.Entry entry : stale) {
            if (!this.entries.remove(entry.getKey(), entry.getValue())) continue;
            this.dirty = true;
        }
    }

    public void clear() {
        this.entries.clear();
        this.dirty = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void load(File file) throws IOException {
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));){
                this.entries = (ConcurrentMap)ois.readObject();
                this.dirty = false;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (ClassCastException e) {
            throw new IOException(e);
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    public void save(File file) throws IOException {
        file.getAbsoluteFile().getParentFile().mkdirs();
        Throwable throwable = null;
        Object var3_4 = null;
        try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(file));){
            oos.writeObject(this.entries);
            this.dirty = false;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    static class Entry
    implements Serializable {
        private static final long serialVersionUID = 8741694798145551452L;
        final String hash;
        final long modified;
        final long size;

        public Entry(String hash, long modified, long size) {
            if (hash == null) {
                throw new IllegalArgumentException("hash missing");
            }
            this.hash = hash;
            this.modified = modified;
            this.size = size;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !Entry.class.equals(obj.getClass())) {
                return false;
            }
            Entry that = (Entry)obj;
            return this.modified == that.modified && this.size == that.size && this.hash.equals(that.hash);
        }

        public int hashCode() {
            return this.hash.hashCode();
        }

        public String toString() {
            return this.hash;
        }
    }
}

