/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.search;

import com.sonatype.insight.ide.eclipse.internal.Messages;
import com.sonatype.insight.ide.eclipse.internal.helpers.MavenHelper;
import com.sonatype.insight.ide.eclipse.internal.search.DependencySearchQuery;
import com.sonatype.insight.ide.eclipse.m2e.abstraction.v2_0.internal.PomEditorHelper;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.Model;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.OpenAndLinkWithEditorHelper;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.statushandlers.StatusManager;

public final class DependencyOpenAndLinkWithEditorHelper
extends OpenAndLinkWithEditorHelper {
    private TreeViewer viewer;

    public DependencyOpenAndLinkWithEditorHelper(TreeViewer viewer) {
        super((StructuredViewer)viewer);
        this.viewer = viewer;
    }

    protected void activate(ISelection selection) {
        int currentMode = OpenStrategy.getOpenMethod();
        try {
            OpenStrategy.setOpenMethod((int)0);
            this.handleOpen(selection);
        }
        finally {
            OpenStrategy.setOpenMethod((int)currentMode);
        }
    }

    protected void linkToEditor(ISelection selection) {
    }

    protected void open(ISelection selection, boolean activate) {
        this.handleOpen(selection);
    }

    public void handleOpen(ISelection selection) {
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            Object selected = ((IStructuredSelection)selection).getFirstElement();
            try {
                if (selected instanceof DependencySearchQuery.PomTuple) {
                    TreeItem[] treeItemArray = this.viewer.getTree().getSelection();
                    int n = treeItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem item = treeItemArray[n2];
                        if (item.getData() == selected) {
                            final DependencySearchQuery.PomTuple sel = (DependencySearchQuery.PomTuple)selected;
                            TreeItem parent = item.getParentItem();
                            if (parent != null) {
                                final IMavenProjectFacade facade = MavenPlugin.getMavenProjectRegistry().getProject(((IResource)parent.getData()).getProject());
                                if (facade == null) {
                                    IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)((IFile)parent.getData()));
                                    StatusManager.getManager().handle((IStatus)new Status(4, "com.sonatype.clm.ide.eclipse", Messages.DependencyOpenAndLinkWithEditorHelper_failedLoadingMavenProject), 2);
                                    return;
                                }
                                new Job(Messages.DependencyOpenAndLinkWithEditorHelper_openPomJobName){

                                    protected IStatus run(IProgressMonitor monitor) {
                                        MavenProject project;
                                        try {
                                            project = facade.getMavenProject((IProgressMonitor)new NullProgressMonitor());
                                        }
                                        catch (CoreException e) {
                                            return e.getStatus();
                                        }
                                        Model model = project.getModel();
                                        List dependencies = model.getDependencies();
                                        if (dependencies != null) {
                                            for (Dependency dependency : dependencies) {
                                                if (!dependency.getArtifactId().equals(sel.getKey().getArtifactId()) || !dependency.getGroupId().equals(sel.getKey().getGroupId())) continue;
                                                DependencyOpenAndLinkWithEditorHelper.this.open(dependency.getLocation((Object)"artifactId"), project);
                                                return Status.OK_STATUS;
                                            }
                                        }
                                        return Status.OK_STATUS;
                                    }
                                }.schedule();
                            }
                        }
                        ++n2;
                    }
                }
                if (selected instanceof DependencySearchQuery.IFileResult) {
                    IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)((DependencySearchQuery.IFileResult)selected).getFile());
                }
                if (selected instanceof IFile) {
                    IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)((IFile)selected));
                } else if (selected instanceof DependencySearchQuery.RemotePomResult) {
                    MavenHelper.openPOM(((DependencySearchQuery.RemotePomResult)selected).getArtifactKey().getKey());
                    ((DependencySearchQuery.RemotePomResult)selected).getArtifactKey();
                } else if (selected instanceof DependencySearchQuery.JavaBuildPathSearchResult) {
                    PreferencesUtil.createPropertyDialogOn((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (IAdaptable)((DependencySearchQuery.JavaBuildPathSearchResult)selected).getProject(), (String)"org.eclipse.jdt.ui.propertyPages.BuildPathsPropertyPage", null, null).open();
                } else if (this.viewer.isExpandable(selected)) {
                    this.viewer.setExpandedState(selected, !this.viewer.getExpandedState(selected));
                }
            }
            catch (PartInitException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "com.sonatype.clm.ide.eclipse", NLS.bind((String)Messages.DependencyOpenAndLinkWithEditorHelper_errorOpenPom, (Object)selected.toString()), (Throwable)e), 2);
            }
        }
    }

    private void open(final InputLocation location, final MavenProject mavenProject) {
        try {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        PomEditorHelper pomEditorHelper = new PomEditorHelper();
                        pomEditorHelper.openXmlEditor(location, mavenProject);
                    }
                    catch (Exception e) {
                        StatusManager.getManager().handle((IStatus)new Status(4, "com.sonatype.clm.ide.eclipse", Messages.DependencyOpenAndLinkWithEditorHelper_errorOpeningPom, (Throwable)e), 2);
                    }
                }
            });
        }
        catch (SecurityException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "com.sonatype.clm.ide.eclipse", Messages.DependencyOpenAndLinkWithEditorHelper_errorOpeningPom, (Throwable)e), 2);
        }
    }
}

