/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.search;

import com.sonatype.insight.ide.eclipse.internal.ArtifactKey;
import com.sonatype.insight.ide.eclipse.internal.Messages;
import com.sonatype.insight.ide.eclipse.internal.ProjectConfigurationDTO;
import com.sonatype.insight.ide.eclipse.internal.helpers.ClasspathHelper;
import com.sonatype.insight.ide.eclipse.internal.search.DependencySearchResult;
import com.sonatype.insight.ide.eclipse.internal.search.IMavenDependencySearch;
import com.sonatype.insight.ide.eclipse.internal.search.MavenDependencySearchImpl;
import com.sonatype.insight.ide.eclipse.internal.ui.DependencyContentProvider;
import com.sonatype.insight.ide.eclipse.internal.ui.elements.UIDependencyElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.osgi.util.NLS;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.ui.statushandlers.StatusManager;

public class DependencySearchQuery
implements ISearchQuery,
IMavenDependencySearch.IMavenDependencySearchListener {
    final UIDependencyElement element;
    private DependencySearchResult result;
    private final ClasspathHelper.IClasspathEntryVisitor visitor = new ClasspathHelper.IClasspathEntryVisitor(){

        @Override
        public void visit(IClasspathEntry entry, IProject project, IClasspathContainer container, ProjectConfigurationDTO projectConfiguration, IProgressMonitor monitor) {
            if (DependencySearchQuery.this.element.getComponentKey().equals(DependencyContentProvider.getComponentKey(entry, projectConfiguration.applicationId))) {
                if (container != null) {
                    if (container.getPath().toString().equals("org.eclipse.m2e.MAVEN2_CLASSPATH_CONTAINER")) {
                        try {
                            IMavenProjectFacade mavenProjectFacade = MavenPlugin.getMavenProjectRegistry().getProject(project);
                            MavenDependencySearchImpl search = new MavenDependencySearchImpl();
                            search.addListener(DependencySearchQuery.this);
                            search.process(DependencySearchQuery.this.element.getDeclaredArtifactKey(), mavenProjectFacade, (IProgressMonitor)new NullProgressMonitor());
                            if (mavenProjectFacade == null) {
                                return;
                            }
                        }
                        catch (CoreException e) {
                            StatusManager.getManager().handle(e, "com.sonatype.clm.ide.eclipse");
                        }
                    } else if (container.getPath().toString().equals("org.eclipse.pde.core.requiredPlugins")) {
                        DependencySearchQuery.this.result.addResult(new IFileResult(project.getFile("META-INF/MANIFEST.MF")));
                    } else if (container.getPath().toString().startsWith("org.apache.ivyde.eclipse.cpcontainer.IVYDE_CONTAINER")) {
                        DependencySearchQuery.this.result.addResult(new IFileResult(project.getFile("ivy.xml")));
                    }
                } else {
                    try {
                        if (project.hasNature("org.eclipse.pde.PluginNature")) {
                            DependencySearchQuery.this.result.addResult(new IFileResult(project.getFile("META-INF/MANIFEST.MF")));
                            return;
                        }
                    }
                    catch (CoreException coreException) {
                        return;
                    }
                    DependencySearchQuery.this.result.addResult(new JavaBuildPathSearchResult(project));
                }
            }
        }
    };

    public DependencySearchQuery(UIDependencyElement element) {
        this.element = element;
        this.result = new DependencySearchResult(this);
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        ClasspathHelper.visitWorkspaceClasspath(ResourcesPlugin.getWorkspace().getRoot().getProjects(), this.visitor, monitor);
        return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
    }

    public String getLabel() {
        return NLS.bind((String)Messages.DependencySearchQuery_queryLabel, (Object)(this.element.getMavenArtifactKey() == null ? this.element.getName() : this.element.getMavenArtifactKey().toString()));
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        return this.result;
    }

    @Override
    public void addResult(IMavenProjectFacade facade, Set<ArtifactKey> matches) {
        if (facade.getProject() != null) {
            PomResult pomResult = (PomResult)this.result.getResult((IResource)facade.getPom());
            if (pomResult == null) {
                pomResult = new PomResult((IResource)facade.getPom());
            }
            pomResult.addAll(matches);
            this.result.addResult(pomResult);
        } else {
            this.result.addResult(new RemotePomResult(facade.getMavenProject()));
        }
    }

    static class IFileResult
    implements Result {
        private final IFile file;

        IFileResult(IFile file) {
            this.file = file;
        }

        public IFile getFile() {
            return this.file;
        }
    }

    static class JavaBuildPathSearchResult
    implements Result {
        private IProject project;

        JavaBuildPathSearchResult(IProject project) {
            this.project = project;
        }

        public IProject getProject() {
            return this.project;
        }

        public int hashCode() {
            return this.project.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof JavaBuildPathSearchResult && this.project.equals((Object)((JavaBuildPathSearchResult)o).project);
        }
    }

    static class PomResult
    implements Result {
        private List<PomTuple> keys = new ArrayList<PomTuple>();
        private IResource pomFile;

        PomResult(IResource pomFile) {
            this.pomFile = pomFile;
        }

        public void addAll(Set<ArtifactKey> key) {
            for (ArtifactKey k : key) {
                this.keys.add(new PomTuple(k, this));
            }
        }

        IResource getPom() {
            return this.pomFile;
        }

        Collection<PomTuple> getKeys() {
            return this.keys;
        }
    }

    static class PomTuple
    implements Result {
        private final ArtifactKey key;
        private final Result parent;

        PomTuple(ArtifactKey key, Result parent) {
            this.key = key;
            this.parent = parent;
        }

        public Result getParent() {
            return this.parent;
        }

        public ArtifactKey getKey() {
            return this.key;
        }
    }

    static class RemotePomResult
    implements Result {
        private PomTuple key;

        RemotePomResult(MavenProject project) {
            this.key = new PomTuple(new ArtifactKey(project.getGroupId(), project.getArtifactId(), project.getVersion()), this);
        }

        public PomTuple getArtifactKey() {
            return this.key;
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }

    static interface Result {
    }
}

