/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.search;

import com.sonatype.insight.ide.eclipse.Images;
import com.sonatype.insight.ide.eclipse.internal.Messages;
import com.sonatype.insight.ide.eclipse.internal.search.DependencySearchQuery;
import com.sonatype.insight.ide.eclipse.internal.ui.elements.UIDependencyElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.search.ui.SearchResultEvent;

public class DependencySearchResult
implements ISearchResult {
    private DependencySearchQuery dependencySearchQuery;
    private Set<ISearchResultListener> listeners = new HashSet<ISearchResultListener>();
    private List<DependencySearchQuery.Result> results = new ArrayList<DependencySearchQuery.Result>();
    private Map<IResource, DependencySearchQuery.Result> resourceResults = new HashMap<IResource, DependencySearchQuery.Result>();

    public DependencySearchResult(DependencySearchQuery dependencySearchQuery) {
        this.dependencySearchQuery = dependencySearchQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ISearchResultListener l) {
        Set<ISearchResultListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ISearchResultListener l) {
        Set<ISearchResultListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    public String getLabel() {
        UIDependencyElement element = this.dependencySearchQuery.element;
        return NLS.bind((String)Messages.DependencySearchResult_resultLabel, (Object[])new String[]{element.getMavenArtifactKey() == null ? element.getName() : element.getMavenArtifactKey().toString(), String.valueOf(this.results.size())});
    }

    public String getTooltip() {
        return this.dependencySearchQuery.getLabel();
    }

    public ImageDescriptor getImageDescriptor() {
        return Images.getImageDescriptor("sonatype_16x16.png");
    }

    public ISearchQuery getQuery() {
        return this.dependencySearchQuery;
    }

    public UIDependencyElement getElement() {
        return this.dependencySearchQuery.element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DependencySearchQuery.Result[] getResults() {
        List<DependencySearchQuery.Result> list = this.results;
        synchronized (list) {
            return this.results.toArray(new DependencySearchQuery.Result[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addResult(DependencySearchQuery.Result o) {
        if (!this.results.contains(o)) {
            Collection<DependencySearchQuery.Result> collection = this.results;
            synchronized (collection) {
                this.results.add(o);
                if (o instanceof DependencySearchQuery.PomResult) {
                    this.resourceResults.put(((DependencySearchQuery.PomResult)o).getPom(), o);
                } else if (o instanceof DependencySearchQuery.IFileResult) {
                    this.resourceResults.put((IResource)((DependencySearchQuery.IFileResult)o).getFile(), o);
                }
            }
            collection = this.listeners;
            synchronized (collection) {
                DependencySearchResultEvent event = new DependencySearchResultEvent(this, o);
                for (ISearchResultListener listener : this.listeners) {
                    listener.searchResultChanged((SearchResultEvent)event);
                }
            }
        }
    }

    DependencySearchQuery.Result getResult(IResource pom) {
        return this.resourceResults.get(pom);
    }

    class DependencySearchResultEvent
    extends SearchResultEvent {
        private final DependencySearchQuery.Result added;

        DependencySearchResultEvent(DependencySearchResult result, DependencySearchQuery.Result added) {
            super((ISearchResult)result);
            this.added = added;
        }

        public DependencySearchQuery.Result getAdded() {
            return this.added;
        }
    }
}

