/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.search;

import com.sonatype.insight.ide.eclipse.Images;
import com.sonatype.insight.ide.eclipse.internal.ArtifactKey;
import com.sonatype.insight.ide.eclipse.internal.Messages;
import com.sonatype.insight.ide.eclipse.internal.search.DependencyOpenAndLinkWithEditorHelper;
import com.sonatype.insight.ide.eclipse.internal.search.DependencySearchQuery;
import com.sonatype.insight.ide.eclipse.internal.search.DependencySearchResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.m2e.core.ui.internal.MavenImages;
import org.eclipse.search.internal.ui.SearchPluginImages;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.search.ui.ISearchResultPage;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.SearchResultEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;

public class DependencySearchResultPage
extends Page
implements ISearchResultPage {
    private String fId;
    private DependencySearchResult fSearch;
    private ISearchResultViewPart fViewPart;
    private PageBook fPagebook;
    private TreeViewer viewer;
    private final IAction fShowNextAction = new ShowNextResultAction();
    private final IAction fShowPreviousAction = new ShowPrevResultAction();

    public Object getUIState() {
        return null;
    }

    public void setInput(ISearchResult search, Object uiState) {
        this.fSearch = (DependencySearchResult)search;
        if (this.fSearch != null) {
            this.viewer.setInput((Object)this.fSearch);
        }
    }

    public void setViewPart(ISearchResultViewPart part) {
        this.fViewPart = part;
    }

    public void restoreState(IMemento memento) {
    }

    public void saveState(IMemento memento) {
    }

    public void setID(String id) {
        this.fId = id;
    }

    public String getID() {
        return this.fId;
    }

    public String getLabel() {
        if (this.fSearch != null) {
            return this.fSearch.getLabel();
        }
        return "";
    }

    public void createControl(Composite parent) {
        this.fPagebook = new PageBook(parent, 0);
        this.fPagebook.setLayoutData((Object)new GridData(1808));
        this.viewer = new TreeViewer((Composite)this.fPagebook);
        this.viewer.setUseHashlookup(true);
        this.viewer.setContentProvider((IContentProvider)new DependencySearchContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new DependencySearchLabelProvider()));
        new DependencyOpenAndLinkWithEditorHelper(this.viewer);
        this.fPagebook.showPage((Control)this.viewer.getTree());
        IToolBarManager tbm = this.getSite().getActionBars().getToolBarManager();
        tbm.appendToGroup("group.show", this.fShowNextAction);
        tbm.appendToGroup("group.show", this.fShowPreviousAction);
        tbm.update(false);
        IActionBars actionBars = this.getSite().getActionBars();
        if (actionBars != null) {
            actionBars.setGlobalActionHandler(ActionFactory.NEXT.getId(), this.fShowNextAction);
            actionBars.setGlobalActionHandler(ActionFactory.PREVIOUS.getId(), this.fShowPreviousAction);
        }
    }

    public Control getControl() {
        return this.fPagebook;
    }

    public void setFocus() {
    }

    private DependencySearchQuery.Result getFirstSelectedElement() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() > 0) {
            Object o = selection.getFirstElement();
            if (o instanceof DependencySearchQuery.Result) {
                return (DependencySearchQuery.Result)o;
            }
            if (o instanceof IResource) {
                return this.fSearch.getResult((IResource)o);
            }
        }
        return null;
    }

    public void nextResult() {
        DependencySearchQuery.Result newOne;
        int index;
        DependencySearchQuery.Result res = this.getFirstSelectedElement();
        if (res instanceof DependencySearchQuery.PomTuple) {
            DependencySearchQuery.PomTuple tuple = (DependencySearchQuery.PomTuple)res;
            res = tuple.getParent();
            DependencySearchQuery.PomResult pom = (DependencySearchQuery.PomResult)tuple.getParent();
            Iterator<DependencySearchQuery.PomTuple> it = pom.getKeys().iterator();
            while (it.hasNext()) {
                if (it.next() != tuple || !it.hasNext()) continue;
                this.viewer.setSelection((ISelection)new StructuredSelection((Object)it.next()), true);
                return;
            }
        }
        List<DependencySearchQuery.Result> all = Arrays.asList(this.fSearch.getResults());
        int n = index = res == null ? -1 : all.indexOf(res);
        if (index == all.size() - 1) {
            index = -1;
        }
        Object sel = (newOne = all.get(++index)) instanceof DependencySearchQuery.IFileResult ? ((DependencySearchQuery.IFileResult)newOne).getFile() : (newOne instanceof DependencySearchQuery.PomResult ? ((DependencySearchQuery.PomResult)newOne).getKeys().iterator().next() : newOne);
        this.viewer.setSelection((ISelection)new StructuredSelection(sel), true);
    }

    public void prevResult() {
        Object sel;
        DependencySearchQuery.Result newOne;
        int index;
        DependencySearchQuery.Result res = this.getFirstSelectedElement();
        if (res instanceof DependencySearchQuery.PomTuple) {
            DependencySearchQuery.PomTuple tuple = (DependencySearchQuery.PomTuple)res;
            res = tuple.getParent();
            DependencySearchQuery.PomResult pom = (DependencySearchQuery.PomResult)tuple.getParent();
            Iterator<DependencySearchQuery.PomTuple> it = pom.getKeys().iterator();
            DependencySearchQuery.PomTuple prev = null;
            while (it.hasNext()) {
                DependencySearchQuery.PomTuple curr = it.next();
                if (curr == tuple) {
                    if (prev == null) break;
                    this.viewer.setSelection((ISelection)new StructuredSelection((Object)prev), true);
                    return;
                }
                prev = curr;
            }
        }
        List<DependencySearchQuery.Result> all = Arrays.asList(this.fSearch.getResults());
        int n = index = res == null ? all.size() : all.indexOf(res);
        if (index == 0) {
            index = all.size();
        }
        if ((newOne = all.get(--index)) instanceof DependencySearchQuery.IFileResult) {
            sel = ((DependencySearchQuery.IFileResult)newOne).getFile();
        } else if (newOne instanceof DependencySearchQuery.PomResult) {
            Iterator<DependencySearchQuery.PomTuple> it = ((DependencySearchQuery.PomResult)newOne).getKeys().iterator();
            sel = null;
            while (it.hasNext()) {
                sel = it.next();
            }
        } else {
            sel = newOne;
        }
        this.viewer.setSelection((ISelection)new StructuredSelection(sel), true);
    }

    private class DependencySearchContentProvider
    implements ITreeContentProvider,
    ISearchResultListener {
        private Map<IResource, List<Object>> children = new HashMap<IResource, List<Object>>();
        private DependencySearchResult fInput;
        private List<Object> roots;

        private DependencySearchContentProvider() {
        }

        public void dispose() {
            if (this.fInput != null) {
                this.fInput.removeListener(this);
            }
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (oldInput != null && oldInput instanceof DependencySearchResult) {
                ((DependencySearchResult)oldInput).removeListener(this);
            }
            if (newInput != null && newInput instanceof DependencySearchResult) {
                this.fInput = (DependencySearchResult)newInput;
                this.fInput.addListener(this);
                this.roots = new ArrayList<Object>();
                this.children = new HashMap<IResource, List<Object>>();
                DependencySearchQuery.Result[] resultArray = this.fInput.getResults();
                int n = resultArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DependencySearchQuery.Result o = resultArray[n2];
                    this.addElement(o);
                    ++n2;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addElement(DependencySearchQuery.Result o) {
            if (o instanceof DependencySearchQuery.IFileResult) {
                IFile file;
                Object r = file = ((DependencySearchQuery.IFileResult)o).getFile();
                while (!(r instanceof IProject)) {
                    Map<IResource, List<Object>> map = this.children;
                    synchronized (map) {
                        this.children.put((IResource)r.getParent(), Collections.singletonList(r));
                    }
                    r = r.getParent();
                }
                r = this.roots;
                synchronized (r) {
                    if (!this.roots.contains(file.getProject())) {
                        this.roots.add(file.getProject());
                    }
                }
            }
            if (o instanceof DependencySearchQuery.PomResult) {
                DependencySearchQuery.PomResult pom = (DependencySearchQuery.PomResult)o;
                IResource r = pom.getPom();
                while (!(r instanceof IProject)) {
                    this.add((IResource)r.getParent(), new Object[]{r});
                    r = r.getParent();
                }
                this.add(pom.getPom(), pom.getKeys().toArray());
                List<Object> list = this.roots;
                synchronized (list) {
                    if (!this.roots.contains(pom.getPom().getProject())) {
                        this.roots.add(pom.getPom().getProject());
                    }
                }
            }
            List<Object> list = this.roots;
            synchronized (list) {
                if (!this.roots.contains(o)) {
                    this.roots.add(o);
                }
            }
            if (Display.getCurrent() == null) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ((DependencySearchContentProvider)DependencySearchContentProvider.this).DependencySearchResultPage.this.viewer.refresh();
                        ((DependencySearchContentProvider)DependencySearchContentProvider.this).DependencySearchResultPage.this.fViewPart.updateLabel();
                    }
                });
            } else {
                DependencySearchResultPage.this.viewer.refresh();
                DependencySearchResultPage.this.fViewPart.updateLabel();
            }
            if (this.roots.size() == 1) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DependencySearchResultPage.this.nextResult();
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void add(IResource r, Object[] o) {
            Map<IResource, List<Object>> map = this.children;
            synchronized (map) {
                List<Object> set = this.children.get(r);
                if (set == null) {
                    set = new ArrayList<Object>();
                    this.children.put(r, set);
                }
                Object[] objectArray = o;
                int n = o.length;
                int n2 = 0;
                while (n2 < n) {
                    Object oo = objectArray[n2];
                    if (!set.contains(oo)) {
                        set.add(oo);
                    }
                    ++n2;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof DependencySearchResult) {
                List<Object> list = this.roots;
                synchronized (list) {
                    return this.roots.toArray();
                }
            }
            return new Object[0];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] getChildren(Object parentElement) {
            Map<IResource, List<Object>> map = this.children;
            synchronized (map) {
                List<Object> results = this.children.get(parentElement);
                if (results != null) {
                    return results.toArray();
                }
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof IResource && !(element instanceof IProject)) {
                return ((IResource)element).getParent();
            }
            if (element instanceof DependencySearchQuery.PomTuple) {
                DependencySearchQuery.Result result = ((DependencySearchQuery.PomTuple)element).getParent();
                if (result instanceof DependencySearchQuery.IFileResult) {
                    return ((DependencySearchQuery.IFileResult)result).getFile();
                }
                if (result instanceof DependencySearchQuery.PomResult) {
                    return ((DependencySearchQuery.PomResult)result).getPom();
                }
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.children.containsKey(element);
        }

        public void searchResultChanged(SearchResultEvent e) {
            if (e instanceof DependencySearchResult.DependencySearchResultEvent) {
                this.addElement(((DependencySearchResult.DependencySearchResultEvent)e).getAdded());
            }
        }
    }

    private class DependencySearchLabelProvider
    extends LabelProvider
    implements IColorProvider,
    IFontProvider,
    DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private WorkbenchLabelProvider workbenchLabelProvider = new WorkbenchLabelProvider();
        private LocalResourceManager resourceManager;

        private DependencySearchLabelProvider() {
        }

        public void dispose() {
            if (this.resourceManager != null) {
                this.resourceManager.dispose();
                this.resourceManager = null;
            }
        }

        public Image getImage(Object element) {
            if (element instanceof IResource) {
                return this.workbenchLabelProvider.getImage(element);
            }
            if (element instanceof DependencySearchQuery.JavaBuildPathSearchResult) {
                return Images.getImage("obj16/configure_build_path.gif");
            }
            if (element instanceof DependencySearchQuery.RemotePomResult) {
                return Images.getImage(MavenImages.POM);
            }
            if (element instanceof DependencySearchQuery.PomTuple) {
                return Images.getImage("obj16/jar_obj.gif");
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof IResource) {
                return this.workbenchLabelProvider.getText(element);
            }
            if (element instanceof DependencySearchQuery.JavaBuildPathSearchResult) {
                return this.workbenchLabelProvider.getText((Object)((DependencySearchQuery.JavaBuildPathSearchResult)element).getProject());
            }
            if (element instanceof DependencySearchQuery.RemotePomResult) {
                return ((DependencySearchQuery.RemotePomResult)element).getArtifactKey().getKey().getArtifactId();
            }
            if (element instanceof DependencySearchQuery.PomTuple) {
                return ((DependencySearchQuery.PomTuple)element).getKey().toString();
            }
            return "";
        }

        public StyledString getStyledText(Object element) {
            if (element instanceof IResource) {
                return new StyledString(this.workbenchLabelProvider.getText(element));
            }
            if (element instanceof DependencySearchQuery.JavaBuildPathSearchResult) {
                return new StyledString(this.workbenchLabelProvider.getText((Object)((DependencySearchQuery.JavaBuildPathSearchResult)element).getProject()));
            }
            if (element instanceof DependencySearchQuery.RemotePomResult) {
                ArtifactKey searched;
                ArtifactKey key = ((DependencySearchQuery.RemotePomResult)element).getArtifactKey().getKey();
                StyledString ss = new StyledString();
                ss.append(key.getArtifactId());
                ss.append(" - ");
                ss.append(key.getVersion(), StyledString.DECORATIONS_STYLER);
                ArtifactKey artifactKey = searched = DependencySearchResultPage.this.fSearch.getElement() == null ? null : DependencySearchResultPage.this.fSearch.getElement().getMavenArtifactKey();
                if (!key.equals(searched)) {
                    ss.append(Messages.DependencySearchResultPage_transitively, StyledString.QUALIFIER_STYLER);
                }
                return ss;
            }
            if (element instanceof DependencySearchQuery.PomTuple) {
                ArtifactKey searched;
                ArtifactKey key = ((DependencySearchQuery.PomTuple)element).getKey();
                StyledString ss = new StyledString();
                ss.append(key.getArtifactId());
                ss.append(" - ");
                ss.append(key.getVersion(), StyledString.DECORATIONS_STYLER);
                ArtifactKey artifactKey = searched = DependencySearchResultPage.this.fSearch.getElement() == null ? null : DependencySearchResultPage.this.fSearch.getElement().getMavenArtifactKey();
                if (!key.equals(searched)) {
                    ss.append(Messages.DependencySearchResultPage_transitively, StyledString.QUALIFIER_STYLER);
                }
                return ss;
            }
            return new StyledString();
        }

        public Font getFont(Object element) {
            if (element instanceof IResource) {
                return this.workbenchLabelProvider.getFont(element);
            }
            if (element instanceof DependencySearchQuery.JavaBuildPathSearchResult) {
                return this.workbenchLabelProvider.getFont((Object)((DependencySearchQuery.JavaBuildPathSearchResult)element).getProject());
            }
            return null;
        }

        public Color getForeground(Object element) {
            if (element instanceof IResource) {
                return this.workbenchLabelProvider.getForeground(element);
            }
            if (element instanceof DependencySearchQuery.JavaBuildPathSearchResult) {
                return this.workbenchLabelProvider.getForeground((Object)((DependencySearchQuery.JavaBuildPathSearchResult)element).getProject());
            }
            if (element instanceof DependencySearchQuery.RemotePomResult) {
                return (Color)this.getResourceManager().get((DeviceResourceDescriptor)ColorDescriptor.createFrom((RGB)new RGB(0, 0, 0)));
            }
            return null;
        }

        public Color getBackground(Object element) {
            if (element instanceof IResource) {
                return this.workbenchLabelProvider.getBackground(element);
            }
            if (element instanceof DependencySearchQuery.JavaBuildPathSearchResult) {
                return this.workbenchLabelProvider.getBackground((Object)((DependencySearchQuery.JavaBuildPathSearchResult)element).getProject());
            }
            if (element instanceof DependencySearchQuery.RemotePomResult) {
                return (Color)this.getResourceManager().get((DeviceResourceDescriptor)ColorDescriptor.createFrom((RGB)new RGB(255, 255, 255)));
            }
            return null;
        }

        private ResourceManager getResourceManager() {
            if (this.resourceManager == null) {
                this.resourceManager = new LocalResourceManager(JFaceResources.getResources());
            }
            return this.resourceManager;
        }
    }

    public class ShowNextResultAction
    extends Action {
        public ShowNextResultAction() {
            super(Messages.DependencySearchResultPage_showNext);
            SearchPluginImages.setImageDescriptors((IAction)this, (String)"lcl16/", (String)"org.eclipse.search.ui.search_next.png");
            this.setToolTipText(Messages.DependencySearchResultPage_showNextMatch);
            this.setActionDefinitionId("org.eclipse.ui.navigate.next");
        }

        public void run() {
            DependencySearchResultPage.this.nextResult();
        }
    }

    public class ShowPrevResultAction
    extends Action {
        public ShowPrevResultAction() {
            super(Messages.DependencySearchResultPage_showPrevious);
            SearchPluginImages.setImageDescriptors((IAction)this, (String)"lcl16/", (String)"org.eclipse.search.ui.search_prev.png");
            this.setToolTipText(Messages.DependencySearchResultPage_showPreviousMatch);
            this.setActionDefinitionId("org.eclipse.ui.navigate.previous");
        }

        public void run() {
            DependencySearchResultPage.this.prevResult();
        }
    }
}

