/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.search;

import com.sonatype.insight.ide.eclipse.internal.ArtifactKey;
import com.sonatype.insight.ide.eclipse.internal.search.IMavenDependencySearch;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Profile;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.ui.internal.util.ParentGatherer;
import org.eclipse.m2e.core.ui.internal.util.ParentHierarchyEntry;
import org.eclipse.osgi.util.NLS;

public class MavenDependencySearchImpl
implements IMavenDependencySearch {
    private Set<IMavenDependencySearch.IMavenDependencySearchListener> listeners = new HashSet<IMavenDependencySearch.IMavenDependencySearchListener>();

    @Override
    public void process(ArtifactKey artifact, IMavenProjectFacade mavenProjectFacade, IProgressMonitor progressMonitor) throws CoreException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (String)NLS.bind((String)"Searching project {0}", (Object)mavenProjectFacade.getProject().getName()), (int)3);
        try {
            MavenProject mavenProject = mavenProjectFacade.getMavenProject((IProgressMonitor)monitor.newChild(1));
            LinkedList<ArtifactKey> roots = new LinkedList<ArtifactKey>();
            DependencyNode projectRootNode = MavenPlugin.getMavenModelManager().readDependencyTree(mavenProjectFacade, mavenProject, "test", (IProgressMonitor)monitor.newChild(1));
            Collection<Object> rootNodes = projectRootNode.getDependency() == null ? projectRootNode.getChildren() : Collections.singleton(projectRootNode);
            for (DependencyNode dependencyNode : rootNodes) {
                DependencyNode node = this.locate(dependencyNode, artifact);
                if (node == null) continue;
                Artifact a = node.getDependency().getArtifact();
                roots.add(new ArtifactKey(a.getGroupId(), a.getArtifactId(), a.getBaseVersion(), a.getClassifier(), a.getExtension()));
            }
            block4: for (ParentHierarchyEntry parentHierarchyEntry : new ParentGatherer(mavenProjectFacade).getParentHierarchy((IProgressMonitor)monitor.newChild(1))) {
                List activeProfiles;
                MavenProject project = parentHierarchyEntry.getProject();
                Set<ArtifactKey> matches = this.intersect(project.getOriginalModel().getDependencies(), roots);
                if (!matches.isEmpty()) {
                    this.addResult(mavenProjectFacade, matches);
                }
                if ((activeProfiles = project.getActiveProfiles()) == null) continue;
                for (Profile profile : activeProfiles) {
                    matches = this.intersect(profile.getDependencies(), roots);
                    if (matches.isEmpty()) continue;
                    this.addResult(mavenProjectFacade, matches);
                    continue block4;
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    private void addResult(IMavenProjectFacade mP, Set<ArtifactKey> matches) {
        for (IMavenDependencySearch.IMavenDependencySearchListener listener : this.listeners) {
            listener.addResult(mP, matches);
        }
    }

    private DependencyNode locate(DependencyNode node, ArtifactKey artifact) {
        if (this.equals(node, artifact)) {
            return node;
        }
        for (DependencyNode child : node.getChildren()) {
            if (this.locate(child, artifact) == null) continue;
            return node;
        }
        return null;
    }

    private boolean equals(DependencyNode node, ArtifactKey b) {
        if (node == null || node.getDependency() == null) {
            return false;
        }
        Artifact a = node.getDependency().getArtifact();
        return a != null && a.getArtifactId() != null && a.getArtifactId().equals(b.getArtifactId()) && a.getGroupId() != null && a.getGroupId().equals(b.getGroupId()) && a.getVersion() != null && a.getVersion().equals(b.getVersion());
    }

    private boolean equals(Dependency a, ArtifactKey b) {
        return a != null && a.getArtifactId() != null && a.getArtifactId().equals(b.getArtifactId()) && a.getGroupId() != null && a.getGroupId().equals(b.getGroupId());
    }

    private Set<ArtifactKey> intersect(List<Dependency> dependencies, List<ArtifactKey> keys) {
        HashSet<ArtifactKey> requirement = new HashSet<ArtifactKey>();
        if (dependencies != null) {
            for (Dependency dependency : dependencies) {
                for (ArtifactKey key : keys) {
                    if (!this.equals(dependency, key)) continue;
                    requirement.add(key);
                }
            }
        }
        return requirement;
    }

    @Override
    public void addListener(IMavenDependencySearch.IMavenDependencySearchListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(IMavenDependencySearch.IMavenDependencySearchListener listener) {
        this.listeners.remove(listener);
    }
}

