/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.ui;

import com.sonatype.insight.ide.eclipse.Activator;
import com.sonatype.insight.ide.eclipse.Pref;
import com.sonatype.insight.ide.eclipse.internal.ui.Controller;
import com.sonatype.insight.ide.eclipse.internal.ui.ProjectRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;

public class ActiveProjectCache {
    private static final int BASE_UPDATE_DELAY = 200;
    private final Set<IProject> activeProjects = new HashSet<IProject>();
    private final ISelectionListener editorListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (part == ActiveProjectCache.this.controller.getPart() || !ActiveProjectCache.this.controller.getSite().getPage().isPartVisible(ActiveProjectCache.this.controller.getPart())) {
                return;
            }
            Set<IProject> prjs = ActiveProjectCache.this.projectsToAdapt(part, selection);
            if (prjs.size() == 0) {
                return;
            }
            new SelectionChangeJob(prjs).schedule();
        }
    };
    private final IPropertyChangeListener workingSetListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if ("workingSetAdd".equals(event.getProperty()) || "workingSetRemove".equals(event.getProperty()) || "workingSetContentChange".equals(event.getProperty()) || "workingSetUpdaterInstalled".equals(event.getProperty()) || "workingSetUpdaterUninstalled".equals(event.getProperty())) {
                ActiveProjectCache.this.job.schedule(200L);
            }
        }
    };
    private final Controller controller;
    private final IPropertyChangeListener filterPrefListener;
    private final Controller.Listener projectRegistryListener;
    private final ProjectRegistry projectRegistry;
    private final UpdateJob job = new UpdateJob();

    public ActiveProjectCache(Controller controller) {
        this.controller = controller;
        this.filterPrefListener = new FilterPreferenceListener();
        this.projectRegistryListener = new ProjectRegistryListener();
        this.projectRegistry = new ProjectRegistry(controller);
    }

    public void dispose() {
        this.controller.removeListener(this.projectRegistryListener);
        PlatformUI.getWorkbench().getWorkingSetManager().removePropertyChangeListener(this.workingSetListener);
        this.controller.getSite().getPage().removePostSelectionListener(this.editorListener);
        Activator.getDefault().getPreferenceStore().removePropertyChangeListener(this.filterPrefListener);
        this.projectRegistry.stop();
        this.job.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasIntersection(Collection<IProject> projects) {
        Set<IProject> set = this.activeProjects;
        synchronized (set) {
            IProject project;
            Iterator<IProject> iterator = projects.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!this.activeProjects.contains(project = iterator.next()));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IProject[] getActiveProjects() {
        Set<IProject> set = this.activeProjects;
        synchronized (set) {
            return this.activeProjects.toArray(new IProject[this.activeProjects.size()]);
        }
    }

    public int getAssignedProjectsSize() {
        return this.projectRegistry.getProjects().size();
    }

    public Set<String> getWorkspaceAppIds() {
        return this.projectRegistry.getAppIds();
    }

    public String getAppId(IProject project) {
        return this.projectRegistry.getAppId(project);
    }

    public void startCache() {
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.filterPrefListener);
        this.controller.addListener(this.projectRegistryListener);
        this.projectRegistry.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCache(String showProjects, String project, String workspace) {
        Set<IProject> newProjects = this.calculateActiveProjects(showProjects, project, workspace);
        Set<IProject> set = this.activeProjects;
        synchronized (set) {
            this.activeProjects.clear();
            this.activeProjects.addAll(newProjects);
        }
        this.controller.notifyActiveProjectsChanged(newProjects);
    }

    private void updateCache() {
        this.updateCache(Pref.getShowProjects(), Pref.getProjectSelection(), Pref.getWorkingSetSelection());
    }

    private Set<IProject> calculateActiveProjects(String showProjects, String project, String workspace) {
        PlatformUI.getWorkbench().getWorkingSetManager().removePropertyChangeListener(this.workingSetListener);
        this.controller.getSite().getPage().removePostSelectionListener(this.editorListener);
        HashSet<IProject> newProjects = new HashSet<IProject>();
        if ("all".equals(showProjects)) {
            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject prj = iProjectArray[n2];
                if (prj.isOpen()) {
                    newProjects.add(prj);
                }
                ++n2;
            }
        } else if ("project".equals(showProjects)) {
            IProject prj;
            String showSelectedProjectName = project;
            if (showSelectedProjectName != null && (prj = ResourcesPlugin.getWorkspace().getRoot().getProject(showSelectedProjectName)) != null && prj.isOpen()) {
                newProjects.add(prj);
            }
        } else if ("workset".equals(showProjects)) {
            String showSelectedWorkingSet = workspace;
            IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
            if (showSelectedWorkingSet != null) {
                IWorkingSet ws = manager.getWorkingSet(showSelectedWorkingSet);
                if (ws != null) {
                    IAdaptable[] iAdaptableArray = ws.getElements();
                    int n = iAdaptableArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IAdaptable adapt = iAdaptableArray[n3];
                        IProject prj = (IProject)adapt.getAdapter(IProject.class);
                        if (prj != null && prj.exists() && prj.isOpen()) {
                            newProjects.add(prj);
                        }
                        ++n3;
                    }
                }
                manager.addPropertyChangeListener(this.workingSetListener);
            }
        } else if ("currentWorkset".equals(showProjects)) {
            IWorkbenchPart part = this.controller.getSite().getPage().getActivePart();
            if (part == this.controller.getPart()) {
                part = this.controller.getSite().getPage().getActiveEditor();
            }
            HashSet<IProject> currents = new HashSet<IProject>();
            final ISelection[] sel = new ISelection[1];
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    sel[0] = ActiveProjectCache.this.controller.getSite().getPage().getSelection();
                }
            });
            currents.addAll(this.projectsToAdapt(part, sel[0]));
            IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
            if (!currents.isEmpty()) {
                HashSet<IProject> missingProjects = new HashSet<IProject>(this.projectRegistry.getProjects());
                IWorkingSet[] iWorkingSetArray = manager.getWorkingSets();
                int n = iWorkingSetArray.length;
                int n4 = 0;
                while (n4 < n) {
                    IWorkingSet ws = iWorkingSetArray[n4];
                    ArrayList<IProject> temp = new ArrayList<IProject>();
                    boolean found = false;
                    IAdaptable[] iAdaptableArray = ws.getElements();
                    int n5 = iAdaptableArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IAdaptable adapt = iAdaptableArray[n6];
                        IProject prj = (IProject)adapt.getAdapter(IProject.class);
                        if (prj != null && prj.exists() && prj.isOpen()) {
                            temp.add(prj);
                            if (!found) {
                                if (currents.contains(prj)) {
                                    found = true;
                                } else if (newProjects.isEmpty()) {
                                    missingProjects.remove(prj);
                                }
                            }
                        }
                        ++n6;
                    }
                    if (found) {
                        newProjects.addAll(temp);
                    }
                    ++n4;
                }
                if (newProjects.isEmpty()) {
                    newProjects.addAll(missingProjects);
                }
            }
            this.controller.getSite().getPage().addPostSelectionListener(this.editorListener);
            manager.addPropertyChangeListener(this.workingSetListener);
        } else if ("currentProject".equals(showProjects)) {
            IWorkbenchPart part = this.controller.getSite().getPage().getActivePart();
            if (part == this.controller.getPart()) {
                part = this.controller.getSite().getPage().getActiveEditor();
            }
            final ISelection[] sel = new ISelection[1];
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    sel[0] = ActiveProjectCache.this.controller.getSite().getPage().getSelection();
                }
            });
            newProjects.addAll(this.projectsToAdapt(part, sel[0]));
            this.controller.getSite().getPage().addPostSelectionListener(this.editorListener);
        }
        newProjects.retainAll(this.projectRegistry.getProjects());
        return newProjects;
    }

    private Set<IProject> projectsToAdapt(IWorkbenchPart part, ISelection selection) {
        ArrayList<Object> objectsToAdapt = new ArrayList<Object>();
        if (part instanceof IEditorPart) {
            IEditorPart editor = (IEditorPart)part;
            objectsToAdapt.add(editor.getEditorInput());
        } else if (selection instanceof IStructuredSelection) {
            for (Object e : (IStructuredSelection)selection) {
                objectsToAdapt.add(e);
            }
        }
        HashSet<IProject> toRet = new HashSet<IProject>();
        for (Object e : objectsToAdapt) {
            if (!(e instanceof IAdaptable)) continue;
            IResource resource = (IResource)((IAdaptable)e).getAdapter(IResource.class);
            if (resource == null) {
                resource = (IResource)((IAdaptable)e).getAdapter(IFile.class);
            }
            if (resource == null || resource.getProject() == null) continue;
            toRet.add(resource.getProject());
        }
        return toRet;
    }

    private class FilterPreferenceListener
    implements IPropertyChangeListener {
        private final Set<String> filterProps = new HashSet<String>(Arrays.asList("showProjects", "selectedProject", "selectedWorkset"));

        private FilterPreferenceListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (this.filterProps.contains(event.getProperty())) {
                Object oldValue = event.getOldValue();
                Object newValue = event.getNewValue();
                if (newValue != null && !newValue.equals(oldValue) || oldValue != null && !oldValue.equals(newValue)) {
                    ActiveProjectCache.this.job.schedule(200L);
                }
            }
        }
    }

    private class ProjectRegistryListener
    implements Controller.Listener {
        private ProjectRegistryListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void elementChanged(Controller.ListenerEvent event) {
            if (event.type == Controller.Type.PROJECTS_ADDED) {
                ActiveProjectCache.this.job.schedule(200L);
            } else if (event.type == Controller.Type.PROJECTS_REMOVED) {
                Set<IProject> set = ActiveProjectCache.this.activeProjects;
                synchronized (set) {
                    if (ActiveProjectCache.this.activeProjects.removeAll(event.getElements(IProject.class))) {
                        ActiveProjectCache.this.controller.notifyActiveProjectsChanged(new HashSet<IProject>(ActiveProjectCache.this.activeProjects));
                    }
                }
            }
        }
    }

    private class SelectionChangeJob
    extends Job {
        private Collection<IProject> projects;

        public SelectionChangeJob(Collection<IProject> projects) {
            super("");
            this.setSystem(true);
            this.projects = projects;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            Set<IProject> set = ActiveProjectCache.this.activeProjects;
            synchronized (set) {
                HashSet<IProject> currents = new HashSet<IProject>(ActiveProjectCache.this.activeProjects);
                if (currents.size() == this.projects.size()) {
                    currents.removeAll(this.projects);
                    this.projects.removeAll(ActiveProjectCache.this.activeProjects);
                    if (currents.size() != 0 || this.projects.size() != 0) {
                        ActiveProjectCache.this.job.schedule(200L);
                    }
                } else {
                    ActiveProjectCache.this.job.schedule(200L);
                }
            }
            return Status.OK_STATUS;
        }
    }

    private class UpdateJob
    extends Job {
        public UpdateJob() {
            super("");
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            ActiveProjectCache.this.updateCache();
            return Status.OK_STATUS;
        }
    }
}

