/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.ui;

import com.sonatype.insight.ide.eclipse.Images;
import com.sonatype.insight.ide.eclipse.internal.Messages;
import com.sonatype.insight.ide.eclipse.internal.ui.Controller;
import com.sonatype.insight.ide.eclipse.internal.ui.DelegatingStyledCellLabelProviderWithTooltips;
import com.sonatype.insight.ide.eclipse.internal.ui.DependencyLabelProvider;
import com.sonatype.insight.ide.eclipse.internal.ui.Filter;
import com.sonatype.insight.ide.eclipse.internal.ui.elements.JavaDependencyElement;
import com.sonatype.insight.ide.eclipse.internal.ui.elements.UIDependencyElement;
import com.sonatype.insight.ide.eclipse.internal.update.ui.ComponentTooltipSupport;
import com.sonatype.insight.ide.eclipse.internal.update.ui.PolicyThreatLabelProvider;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;

public class ArtifactTableViewer
extends TableViewer {
    private static final int COMPONENT_COLUMN = 0;
    private static final int POLICY_COLUMN = 1;
    private static final int ICON_WIDTH = 25;
    private TableViewerColumn columnComponent;
    private final ComponentTableComparator comparator = new ComponentTableComparator();
    private final Controller controller;
    private final Table table;
    private final Job refreshJob;

    public ArtifactTableViewer(Composite parent, Controller controller) {
        super(parent, 65540);
        this.controller = controller;
        this.table = this.getTable();
        this.refreshJob = new Job(""){

            protected IStatus run(IProgressMonitor monitor) {
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).ArtifactTableViewer.this.table.isDisposed()) {
                            return;
                        }
                        ArtifactTableViewer.this.refresh();
                    }
                });
                return Status.OK_STATUS;
            }
        };
        this.refreshJob.setSystem(true);
        this.init();
        this.setFilters(new ViewerFilter[]{new Filter(controller.getCache())});
        this.setContentProvider((IContentProvider)controller.getProvider());
    }

    public UIDependencyElement getCurrentlySelectedUIDependencyElement() {
        IStructuredSelection sel;
        if (this.getSelection() instanceof IStructuredSelection && (sel = (IStructuredSelection)this.getSelection()).getFirstElement() != null && sel.getFirstElement() instanceof UIDependencyElement) {
            return (UIDependencyElement)sel.getFirstElement();
        }
        return null;
    }

    public void setSelectVersion(UIDependencyElement element) {
        StructuredSelection structuredSelection = new StructuredSelection((Object)element);
        this.setSelection((ISelection)structuredSelection, true);
    }

    private void init() {
        this.table.setLinesVisible(false);
        this.table.setHeaderVisible(true);
        ComponentTooltipSupport.enableFor((ColumnViewer)this);
        this.comparator.setSort(1, true);
        this.setComparator(this.comparator);
        this.columnComponent = new TableViewerColumn((TableViewer)this, 0);
        this.columnComponent.setLabelProvider((CellLabelProvider)new DelegatingStyledCellLabelProviderWithTooltips(new DependencyLabelProvider()){

            @Override
            public String getToolTipText(Object element) {
                if (element instanceof JavaDependencyElement) {
                    return "";
                }
                return null;
            }
        });
        TableColumn tcComponent = this.columnComponent.getColumn();
        tcComponent.setAlignment(16384);
        tcComponent.setText(Messages.ArtifactTableViewer_Component_Title);
        tcComponent.addSelectionListener((SelectionListener)new ColumnSelectionAdapter(0));
        this.createIconColumn(new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new PolicyThreatLabelProvider()), Messages.ArtifactTableViewer_Policy_Threat_Tooltip, Images.getImage("policy-violations.png"), 1);
        this.table.addControlListener((ControlListener)new ControlAdapter(){
            Timer resizeTimer = new Timer();
            final int DELAY_MS = 50;

            public void controlResized(ControlEvent e) {
                this.resizeTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        Display.getDefault().asyncExec(() -> ArtifactTableViewer.this.resizeFirstColumn());
                    }
                }, 50L);
            }
        });
        this.table.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                if (!ArtifactTableViewer.this.table.isDisposed() && ArtifactTableViewer.this.table.getItemCount() > 0) {
                    ArtifactTableViewer.this.resizeFirstColumn();
                }
            }
        });
        this.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent arg0) {
                ArtifactTableViewer.this.controller.notifySelected(ArtifactTableViewer.this.getCurrentlySelectedUIDependencyElement());
            }
        });
        this.controller.addListener(new Controller.Listener(){

            @Override
            public void elementChanged(Controller.ListenerEvent event) {
                switch (event.type) {
                    case ADDED: 
                    case REMOVED: 
                    case UPDATED: {
                        ArtifactTableViewer.this.refreshJob.schedule(500L);
                        break;
                    }
                    case NEW_PROVIDER: {
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (ArtifactTableViewer.this.getControl().isDisposed()) {
                                    return;
                                }
                                ArtifactTableViewer.this.setContentProvider((IContentProvider)(this).ArtifactTableViewer.this.controller.getProvider());
                            }
                        });
                        break;
                    }
                }
            }
        });
    }

    private TableViewerColumn createIconColumn(DelegatingStyledCellLabelProvider provider, String tooltip, Image image, int columnIndex) {
        TableViewerColumn column = new TableViewerColumn((TableViewer)this, 0x1000000, columnIndex);
        column.setLabelProvider((CellLabelProvider)provider);
        TableColumn tcIcons = column.getColumn();
        tcIcons.setResizable(false);
        tcIcons.setAlignment(0x1000000);
        tcIcons.setWidth(25);
        tcIcons.setToolTipText(tooltip);
        tcIcons.addSelectionListener((SelectionListener)new ColumnSelectionAdapter(columnIndex));
        tcIcons.setImage(image);
        return column;
    }

    private void resizeFirstColumn() {
        Point size = this.table.getSize();
        int sub = this.table.getVerticalBar().getSize().x;
        int newWidth = Math.max(200, size.x - 26 - sub);
        if (this.columnComponent.getColumn().getWidth() != newWidth) {
            this.columnComponent.getColumn().setWidth(newWidth);
        }
    }

    private class ColumnSelectionAdapter
    extends SelectionAdapter {
        private final int index;

        ColumnSelectionAdapter(int index) {
            this.index = index;
        }

        public void widgetSelected(SelectionEvent e) {
            ArtifactTableViewer.this.comparator.setSort(this.index, ArtifactTableViewer.this.comparator.getColumn() == this.index ? !ArtifactTableViewer.this.comparator.isAscending() : true);
            ArtifactTableViewer.this.refresh(false);
        }
    }

    public static class ComponentTableComparator
    extends ViewerComparator {
        private int column = 0;
        private boolean ascending = true;

        public void setSort(int column, boolean ascending) {
            this.column = column;
            this.ascending = ascending;
        }

        public int getColumn() {
            return this.column;
        }

        public boolean isAscending() {
            return this.ascending;
        }

        public boolean isSorterProperty(Object element, String property) {
            return true;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof UIDependencyElement && e2 instanceof UIDependencyElement) {
                return (this.ascending ? 1 : -1) * this.doCompare((UIDependencyElement)e1, (UIDependencyElement)e2);
            }
            return super.compare(viewer, e1, e2);
        }

        private int doCompare(UIDependencyElement e1, UIDependencyElement e2) {
            int rel = 0;
            if (this.column == 1 && (rel = this.compareLoaded(e1, e2)) == 0 && (rel = this.comparePolicyThreat(e1, e2)) == 0) {
                rel = this.comparePolicyThreat(e1, e2);
            }
            if (rel == 0) {
                rel = this.compareName(e1, e2);
            }
            return rel;
        }

        private int compareName(UIDependencyElement e1, UIDependencyElement e2) {
            int name = e1.getName().compareToIgnoreCase(e2.getName());
            if (name == 0) {
                if (e1.getCurrentVersion() != null) {
                    return e1.getCurrentVersion().compareTo(e2.getCurrentVersion());
                }
                if (e2.getCurrentVersion() != null) {
                    return -e2.getCurrentVersion().compareTo(e1.getCurrentVersion());
                }
            }
            return name;
        }

        private int compareLoaded(UIDependencyElement e1, UIDependencyElement e2) {
            int loaded1 = e1.isLoaded() ? 1 : 0;
            int loaded2 = e2.isLoaded() ? 1 : 0;
            return loaded2 - loaded1;
        }

        private int comparePolicyThreat(UIDependencyElement e1, UIDependencyElement e2) {
            Integer e1Threat = e1.getPolicyThreatLevel();
            Integer e2Threat = e2.getPolicyThreatLevel();
            if (e1Threat == null) {
                return e2Threat == null ? 0 : 1;
            }
            return e2Threat == null ? -1 : e2Threat - e1Threat;
        }
    }
}

