/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.ui;

import java.awt.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

public class ColorUtils {
    public static org.eclipse.swt.graphics.Color decode(Display display, String hexString) {
        try {
            Color c = Color.decode(hexString);
            return new org.eclipse.swt.graphics.Color((Device)display, c.getRed(), c.getGreen(), c.getBlue());
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static boolean isDark(org.eclipse.swt.graphics.Color color) {
        return (ColorUtils.getLuminance(color) + 0.05) / 0.05 < 4.5;
    }

    private static double getLuminance(org.eclipse.swt.graphics.Color color) {
        return ColorUtils.getLinearRGBComponentValue((double)color.getRed() / 255.0) * 0.2126 + ColorUtils.getLinearRGBComponentValue((double)color.getGreen() / 255.0) * 0.7152 + ColorUtils.getLinearRGBComponentValue((double)color.getBlue() / 255.0) * 0.0722;
    }

    private static double getLinearRGBComponentValue(double colorValue) {
        if (colorValue <= 0.03928) {
            return colorValue / 12.92;
        }
        return Math.pow((colorValue + 0.055) / 1.055, 2.4);
    }
}

