/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.ui;

import com.sonatype.insight.ide.eclipse.Activator;
import com.sonatype.insight.ide.eclipse.internal.ui.ActiveProjectCache;
import com.sonatype.insight.ide.eclipse.internal.ui.ColorUtils;
import com.sonatype.insight.ide.eclipse.internal.ui.DependencyContentProvider;
import com.sonatype.insight.ide.eclipse.internal.ui.WorkerThreadFactory;
import com.sonatype.insight.ide.eclipse.internal.ui.elements.UIDependencyElement;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.net.proxy.IProxyChangeEvent;
import org.eclipse.core.net.proxy.IProxyChangeListener;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.statushandlers.StatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Controller {
    private static final Logger LOG = LoggerFactory.getLogger(Controller.class);
    private static final ThreadPoolExecutor executor;
    private final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();
    private final Provider source;
    private DependencyContentProvider provider;
    private final ActiveProjectCache cache;
    private final IProxyChangeListener proxyListener;
    private boolean darkThemeInUse;

    static {
        ThreadPoolExecutor exec = new ThreadPoolExecutor(1, 1, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new WorkerThreadFactory("Insight-Notifier-"));
        exec.allowCoreThreadTimeOut(true);
        executor = exec;
    }

    Controller(Provider source) {
        this.source = source;
        this.provider = new DependencyContentProvider(this);
        this.cache = new ActiveProjectCache(this);
        IProxyService proxyService = Activator.getProxyService();
        if (proxyService != null && proxyService.isProxiesEnabled()) {
            this.proxyListener = new IProxyChangeListener(){

                public void proxyInfoChanged(IProxyChangeEvent event) {
                    if (Controller.this.provider.hasServerError()) {
                        Controller.this.resetProvider();
                    }
                }
            };
            proxyService.addProxyChangeListener(this.proxyListener);
        } else {
            LOG.warn("Proxy Service not available, network connections cannot be proxied!");
            this.proxyListener = null;
        }
    }

    public IWorkbenchSite getSite() {
        return this.source.getSite();
    }

    public IWorkbenchPart getPart() {
        return this.source.getPart();
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public boolean isDarkThemeInUse() {
        return this.darkThemeInUse;
    }

    public void setDarkThemeInUse(Color backgroundColor) {
        this.darkThemeInUse = ColorUtils.isDark(backgroundColor);
        Activator.getDefault().getLog().log((IStatus)new Status(1, "com.sonatype.clm.ide.eclipse", "darkThemeInUse - backgroundColor: " + String.valueOf(backgroundColor) + " - is dark: " + this.darkThemeInUse));
    }

    public UIDependencyElement getCurrentDependencyElement() {
        return this.source.getCurrentDependencyElement();
    }

    public void notifyElementAdded(Collection<UIDependencyElement> elements) {
        this.notify(new ListenerEvent(Type.ADDED, elements));
    }

    public void notifyElementRemoved(Collection<UIDependencyElement> elements) {
        this.notify(new ListenerEvent(Type.REMOVED, elements));
    }

    public void notifyElementUpdated(Collection<UIDependencyElement> elements) {
        this.notify(new ListenerEvent(Type.UPDATED, elements));
    }

    public void notifySelected(UIDependencyElement element) {
        this.notify(new ListenerEvent(Type.SELECTED, Collections.singletonList(element)));
    }

    public void notifyProjectsAdded(Collection<IProject> projects) {
        this.notify(new ListenerEvent(Type.PROJECTS_ADDED, projects));
    }

    public void notifyProjectsRemoved(Collection<IProject> projects) {
        this.notify(new ListenerEvent(Type.PROJECTS_REMOVED, projects));
    }

    public void notifyActiveProjectsChanged(Collection<IProject> projects) {
        this.notify(new ListenerEvent(Type.ACTIVE_PROJECTS_CHANGED, projects));
    }

    public void notifyServerChanged(String serverName) {
        this.notify(new ListenerEvent(Type.SERVER_CHANGED, Collections.singleton(serverName)));
    }

    public void notifyInvalidApplicationId(String applicationId) {
        this.notify(new ListenerEvent(Type.INVALID_APPLICATION_ID, Collections.singleton(applicationId)));
    }

    public void notifyServerFailed(int status, String message) {
        this.notify(new ListenerEvent(Type.SERVER_FAILED, status, message));
    }

    public DependencyContentProvider getProvider() {
        return this.provider;
    }

    public ActiveProjectCache getCache() {
        return this.cache;
    }

    public void resetProvider() {
        this.provider = new DependencyContentProvider(this);
        this.notify(new ListenerEvent(Type.NEW_PROVIDER, Collections.EMPTY_LIST));
    }

    private void notify(ListenerEvent event) {
        executor.submit(new NotifyRunnable(event));
    }

    boolean testHasActiveJobs() {
        return executor.getActiveCount() > 0;
    }

    public void dispose() {
        this.cache.dispose();
        if (this.proxyListener != null) {
            Activator.getProxyService().removeProxyChangeListener(this.proxyListener);
        }
    }

    public static interface Listener {
        public void elementChanged(ListenerEvent var1);
    }

    public static class ListenerEvent {
        final Type type;
        final Collection elements;
        final int status;
        final String message;

        public ListenerEvent(Type type, Collection elements) {
            this.type = type;
            this.elements = elements;
            this.status = 0;
            this.message = null;
        }

        public ListenerEvent(Type type, int status, String message) {
            this.type = type;
            this.elements = Collections.EMPTY_LIST;
            this.status = status;
            this.message = message;
        }

        public <T> Collection<T> getElements(Class<T> clazz) {
            return this.elements;
        }

        public Type getType() {
            return this.type;
        }

        public int getStatus() {
            return this.status;
        }

        public String getMessage() {
            return this.message;
        }

        public String toString() {
            return String.valueOf((Object)this.type) + ", " + String.valueOf(this.elements);
        }
    }

    private class NotifyRunnable
    implements Runnable {
        private final ListenerEvent event;

        NotifyRunnable(ListenerEvent event) {
            this.event = event;
        }

        @Override
        public void run() {
            for (Listener listener : Controller.this.listeners) {
                try {
                    listener.elementChanged(this.event);
                }
                catch (Exception e) {
                    StatusManager.getManager().handle((IStatus)new Status(4, "com.sonatype.clm.ide.eclipse", String.valueOf(listener) + " failed to handle event " + String.valueOf(this.event), (Throwable)e));
                }
            }
        }
    }

    public static interface Provider {
        public UIDependencyElement getCurrentDependencyElement();

        public IWorkbenchSite getSite();

        public IWorkbenchPart getPart();
    }

    public static enum Type {
        ADDED,
        REMOVED,
        SELECTED,
        UPDATED,
        PROJECTS_REMOVED,
        PROJECTS_ADDED,
        ACTIVE_PROJECTS_CHANGED,
        NEW_PROVIDER,
        SERVER_CHANGED,
        INVALID_APPLICATION_ID,
        SERVER_FAILED;

    }
}

