/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.ui;

import com.sonatype.insight.ide.eclipse.Activator;
import com.sonatype.insight.ide.eclipse.Images;
import com.sonatype.insight.ide.eclipse.internal.ArtifactKey;
import com.sonatype.insight.ide.eclipse.internal.Messages;
import com.sonatype.insight.ide.eclipse.internal.helpers.MavenHelper;
import com.sonatype.insight.ide.eclipse.internal.rest.InsightClientManager;
import com.sonatype.insight.ide.eclipse.internal.rest.UserInteraction;
import com.sonatype.insight.ide.eclipse.internal.search.DependencySearchQuery;
import com.sonatype.insight.ide.eclipse.internal.ui.ArtifactTableViewer;
import com.sonatype.insight.ide.eclipse.internal.ui.Controller;
import com.sonatype.insight.ide.eclipse.internal.ui.DependencyContentProvider;
import com.sonatype.insight.ide.eclipse.internal.ui.FiltersDialog;
import com.sonatype.insight.ide.eclipse.internal.ui.ProjectAssociationDialog;
import com.sonatype.insight.ide.eclipse.internal.ui.component.ComponentInformationController;
import com.sonatype.insight.ide.eclipse.internal.ui.component.SWTComponentInformationComposite;
import com.sonatype.insight.ide.eclipse.internal.ui.elements.UIDependencyElement;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;
import org.eclipse.m2e.core.ui.internal.MavenImages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.operations.RedoActionHandler;
import org.eclipse.ui.operations.UndoActionHandler;
import org.eclipse.ui.part.ViewPart;

public class DependenciesView
extends ViewPart {
    private static final int SASH_SPLITTER_WIDTH = 12;
    private OpenArtifactViewAction openArtifactView;
    private OpenPomAction openPom;
    private Action locate;
    private Composite compSelected;
    private final Controller controller = new Controller(new Controller.Provider(){

        @Override
        public UIDependencyElement getCurrentDependencyElement() {
            return DependenciesView.this.artifactTable.getCurrentlySelectedUIDependencyElement();
        }

        @Override
        public IWorkbenchSite getSite() {
            return DependenciesView.this.getSite();
        }

        @Override
        public IWorkbenchPart getPart() {
            return DependenciesView.this;
        }
    });
    private Composite compLeft;
    private SashForm divSashForm;
    private IMemento fMemento;
    private Action actionFilter;
    private Link lblStatus;
    private UndoActionHandler undoAction;
    private RedoActionHandler redoAction;
    private ObjectUndoContext undoContext;
    private Action helpAction;
    private Action actionConfig;
    private Action actionRefresh;
    private SWTComponentInformationComposite componentInformationPanel;
    private ComponentInformationController componentInformationController;
    private ArtifactTableViewer artifactTable;
    private final Job statusLabelUpdateJob = new Job(""){

        protected IStatus run(IProgressMonitor monitor) {
            DependenciesView.this.updateStatusLabel();
            return Status.OK_STATUS;
        }
    };

    public DependenciesView() {
        this.statusLabelUpdateJob.setSystem(true);
    }

    public void createPartControl(Composite parent) {
        GridLayout gl_parent = new GridLayout(1, false);
        gl_parent.verticalSpacing = 0;
        gl_parent.marginWidth = 0;
        gl_parent.marginHeight = 0;
        gl_parent.horizontalSpacing = 0;
        parent.setLayout((Layout)gl_parent);
        parent.setBackground(parent.getDisplay().getSystemColor(25));
        this.lblStatus = new Link(parent, 0);
        this.lblStatus.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.lblStatus.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DependenciesView.this.actionConfig.run();
            }
        });
        this.divSashForm = new SashForm(parent, 0);
        this.divSashForm.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.divSashForm.setSashWidth(12);
        this.addResizeListener();
        this.compLeft = new Composite((Composite)this.divSashForm, 0);
        GridLayout gl_compLeft = new GridLayout(1, false);
        gl_compLeft.horizontalSpacing = 0;
        gl_compLeft.marginHeight = 0;
        gl_compLeft.marginWidth = 0;
        gl_compLeft.verticalSpacing = 0;
        this.compLeft.setLayout((Layout)gl_compLeft);
        this.artifactTable = new ArtifactTableViewer(this.compLeft, this.controller);
        this.artifactTable.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Color color = this.compLeft.getBackground();
        this.controller.setDarkThemeInUse(color);
        this.compSelected = new Composite((Composite)this.divSashForm, 0);
        GridLayout gl_compSelected = new GridLayout(2, false);
        gl_compSelected.marginWidth = 0;
        gl_compSelected.marginHeight = 0;
        this.compSelected.setLayout((Layout)gl_compSelected);
        this.componentInformationPanel = new SWTComponentInformationComposite(this.compSelected, 0);
        GridData gd_avtable = new GridData(4, 4, true, true, 2, 1);
        gd_avtable.minimumWidth = 200;
        this.componentInformationPanel.setLayoutData(gd_avtable);
        this.componentInformationController = new ComponentInformationController(this.controller, this.componentInformationPanel);
        this.componentInformationPanel.registerListeners(this.componentInformationController);
        this.controller.addListener(this.componentInformationController);
        this.controller.addListener(new Controller.Listener(){

            @Override
            public void elementChanged(Controller.ListenerEvent event) {
                block5: {
                    Collection<String> invalidAppIds;
                    block10: {
                        Collection<String> invalidAppIds2;
                        block9: {
                            block8: {
                                block7: {
                                    block6: {
                                        block4: {
                                            if (DependenciesView.this.artifactTable.getControl().isDisposed()) {
                                                return;
                                            }
                                            if (event.type != Controller.Type.UPDATED && event.type != Controller.Type.ADDED && event.type != Controller.Type.REMOVED) break block4;
                                            DependenciesView.this.statusLabelUpdateJob.schedule(500L);
                                            break block5;
                                        }
                                        if (event.type != Controller.Type.SELECTED) break block6;
                                        DependenciesView.this.updateToolbarButtons(event.getElements(UIDependencyElement.class).iterator().next());
                                        break block5;
                                    }
                                    if (event.type != Controller.Type.ACTIVE_PROJECTS_CHANGED) break block7;
                                    DependenciesView.this.updateInput();
                                    break block5;
                                }
                                if (event.type != Controller.Type.INVALID_APPLICATION_ID && (event.type != Controller.Type.SERVER_FAILED || event.status == 503)) break block8;
                                DependenciesView.this.setConfigIcon(Images.DESC_CONFIG_ERR);
                                break block5;
                            }
                            if (event.type != Controller.Type.SERVER_CHANGED && event.type != Controller.Type.NEW_PROVIDER) break block9;
                            DependenciesView.this.setConfigIcon(Images.getImageDescriptor("configure.gif"));
                            break block5;
                        }
                        if (event.type != Controller.Type.PROJECTS_REMOVED) break block10;
                        if (DependenciesView.this.controller.getProvider().hasServerError() || (invalidAppIds2 = DependenciesView.this.controller.getProvider().getInvalidApplicationIds()).isEmpty()) break block5;
                        Set<String> appIds = DependenciesView.this.controller.getCache().getWorkspaceAppIds();
                        invalidAppIds2.retainAll(appIds);
                        if (invalidAppIds2.isEmpty()) {
                            DependenciesView.this.setConfigIcon(Images.getImageDescriptor("configure.gif"));
                        }
                        break block5;
                    }
                    if (event.type == Controller.Type.PROJECTS_ADDED && !(invalidAppIds = DependenciesView.this.controller.getProvider().getInvalidApplicationIds()).isEmpty() && !DependenciesView.this.actionConfig.getImageDescriptor().equals(Images.DESC_CONFIG_ERR)) {
                        Collection<IProject> projects = event.getElements(IProject.class);
                        for (IProject project : projects) {
                            String appId = DependenciesView.this.controller.getCache().getAppId(project);
                            if (appId == null || !invalidAppIds.contains(appId)) continue;
                            DependenciesView.this.setConfigIcon(Images.DESC_CONFIG_ERR);
                            break;
                        }
                    }
                }
            }
        });
        this.divSashForm.setWeights(new int[]{this.getInteger("divSashFormWeight0", 1), this.getInteger("divSashFormWeight1", 2)});
        this.createToolbar();
        this.createMenu();
        this.updateInput();
        this.undoContext = new ObjectUndoContext((Object)this);
        this.undoContext.addMatch(RefactoringCorePlugin.getUndoContext());
        this.undoAction = new UndoActionHandler(this.getSite(), (IUndoContext)this.undoContext);
        this.redoAction = new RedoActionHandler(this.getSite(), (IUndoContext)this.undoContext);
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
    }

    private void updateStatusLabel() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (DependenciesView.this.artifactTable.getControl().isDisposed()) {
                    return;
                }
                IProject[] allProjects = DependenciesView.this.controller.getCache().getActiveProjects();
                int shown = DependenciesView.this.artifactTable.getTable().getItemCount();
                int rawCount = DependenciesView.this.controller.getProvider().getRawInputCount();
                int all = Math.max(shown, rawCount);
                int filtered = all - shown;
                if (allProjects.length == 1) {
                    DependenciesView.this.lblStatus.setText(NLS.bind((String)Messages.DependenciesView_summary2, (Object[])new Object[]{allProjects[0].getName(), all, shown, filtered}));
                } else if (rawCount > 0 && shown == 0) {
                    DependenciesView.this.lblStatus.setText(Messages.DependenciesView_allComponentsFiltered);
                } else if (DependenciesView.this.controller.getCache().getAssignedProjectsSize() == 0) {
                    DependenciesView.this.lblStatus.setText(Messages.DependenciesView_noProjectsAssigned);
                } else {
                    DependenciesView.this.lblStatus.setText(NLS.bind((String)Messages.DependenciesView_summary, (Object[])new Object[]{allProjects.length, all, shown, filtered}));
                }
            }
        });
    }

    private void createToolbar() {
        this.actionFilter = new Action(Messages.DependenciesView_actionFilter){

            public void run() {
                FiltersDialog dialog = new FiltersDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell());
                dialog.open();
            }
        };
        this.actionFilter.setImageDescriptor(Images.DESC_FILTER);
        this.openPom = new OpenPomAction();
        this.openPom.setEnabled(false);
        this.locate = new Action(Messages.DependenciesView_actionLocate){

            public void runWithEvent(Event event) {
                UIDependencyElement uiDependencyElement = DependenciesView.this.controller.getCurrentDependencyElement();
                if (uiDependencyElement != null) {
                    InsightClientManager.getInstance().getUserInteractionCountMap().get((Object)UserInteraction.NAVIGATION_PERFORMED).incrementAndGet();
                    NewSearchUI.runQueryInBackground((ISearchQuery)new DependencySearchQuery(uiDependencyElement));
                }
            }
        };
        this.locate.setImageDescriptor(Images.getImageDescriptor("obj16/search.gif"));
        this.locate.setEnabled(false);
        this.openArtifactView = new OpenArtifactViewAction();
        this.openArtifactView.setEnabled(false);
        this.helpAction = new Action(Messages.DependenciesView_helpAction, Images.getImageDescriptor("help.gif")){

            public void runWithEvent(Event event) {
                String url = "https://links.sonatype.com/products/clm/eclipse/home";
                Activator.openUrl(url, true);
            }
        };
        this.actionConfig = new Action(Messages.DependenciesView_actionConfigure, Images.getImageDescriptor("configure.gif")){

            public void run() {
                new ProjectAssociationDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), DependenciesView.this.controller).open();
            }
        };
        this.actionRefresh = new Action(Messages.DependenciesView_actionRefresh, Images.getImageDescriptor("refresh.gif")){

            public void run() {
                DependenciesView.this.controller.resetProvider();
            }
        };
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add((IAction)this.openArtifactView);
        toolBarManager.add((IAction)this.openPom);
        toolBarManager.add((IAction)this.locate);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.actionFilter);
        toolBarManager.add((IAction)this.actionConfig);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.actionRefresh);
        toolBarManager.add((IAction)this.helpAction);
    }

    private void setConfigIcon(final ImageDescriptor desc) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                DependenciesView.this.actionConfig.setImageDescriptor(desc);
                DependenciesView.this.getViewSite().getActionBars().updateActionBars();
            }
        });
    }

    private void createMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                DependenciesView.this.openPom.updateEnableState();
            }
        });
        Menu fContextMenu = menuMgr.createContextMenu((Control)this.artifactTable.getTable());
        this.artifactTable.getControl().setMenu(fContextMenu);
        menuMgr.add((IAction)this.openArtifactView);
        menuMgr.add((IAction)this.openPom);
        menuMgr.add((IAction)this.locate);
    }

    private void updateToolbarButtons(final UIDependencyElement el) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                DependenciesView.this.openPom.updateEnableState();
                DependenciesView.this.locate.setEnabled(el != null);
                DependenciesView.this.openArtifactView.updateEnableState();
            }
        });
    }

    public void setFocus() {
        this.artifactTable.getControl().setFocus();
    }

    private void updateInput() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                DependenciesView.this.artifactTable.setInput(DependenciesView.this.controller.getProvider());
                if (DependenciesView.this.artifactTable.getSelection().isEmpty()) {
                    return;
                }
                Object element = ((IStructuredSelection)DependenciesView.this.artifactTable.getSelection()).getFirstElement();
                if (element instanceof UIDependencyElement) {
                    DependenciesView.this.artifactTable.setSelectVersion((UIDependencyElement)element);
                }
            }
        });
        this.updateStatusLabel();
    }

    private void addResizeListener() {
        this.divSashForm.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Point size = DependenciesView.this.divSashForm.getParent().getSize();
                if (size.y > size.x && DependenciesView.this.divSashForm.getOrientation() == 256) {
                    DependenciesView.this.divSashForm.setOrientation(512);
                    DependenciesView.this.divSashForm.layout();
                } else if (size.x > size.y && DependenciesView.this.divSashForm.getOrientation() == 512) {
                    DependenciesView.this.divSashForm.setOrientation(256);
                    DependenciesView.this.divSashForm.layout();
                }
            }
        });
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        if (this.artifactTable != null) {
            memento.putInteger("divSashFormWeight0", this.divSashForm.getWeights()[0]);
            memento.putInteger("divSashFormWeight1", this.divSashForm.getWeights()[1]);
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site);
        this.fMemento = memento;
    }

    public boolean testAreJobsActive() {
        return !this.artifactTable.getControl().isDisposed() && (((DependencyContentProvider)this.artifactTable.getContentProvider()).testHasActiveJobs() || this.controller.testHasActiveJobs());
    }

    private int getInteger(String name, int defaultValue) {
        return this.fMemento == null || this.fMemento.getInteger(name) == null ? defaultValue : this.fMemento.getInteger(name);
    }

    public void dispose() {
        super.dispose();
        this.controller.dispose();
    }

    private class OpenArtifactViewAction
    extends Action {
        public OpenArtifactViewAction() {
            super(Messages.DependenciesView_actionOpenDetailView);
            this.setImageDescriptor(Images.getImageDescriptor("sonatype_16x16.png"));
        }

        public void runWithEvent(Event event) {
            UIDependencyElement uiDependencyElement = DependenciesView.this.controller.getCurrentDependencyElement();
            if (uiDependencyElement != null) {
                DependenciesView.this.componentInformationController.openSelectedComponetVersionDetails();
            }
        }

        void updateEnableState() {
            UIDependencyElement el = DependenciesView.this.controller.getCurrentDependencyElement();
            this.setEnabled(el != null && el.isLoaded());
        }
    }

    private class OpenPomAction
    extends Action {
        private OpenPomAction() {
            super(Messages.DependenciesView_actionOpenPOM);
            this.setImageDescriptor(MavenImages.POM);
        }

        void updateEnableState() {
            UIDependencyElement el = DependenciesView.this.controller.getCurrentDependencyElement();
            this.setEnabled(el != null && el.getMavenArtifactKey() != null);
        }

        public void runWithEvent(Event event) {
            ArtifactKey art;
            UIDependencyElement uiDependencyElement = DependenciesView.this.controller.getCurrentDependencyElement();
            if (uiDependencyElement != null && (art = uiDependencyElement.getMavenArtifactKey()) != null) {
                String version = uiDependencyElement.getCurrentVersion().toString();
                MavenHelper.openPOM(art.getGroupId(), art.getArtifactId(), version);
            }
        }
    }
}

