/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.ui;

import com.sonatype.clm.dto.model.ProprietaryConfig;
import com.sonatype.insight.ide.eclipse.internal.AdditionalScope;
import com.sonatype.insight.ide.eclipse.internal.ArtifactKey;
import com.sonatype.insight.ide.eclipse.internal.Messages;
import com.sonatype.insight.ide.eclipse.internal.ProjectConfigurationDTO;
import com.sonatype.insight.ide.eclipse.internal.helpers.ClasspathHelper;
import com.sonatype.insight.ide.eclipse.internal.helpers.ConfigHelper;
import com.sonatype.insight.ide.eclipse.internal.helpers.MavenHelper;
import com.sonatype.insight.ide.eclipse.internal.rest.InsightClientManager;
import com.sonatype.insight.ide.eclipse.internal.rest.UrlBuilder;
import com.sonatype.insight.ide.eclipse.internal.scan.InsightLookupCallable;
import com.sonatype.insight.ide.eclipse.internal.ui.Controller;
import com.sonatype.insight.ide.eclipse.internal.ui.WorkerThreadFactory;
import com.sonatype.insight.ide.eclipse.internal.ui.elements.ComponentKey;
import com.sonatype.insight.ide.eclipse.internal.ui.elements.JavaDependencyElement;
import com.sonatype.insight.ide.eclipse.internal.ui.elements.UIDependencyElement;
import com.sonatype.insight.ide.scan.ProprietaryComponentDetector;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectChangedListener;
import org.eclipse.m2e.core.project.MavenProjectChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.statushandlers.StatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependencyContentProvider
implements IStructuredContentProvider,
IElementChangedListener,
InsightLookupCallable.Listener,
IMavenProjectChangedListener,
JavaDependencyElement.TransitivityProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(DependencyContentProvider.class);
    public static final Object LOADING = new Object();
    private final Map<ComponentKey, UIDependencyElement> fInput = new HashMap<ComponentKey, UIDependencyElement>();
    private final Controller controller;
    private boolean firstRun = true;
    private Controller.Listener listener;
    private final ScheduledThreadPoolExecutor executor;
    private final ExecutorService transitivityExecutor;
    private final AtomicReference<Error> serverError = new AtomicReference();
    private final Map<String, String> invalidAppIds = new ConcurrentHashMap<String, String>();
    private final Set<String> applicationIds = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private ProprietaryComponentDetector proprietaryDetector;
    private final Queue<Controller.ListenerEvent> updateEvents;
    private final UpdateJob updateJob;
    private final AtomicInteger analyzedComponentCount = new AtomicInteger();
    private String applicationId;
    private Thread telemetryMonitorThread;

    public DependencyContentProvider(Controller controller) {
        this.controller = controller;
        this.executor = new ScheduledThreadPoolExecutor(4, new WorkerThreadFactory("CLM-Scanner-"), new ThreadPoolExecutor.DiscardPolicy());
        this.transitivityExecutor = Executors.newSingleThreadExecutor(new WorkerThreadFactory("CLM-Transitivie-"));
        this.updateEvents = new ConcurrentLinkedQueue<Controller.ListenerEvent>();
        this.updateJob = new UpdateJob();
        this.telemetryMonitorThread = new Thread(new TelemetryMonitor());
        this.telemetryMonitorThread.start();
    }

    public void dispose() {
        this.controller.removeListener(this.listener);
        this.updateJob.cancel();
        JavaCore.removeElementChangedListener((IElementChangedListener)this);
        this.executor.shutdownNow();
        this.transitivityExecutor.shutdownNow();
        MavenPlugin.getMavenProjectRegistry().removeMavenProjectChangedListener((IMavenProjectChangedListener)this);
        if (this.telemetryMonitorThread != null && this.telemetryMonitorThread.isAlive()) {
            this.telemetryMonitorThread.interrupt();
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getElements(Object inputElement) {
        Object[] keys;
        if (this.firstRun) {
            this.firstRun = false;
            new InitJob().schedule();
            this.listener = new Controller.Listener(){

                @Override
                public void elementChanged(Controller.ListenerEvent event) {
                    if (event.type == Controller.Type.PROJECTS_ADDED || event.type == Controller.Type.PROJECTS_REMOVED) {
                        DependencyContentProvider.this.updateEvents.add(event);
                        DependencyContentProvider.this.updateJob.schedule();
                    }
                }
            };
            this.controller.addListener(this.listener);
            JavaCore.addElementChangedListener((IElementChangedListener)this, (int)1);
            MavenPlugin.getMavenProjectRegistry().addMavenProjectChangedListener((IMavenProjectChangedListener)this);
            return new Object[]{LOADING};
        }
        Map<ComponentKey, UIDependencyElement> map = this.fInput;
        synchronized (map) {
            keys = this.fInput.values().toArray(new UIDependencyElement[this.fInput.size()]);
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getRawInputCount() {
        Map<ComponentKey, UIDependencyElement> map = this.fInput;
        synchronized (map) {
            return this.fInput.size();
        }
    }

    public void elementChanged(ElementChangedEvent event) {
        IJavaElementDelta delta = event.getDelta();
        if (delta.getKind() == 4) {
            ChangeSet changes = new ChangeSet();
            this.process(changes, delta);
            changes.process();
        }
    }

    private void process(ChangeSet changes, IJavaElementDelta delta) {
        try {
            if ((delta.getFlags() & 0x40) != 0 || delta.getKind() == 1 && delta.getElement() instanceof JarPackageFragmentRoot) {
                this.add(changes, ((IPackageFragmentRoot)delta.getElement()).getResolvedClasspathEntry(), delta.getElement().getJavaProject().getProject());
            } else if ((delta.getFlags() & 0x80) > 0) {
                this.remove(((IPackageFragmentRoot)delta.getElement()).getPath(), delta.getElement().getJavaProject().getProject());
            } else if ((delta.getFlags() & 0x200000) != 0 && delta.getAffectedChildren().length <= 0) {
                IProject project = delta.getElement().getJavaProject().getProject();
                ClasspathHelper.visitClasspath(project, new ClasspathAdder(changes), (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (JavaModelException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "com.sonatype.clm.ide.eclipse", Messages.DependencyContentProvider_errorLoadingClasspath, (Throwable)e));
        }
        IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
        int n = iJavaElementDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta cDelta = iJavaElementDeltaArray[n2];
            if (cDelta.getKind() == 4 || cDelta.getKind() == 1) {
                this.process(changes, cDelta);
            }
            ++n2;
        }
    }

    private void add(ChangeSet changes, IClasspathEntry entry, IProject project) {
        ProjectConfigurationDTO projectConfiguration = ConfigHelper.getProjectConfiguration(project);
        if (projectConfiguration.applicationId == null) {
            return;
        }
        this.add(changes, entry, project, projectConfiguration, MavenHelper.getOptionalDependencies(project, (IProgressMonitor)new NullProgressMonitor()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(ChangeSet changes, IClasspathEntry entry, IProject project, ProjectConfigurationDTO projectConfiguration, Set<File> optionalDependencies) {
        if (entry.getEntryKind() != 1 && entry.getEntryKind() != 2) {
            return;
        }
        ComponentKey key = DependencyContentProvider.getComponentKey(entry, projectConfiguration.applicationId);
        if (key == null) {
            return;
        }
        Map<String, String> attribs = this.getExtraAttributes(entry);
        boolean ignored = this.isIgnoredScope(attribs.get("maven.scope"), projectConfiguration.additionalScopes) || optionalDependencies.contains(key.getFile());
        Map<ComponentKey, UIDependencyElement> map = this.fInput;
        synchronized (map) {
            UIDependencyElement element = this.fInput.get(key);
            if (ignored) {
                if (element != null && element.remove(project)) {
                    if (element.getProjects().isEmpty()) {
                        this.fInput.remove(key);
                        changes.removed.add(element);
                    } else {
                        changes.updated.add(element);
                    }
                }
            } else if (element == null) {
                ArtifactKey gav = this.getArtifactKey(attribs, key);
                element = new JavaDependencyElement(key, project, gav, this);
                this.fInput.put(key, element);
                changes.added.add(element);
            } else {
                ArtifactKey gav = null;
                if (element.getMavenArtifactKey() == null) {
                    gav = this.getArtifactKey(attribs, key);
                    element.setMavenArtifactKey(gav);
                }
                if (element.add(project) || gav != null) {
                    changes.updated.add(element);
                } else {
                    changes.unchanged.add(element);
                }
            }
        }
    }

    private Map<String, String> getExtraAttributes(IClasspathEntry entry) {
        Map<String, String> extraAttribs;
        IClasspathAttribute[] attribs = entry.getExtraAttributes();
        if (attribs == null || attribs.length <= 0) {
            extraAttribs = Collections.emptyMap();
        } else {
            extraAttribs = new HashMap<String, String>();
            IClasspathAttribute[] iClasspathAttributeArray = attribs;
            int n = attribs.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathAttribute attrib = iClasspathAttributeArray[n2];
                extraAttribs.put(attrib.getName(), attrib.getValue());
                ++n2;
            }
        }
        return extraAttribs;
    }

    private boolean isIgnoredScope(String scope, Set<AdditionalScope> additionalScopes) {
        return !additionalScopes.contains((Object)AdditionalScope.TEST) && "test".equals(scope) || !additionalScopes.contains((Object)AdditionalScope.PROVIDED) && "provided".equals(scope) || !additionalScopes.contains((Object)AdditionalScope.SYSTEM) && "system".equals(scope);
    }

    private ArtifactKey getArtifactKey(Map<String, String> attribs, ComponentKey key) {
        ArtifactKey gav = null;
        if (!attribs.isEmpty()) {
            String groupId = attribs.get("maven.groupId");
            String artifactId = attribs.get("maven.artifactId");
            String version = attribs.get("maven.version");
            String classifier = attribs.get("maven.classifier");
            if (groupId != null && artifactId != null && version != null) {
                gav = new ArtifactKey(groupId, artifactId, version, classifier, key.getFile());
            }
        }
        return gav;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(IPath path, IProject project) {
        UIDependencyElement element;
        String appId = ConfigHelper.getProjectConfiguration((IProject)project).applicationId;
        if (appId == null) {
            return;
        }
        ComponentKey key = DependencyContentProvider.getComponentKey(path, appId);
        Map<ComponentKey, UIDependencyElement> map = this.fInput;
        synchronized (map) {
            element = this.fInput.get(key);
        }
        if (element != null) {
            element.remove(project);
            if (element.getProjects().isEmpty()) {
                map = this.fInput;
                synchronized (map) {
                    this.fInput.remove(key);
                }
                this.controller.notifyElementRemoved(Collections.singletonList(element));
            } else {
                this.controller.notifyElementUpdated(Collections.singletonList(element));
            }
        }
    }

    private void updateDependencyElements(Collection<UIDependencyElement> elements) {
        HashSet<UIDependencyElement> updated = new HashSet<UIDependencyElement>();
        for (UIDependencyElement element : elements) {
            if (element.isLoaded()) continue;
            Error err = this.serverError.get();
            if (err != null) {
                this.markLoaded(element, err.code, err.message);
                updated.add(element);
                continue;
            }
            if (this.invalidAppIds.containsKey(element.getApplicationId())) {
                this.markLoaded(element, 402, this.invalidAppIds.get(element.getApplicationId()));
                updated.add(element);
                continue;
            }
            this.executor.execute(new InsightLookupCallable(element, this, this.executor));
        }
        if (!updated.isEmpty()) {
            this.controller.notifyElementUpdated(updated);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<UIDependencyElement> getDependencyElements() {
        Map<ComponentKey, UIDependencyElement> map = this.fInput;
        synchronized (map) {
            return new LinkedList<UIDependencyElement>(this.fInput.values());
        }
    }

    public static ComponentKey getComponentKey(IClasspathEntry entry, String appId) {
        return DependencyContentProvider.getComponentKey(entry.getPath(), appId);
    }

    private static ComponentKey getComponentKey(IPath path, String appId) {
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        File file = resource != null ? resource.getLocation().toFile() : path.toFile();
        return file != null && file.isFile() ? new ComponentKey(file, appId) : null;
    }

    boolean testHasActiveJobs() {
        return this.executor.getActiveCount() > 0 || this.updateJob.getState() == 2 || this.updateJob.getState() == 4;
    }

    public Collection<String> getInvalidApplicationIds() {
        return new HashSet<String>(this.invalidAppIds.keySet());
    }

    public boolean hasServerError() {
        return this.serverError.get() != null;
    }

    @Override
    public boolean shouldRun(UIDependencyElement element) {
        if (!this.applicationIds.contains(element.getApplicationId())) {
            this.appIdInvalid(element.getApplicationId(), 404, NLS.bind((String)Messages.InsightLookupCallable_Invalid_App_token, (Object)element.getApplicationId()), null);
        }
        return this.serverError.get() == null && !this.invalidAppIds.containsKey(element.getApplicationId());
    }

    @Override
    public void lookupCompleted(UIDependencyElement element) {
        this.controller.notifyElementUpdated(Collections.singleton(element));
        this.analyzedComponentCount.incrementAndGet();
        if (this.applicationId == null) {
            this.applicationId = element.getApplicationId();
        }
    }

    @Override
    public void lookupFailed(UIDependencyElement element, int code, String message, Throwable cause) {
        if (this.markLoaded(element, code, message)) {
            this.controller.notifyElementUpdated(Collections.singleton(element));
            StatusManager.getManager().handle((IStatus)new Status(4, "com.sonatype.clm.ide.eclipse", code, message, cause));
        }
        this.analyzedComponentCount.incrementAndGet();
        if (this.applicationId == null) {
            this.applicationId = element.getApplicationId();
        }
    }

    @Override
    public void serverUnreachable(int code, String message, Throwable cause) {
        this.serverMisconfigured(code, message, cause, 1);
        this.analyzedComponentCount.incrementAndGet();
    }

    @Override
    public void credentialsInvalid(int code, String message, Throwable cause) {
        this.serverMisconfigured(code, message, cause, 1);
        this.analyzedComponentCount.incrementAndGet();
    }

    private void serverMisconfigured(int code, String message, Throwable cause, int style) {
        if (this.serverError.get() == null && this.serverError.compareAndSet(null, new Error(code, message))) {
            this.executor.shutdownNow();
            this.markLoaded(null, code, message, cause);
            this.controller.notifyServerFailed(code, message);
            StatusManager.getManager().handle((IStatus)new Status(4, "com.sonatype.clm.ide.eclipse", code, message, cause), style);
        }
    }

    @Override
    public void appIdInvalid(String appId, int code, String message, Throwable cause) {
        if (this.serverError.get() == null && this.invalidAppIds.put(appId, message) == null) {
            this.markLoaded(appId, code, message, cause);
            this.controller.notifyInvalidApplicationId(appId);
            StatusManager.getManager().handle((IStatus)new Status(4, "com.sonatype.clm.ide.eclipse", 402, message, null), 1);
        }
        this.analyzedComponentCount.incrementAndGet();
    }

    private void markLoaded(String appId, int code, String message, Throwable cause) {
        HashSet<UIDependencyElement> elements = new HashSet<UIDependencyElement>();
        for (UIDependencyElement el : this.getDependencyElements()) {
            if (appId != null && !appId.equals(el.getApplicationId()) || !this.markLoaded(el, code, message)) continue;
            elements.add(el);
        }
        this.controller.notifyElementUpdated(elements);
    }

    private boolean markLoaded(UIDependencyElement element, int code, String message) {
        if (!element.isLoaded()) {
            element.setError(code, message);
            element.markAsLoaded();
            return true;
        }
        return false;
    }

    @Override
    public ProprietaryComponentDetector getProprietaryDetector() {
        return this.proprietaryDetector;
    }

    public void mavenProjectChanged(List<MavenProjectChangedEvent> events, IProgressMonitor monitor) {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)events.size());
        try {
            ClasspathAdder visitor = new ClasspathAdder();
            for (MavenProjectChangedEvent event : events) {
                if (event.getKind() == 3 || event.getKind() == 1) {
                    IProject project = event.getMavenProject().getProject();
                    ClasspathHelper.visitClasspath(project, visitor, (IProgressMonitor)mon.newChild(1));
                    continue;
                }
                mon.worked(1);
            }
            for (UIDependencyElement element : visitor.changes.unchanged) {
                element.resetTransitivity();
            }
            visitor.changes.process();
        }
        finally {
            mon.done();
        }
    }

    @Override
    public void process(Runnable element) {
        this.transitivityExecutor.execute(element);
    }

    @Override
    public void update(UIDependencyElement element) {
        this.controller.notifyElementUpdated(Collections.singleton(element));
    }

    public Set<String> getApplicationIds() {
        return Collections.unmodifiableSet(this.applicationIds);
    }

    class ChangeSet {
        final Set<UIDependencyElement> added = new HashSet<UIDependencyElement>(256);
        final Set<UIDependencyElement> removed = new HashSet<UIDependencyElement>(256);
        final Set<UIDependencyElement> updated = new HashSet<UIDependencyElement>(256);
        final Set<UIDependencyElement> unchanged = new HashSet<UIDependencyElement>(256);

        ChangeSet() {
        }

        public void process() {
            if (!this.removed.isEmpty()) {
                DependencyContentProvider.this.controller.notifyElementRemoved(this.removed);
            }
            if (!this.added.isEmpty()) {
                DependencyContentProvider.this.controller.notifyElementAdded(this.added);
                DependencyContentProvider.this.updateDependencyElements(this.added);
            }
            if (!this.updated.isEmpty()) {
                DependencyContentProvider.this.controller.notifyElementUpdated(this.updated);
            }
        }
    }

    private class ClasspathAdder
    implements ClasspathHelper.IClasspathEntryVisitor {
        private final ChangeSet changes;
        private IProject lastProject;
        private Set<File> optionalDependencies;

        public ClasspathAdder() {
            this(null);
        }

        public ClasspathAdder(ChangeSet changes) {
            this.changes = changes != null ? changes : new ChangeSet();
        }

        @Override
        public void visit(IClasspathEntry entry, IProject project, IClasspathContainer container, ProjectConfigurationDTO projectConfiguration, IProgressMonitor monitor) {
            if (!project.equals((Object)this.lastProject)) {
                this.lastProject = project;
                this.optionalDependencies = MavenHelper.getOptionalDependencies(project, monitor);
            }
            DependencyContentProvider.this.add(this.changes, entry, project, projectConfiguration, this.optionalDependencies);
        }
    }

    private static class Error {
        public final int code;
        public final String message;

        public Error(int code, String message) {
            this.code = code;
            this.message = message;
        }
    }

    private class InitJob
    extends Job {
        public InitJob() {
            super("Gathering monitored projects");
        }

        /*
         * Exception decompiling
         */
        protected IStatus run(IProgressMonitor monitor) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private ProprietaryConfig getProprietaryConfig() throws IOException, URISyntaxException {
            UrlBuilder url = new UrlBuilder(InsightClientManager.getInstance().getServerUrl());
            url.appendPath("rest/config/proprietary");
            return InsightClientManager.getInstance().getClient().get(url.build(), ProprietaryConfig.class);
        }
    }

    private class TelemetryMonitor
    implements Runnable {
        private long TEN_SECONDS = 10000L;
        private int maxCount = 60;

        private TelemetryMonitor() {
        }

        @Override
        public void run() {
            LOG.debug("TelemetryMonitor started.");
            HashMap<String, Integer> map = null;
            int loopCount = 0;
            while (loopCount < this.maxCount) {
                block6: {
                    try {
                        Thread.sleep(this.TEN_SECONDS);
                        if (DependencyContentProvider.this.applicationId != null && DependencyContentProvider.this.analyzedComponentCount.intValue() == DependencyContentProvider.this.fInput.size()) {
                            map = new HashMap<String, Integer>();
                            map.put("maven", DependencyContentProvider.this.analyzedComponentCount.intValue());
                            InsightClientManager.getInstance().getClient().sendTelemetry(map, DependencyContentProvider.this.applicationId, DependencyContentProvider.this.controller.isDarkThemeInUse());
                        }
                        break block6;
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    break;
                }
                ++loopCount;
            }
            if (map != null) {
                LOG.info("IQ telemetry sent - analyzed component count: " + String.valueOf(DependencyContentProvider.this.analyzedComponentCount));
            } else {
                LOG.info("IQ telemetry not sent after waiting for 10 minutes.");
            }
        }
    }

    private class UpdateJob
    extends Job {
        public UpdateJob() {
            super("Updating component list");
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                Controller.ListenerEvent event = DependencyContentProvider.this.updateEvents.poll();
                if (event != null) {
                    if (event.type == Controller.Type.PROJECTS_ADDED) {
                        this.added(event.getElements(IProject.class), monitor);
                    } else if (event.type == Controller.Type.PROJECTS_REMOVED) {
                        this.removed(event.getElements(IProject.class), monitor);
                    } else {
                        throw new IllegalStateException("unexpected event type " + String.valueOf((Object)event.type));
                    }
                }
                if (!DependencyContentProvider.this.updateEvents.isEmpty()) {
                    this.schedule();
                }
                IStatus iStatus = monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
                return iStatus;
            }
            finally {
                monitor.done();
            }
        }

        private void added(Collection<IProject> projects, IProgressMonitor monitor) {
            SubMonitor pm = SubMonitor.convert((IProgressMonitor)monitor, (int)(projects.size() + 1));
            ClasspathAdder visitor = new ClasspathAdder();
            for (IProject project : projects) {
                pm.subTask("Processing build path of " + project.getName());
                ClasspathHelper.visitClasspath(project, visitor, (IProgressMonitor)pm.newChild(1));
                if (!pm.isCanceled()) continue;
                return;
            }
            visitor.changes.process();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removed(Collection<IProject> projects, IProgressMonitor monitor) {
            SubMonitor pm = SubMonitor.convert((IProgressMonitor)monitor, (int)(projects.size() + 1));
            for (IProject project : projects) {
                pm.subTask("Processing build path of " + project.getName());
                Map<ComponentKey, UIDependencyElement> map = DependencyContentProvider.this.fInput;
                synchronized (map) {
                    ArrayList<UIDependencyElement> rem = new ArrayList<UIDependencyElement>();
                    ArrayList<UIDependencyElement> upd = new ArrayList<UIDependencyElement>();
                    UIDependencyElement[] uIDependencyElementArray = DependencyContentProvider.this.fInput.values().toArray(new UIDependencyElement[DependencyContentProvider.this.fInput.size()]);
                    int n = uIDependencyElementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        UIDependencyElement element = uIDependencyElementArray[n2];
                        boolean removed = element.remove(project);
                        if (element.getProjects().isEmpty()) {
                            DependencyContentProvider.this.fInput.remove(element.getComponentKey());
                            rem.add(element);
                            upd.remove(element);
                        } else if (removed) {
                            upd.add(element);
                        }
                        ++n2;
                    }
                    if (!rem.isEmpty()) {
                        DependencyContentProvider.this.controller.notifyElementRemoved(rem);
                    }
                    if (!upd.isEmpty()) {
                        DependencyContentProvider.this.controller.notifyElementUpdated(upd);
                    }
                }
                if (pm.isCanceled()) {
                    return;
                }
                pm.worked(1);
            }
        }
    }
}

