/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.ui;

import com.sonatype.insight.ide.eclipse.Images;
import com.sonatype.insight.ide.eclipse.internal.ArtifactKey;
import com.sonatype.insight.ide.eclipse.internal.Messages;
import com.sonatype.insight.ide.eclipse.internal.ui.DependencyContentProvider;
import com.sonatype.insight.ide.eclipse.internal.ui.elements.JavaDependencyElement;
import com.sonatype.insight.ide.eclipse.internal.ui.elements.UIDependencyElement;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class DependencyLabelProvider
extends ColumnLabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    public Image getImage(Object element) {
        if (element instanceof JavaDependencyElement) {
            return ((JavaDependencyElement)element).getImage();
        }
        if (DependencyContentProvider.LOADING.equals(element)) {
            return Images.getImage("empty.gif");
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof JavaDependencyElement) {
            return ((JavaDependencyElement)element).getName();
        }
        if (DependencyContentProvider.LOADING.equals(element)) {
            return Messages.DependencyLabelProvider_loading;
        }
        return super.getText(element);
    }

    public StyledString getStyledText(Object element) {
        StyledString ss = new StyledString();
        if (element instanceof UIDependencyElement) {
            UIDependencyElement uidep = (UIDependencyElement)element;
            ArtifactKey key = uidep.getMavenArtifactKey();
            if (key != null) {
                if (uidep.isTransitive()) {
                    ss.append(key.getArtifactId() + " - ", StyledString.QUALIFIER_STYLER);
                } else {
                    ss.append(key.getArtifactId() + " - ");
                }
                ss.append(key.getVersion(), StyledString.DECORATIONS_STYLER);
            } else {
                ss.append(uidep.getName());
                ss.append(" - ");
                ss.append(uidep.getFileLocation().toString(), StyledString.DECORATIONS_STYLER);
            }
        } else if (DependencyContentProvider.LOADING.equals(element)) {
            ss.append(Messages.DependencyLabelProvider_loading);
        }
        return ss;
    }
}

