/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.ui;

import com.sonatype.insight.ide.eclipse.Activator;
import com.sonatype.insight.ide.eclipse.Pref;
import com.sonatype.insight.ide.eclipse.internal.Messages;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;

public class FiltersDialog
extends Dialog {
    private String showProjectScope;
    private String projectSelection;
    private String worksetSelection;
    private Button btnAllOpenedProjects;
    private Button btnCurrentSelectionProject;
    private Button btnCurrentSelectionWorkset;
    private Button btnProject;
    private Button btnWorkingSet;
    private Combo comProject;
    private Combo comWorkingSet;

    public FiltersDialog(Shell parentShell) {
        super(parentShell);
        this.init();
    }

    private void init() {
        this.showProjectScope = Pref.getShowProjects();
        this.projectSelection = Pref.getProjectSelection();
        this.worksetSelection = Pref.getWorkingSetSelection();
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        Group scopeGroup = new Group(container, 0);
        scopeGroup.setText(Messages.FiltersDialog_lblProjectScope_text);
        scopeGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        scopeGroup.setLayout((Layout)new GridLayout(2, false));
        this.btnAllOpenedProjects = new Button((Composite)scopeGroup, 16);
        this.btnAllOpenedProjects.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.btnAllOpenedProjects.setText(Messages.FiltersDialog_btnAllOpenedProjects_text);
        this.btnCurrentSelectionProject = new Button((Composite)scopeGroup, 16);
        this.btnCurrentSelectionProject.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.btnCurrentSelectionProject.setText(Messages.FiltersDialog_btnCurrentSelectionProject_text);
        this.btnCurrentSelectionWorkset = new Button((Composite)scopeGroup, 16);
        this.btnCurrentSelectionWorkset.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.btnCurrentSelectionWorkset.setText(Messages.FiltersDialog_btnCurrentSelectionWorkset_text);
        this.btnProject = new Button((Composite)scopeGroup, 16);
        this.btnProject.setText(Messages.FiltersDialog_btnProject_text);
        this.btnProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FiltersDialog.this.comProject.setEnabled(FiltersDialog.this.btnProject.getSelection());
            }
        });
        this.comProject = new Combo((Composite)scopeGroup, 2056);
        GridData gd_comProject = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_comProject.widthHint = 250;
        this.comProject.setLayoutData((Object)gd_comProject);
        this.btnWorkingSet = new Button((Composite)scopeGroup, 16);
        this.btnWorkingSet.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FiltersDialog.this.comWorkingSet.setEnabled(FiltersDialog.this.btnWorkingSet.getSelection());
            }
        });
        this.btnWorkingSet.setText(Messages.FiltersDialog_btnRadioButton_text);
        this.comWorkingSet = new Combo((Composite)scopeGroup, 2056);
        GridData gd_comWorkingSet = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_comWorkingSet.widthHint = 250;
        this.comWorkingSet.setLayoutData((Object)gd_comWorkingSet);
        ArrayList<String> prjNames = new ArrayList<String>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject prj = iProjectArray[n2];
            if (prj.isOpen()) {
                prjNames.add(prj.getName());
            }
            ++n2;
        }
        this.comProject.setItems(prjNames.toArray(new String[0]));
        ArrayList<String> wsNames = new ArrayList<String>();
        IWorkingSet[] iWorkingSetArray = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets();
        int n3 = iWorkingSetArray.length;
        n = 0;
        while (n < n3) {
            IWorkingSet set = iWorkingSetArray[n];
            wsNames.add(set.getName());
            ++n;
        }
        this.comWorkingSet.setItems(wsNames.toArray(new String[0]));
        if (this.showProjectScope != null) {
            if ("all".equals(this.showProjectScope)) {
                this.btnAllOpenedProjects.setSelection(true);
            } else if ("currentProject".equals(this.showProjectScope)) {
                this.btnCurrentSelectionProject.setSelection(true);
            } else if ("currentWorkset".equals(this.showProjectScope)) {
                this.btnCurrentSelectionWorkset.setSelection(true);
            } else if ("project".equals(this.showProjectScope)) {
                this.btnProject.setSelection(true);
            } else if ("workset".equals(this.showProjectScope)) {
                this.btnWorkingSet.setSelection(true);
            }
        } else {
            this.btnAllOpenedProjects.setSelection(true);
        }
        this.comWorkingSet.setEnabled(this.btnWorkingSet.getSelection());
        this.comProject.setEnabled(this.btnProject.getSelection());
        if (this.projectSelection != null && prjNames.contains(this.projectSelection)) {
            this.comProject.select(prjNames.indexOf(this.projectSelection));
        }
        if (this.worksetSelection != null && wsNames.contains(this.worksetSelection)) {
            this.comWorkingSet.select(wsNames.indexOf(this.worksetSelection));
        }
        return container;
    }

    protected void configureShell(Shell shell) {
        shell.setText(Messages.FiltersDialog_title);
        super.configureShell(shell);
    }

    protected void okPressed() {
        this.setString("showProjects", this.btnAllOpenedProjects.getSelection() ? "all" : (this.btnCurrentSelectionProject.getSelection() ? "currentProject" : (this.btnCurrentSelectionWorkset.getSelection() ? "currentWorkset" : (this.btnProject.getSelection() ? "project" : "workset"))), this.showProjectScope);
        if (this.btnProject.getSelection() && this.comProject.getSelectionIndex() != -1) {
            this.setString("selectedProject", this.comProject.getItem(this.comProject.getSelectionIndex()), this.projectSelection);
        }
        if (this.btnWorkingSet.getSelection() && this.comWorkingSet.getSelectionIndex() != -1) {
            this.setString("selectedWorkset", this.comWorkingSet.getItem(this.comWorkingSet.getSelectionIndex()), this.worksetSelection);
        }
        super.okPressed();
    }

    private void setString(String pref, String newValue, String oldValue) {
        if (newValue != null && !newValue.equals(oldValue) || oldValue != null && !oldValue.equals(newValue)) {
            Activator.setStringPreference(pref, newValue);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected boolean isResizable() {
        return true;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings sett = Activator.getDefault().getDialogSettings().getSection("filter");
        if (sett == null) {
            sett = Activator.getDefault().getDialogSettings().addNewSection("filter");
        }
        return sett;
    }
}

