/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.ui;

import com.sonatype.clm.dto.model.application.ApplicationSummary;
import com.sonatype.clm.dto.model.application.ApplicationSummaryList;
import com.sonatype.insight.ide.eclipse.Activator;
import com.sonatype.insight.ide.eclipse.Images;
import com.sonatype.insight.ide.eclipse.internal.AdditionalScope;
import com.sonatype.insight.ide.eclipse.internal.Messages;
import com.sonatype.insight.ide.eclipse.internal.ProjectConfigurationDTO;
import com.sonatype.insight.ide.eclipse.internal.helpers.ConfigHelper;
import com.sonatype.insight.ide.eclipse.internal.rest.InsightClientManager;
import com.sonatype.insight.ide.eclipse.internal.rest.UrlBuilder;
import com.sonatype.insight.ide.eclipse.internal.ui.Controller;
import com.sonatype.insight.ide.eclipse.internal.ui.elements.ProjectAssociation;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.http.client.HttpResponseException;
import org.apache.http.conn.HttpHostConnectException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.DecoratingJavaLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.JavaUILabelProvider;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.statushandlers.StatusManager;

public class ProjectAssociationDialog
extends TitleAreaDialog {
    private ComboViewer applicationIdCombo;
    private Text serverURLText;
    private Text serverUsernameText;
    private Text serverPasswordText;
    private Button basicAuthenticationRadio;
    private Button pkiAuthenticationRadio;
    private Button persistCredentials;
    private TableViewer workspaceProjects;
    private TableViewer appIdProjects;
    private Button addButton;
    private Button addAllButton;
    private Button removeButton;
    private Button removeAllButton;
    private Button refreshButton;
    private Button providedCheckbox;
    private Button testCheckbox;
    private Button systemCheckbox;
    private Map<String, Set<IProject>> appIdContent = new TreeMap<String, Set<IProject>>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, Set<AdditionalScope>> appIdAdditionalScopes = new HashMap<String, Set<AdditionalScope>>();
    private Set<IProject> workspaceContent = new HashSet<IProject>();
    private Map<IProject, ProjectConfigurationDTO> initialState;
    private Map<String, ProjectAssociation> projects = new TreeMap<String, ProjectAssociation>(String.CASE_INSENSITIVE_ORDER);
    private Controller controller;
    private ProgressMonitorPart progressMonitorPart;

    public ProjectAssociationDialog(Shell parentShell, Controller controller) {
        super(parentShell);
        this.controller = controller;
    }

    private boolean buildModel(IProgressMonitor parentMonitor) {
        if (this.initialState != null) {
            return false;
        }
        HashMap<IProject, ProjectConfigurationDTO> initial = new HashMap<IProject, ProjectConfigurationDTO>(this.workspaceContent.size());
        this.initialState = Collections.unmodifiableMap(initial);
        try {
            IJavaProject o;
            IJavaModel model = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
            Object[] objectArray = model.getJavaProjects();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                o = objectArray[n2];
                this.workspaceContent.add(this.getProject(o));
                ++n2;
            }
            objectArray = model.getNonJavaResources();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                o = objectArray[n2];
                this.workspaceContent.add(this.getProject(o));
                ++n2;
            }
        }
        catch (JavaModelException e) {
            StatusManager.getManager().handle(e.getStatus());
            this.setMessage(Messages.ProjectAssociationDialog_errorLoadingWorkspace, 3);
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)parentMonitor, (int)this.workspaceContent.size());
        try {
            Iterator<IProject> iter = this.workspaceContent.iterator();
            while (iter.hasNext()) {
                ProjectConfigurationDTO projectConfig;
                IProject project = iter.next();
                ProjectConfigurationDTO projectConfigurationDTO = projectConfig = project == null ? new ProjectConfigurationDTO() : ConfigHelper.getProjectConfiguration(project);
                if (projectConfig.applicationId != null) {
                    iter.remove();
                    this.getAppIdContent(projectConfig.applicationId).add(project);
                    initial.put(project, projectConfig);
                }
                monitor.worked(1);
            }
            return true;
        }
        finally {
            monitor.done();
        }
    }

    private synchronized Set<IProject> getAppIdContent(String appId) {
        Set<IProject> content = this.appIdContent.get(appId);
        if (content == null) {
            content = new HashSet<IProject>();
            this.appIdContent.put(appId, content);
        }
        return content;
    }

    private void persistState() {
        ProgressMonitorPart monitor = this.progressMonitorPart;
        try {
            monitor.beginTask(Messages.ProjectAssociationDialog_saving, this.workspaceContent.size());
            Set<String> knownAppIds = this.controller.getProvider().getApplicationIds();
            boolean newAppId = false;
            for (ProjectAssociation assoc : this.projects.values()) {
                for (IProject project : assoc.getAssignedProjects()) {
                    ProjectConfigurationDTO initial;
                    ProjectConfigurationDTO current = new ProjectConfigurationDTO(assoc.getAppId(), this.getAdditionalScopes(assoc.getAppId()));
                    if (!current.equals(initial = this.initialState.get(project))) {
                        ConfigHelper.setProjectConfiguration(project, current);
                    }
                    monitor.worked(1);
                }
                if (assoc.getAppName() == null || assoc.getAssignedProjects().isEmpty() || knownAppIds.contains(assoc.getAppId())) continue;
                newAppId = true;
            }
            for (IProject o : this.workspaceContent) {
                if (this.initialState.get(o) == null) continue;
                if (o != null) {
                    ProjectConfigurationDTO unassignedConfiguration = new ProjectConfigurationDTO(null, null);
                    ConfigHelper.setProjectConfiguration(o, unassignedConfiguration);
                }
                monitor.worked(1);
            }
            boolean changed = this.pkiAuthenticationRadio.getSelection() ? InsightClientManager.getInstance().setServerWithPkiAuthentication(this.serverURLText.getText()) : InsightClientManager.getInstance().setServerWithBasicAuthentication(this.serverURLText.getText(), this.serverUsernameText.getText(), this.serverPasswordText.getText(), this.persistCredentials.getSelection());
            if (changed) {
                this.controller.notifyServerChanged(this.serverURLText.getText());
                this.controller.resetProvider();
            } else if (newAppId) {
                this.controller.resetProvider();
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void okPressed() {
        this.persistState();
        super.okPressed();
    }

    private IProject getProject(Object candidate) {
        if (candidate instanceof IJavaProject) {
            return ((IJavaProject)candidate).getProject();
        }
        if (candidate instanceof IProject) {
            return (IProject)candidate;
        }
        return null;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.ProjectAssociationDialog_title);
        this.setHelpAvailable(false);
        parent.getShell().setImage(Images.getImage("configure.gif"));
        parent.getShell().setText(Messages.ProjectAssociationDialog_message);
        parent.getShell().setMinimumSize(this.convertWidthInCharsToPixels(75), this.convertHeightInCharsToPixels(30));
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createTopSection(container);
        Composite columnComposite = new Composite(container, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        columnComposite.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, true);
        columnComposite.setLayoutData((Object)gd);
        Composite leftComposite = new Composite(columnComposite, 0);
        GridData left_gd = new GridData(4, 4, true, true);
        left_gd.widthHint = this.convertWidthInCharsToPixels(10);
        left_gd.heightHint = this.convertHeightInCharsToPixels(15);
        leftComposite.setLayoutData((Object)left_gd);
        leftComposite.setLayout((Layout)new GridLayout(1, false));
        Label label = new Label(leftComposite, 0);
        label.setText(Messages.ProjectAssociationDialog_unassignedContentButton);
        this.createWorkspaceTree(leftComposite);
        Composite centerComposite = new Composite(columnComposite, 0);
        centerComposite.setLayout((Layout)new GridLayout(1, false));
        centerComposite.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        label = new Label(centerComposite, 0);
        this.addButton = new Button(centerComposite, 0);
        this.addButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.addButton.setText(Messages.ProjectAssociationDialog_addBtn);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectAssociationDialog.this.addSelected();
                ProjectAssociationDialog.this.updateButtons();
            }
        });
        this.addAllButton = new Button(centerComposite, 0);
        this.addAllButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.addAllButton.setText(Messages.ProjectAssociationDialog_addAllBtn);
        this.addAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectAssociationDialog.this.workspaceProjects.setSelection((ISelection)new StructuredSelection(ProjectAssociationDialog.this.workspaceContent.toArray()));
                ProjectAssociationDialog.this.addSelected();
                ProjectAssociationDialog.this.updateButtons();
            }
        });
        this.removeButton = new Button(centerComposite, 0);
        this.removeButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.removeButton.setText(Messages.ProjectAssociationDialog_remove);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectAssociationDialog.this.removeSelected();
                ProjectAssociationDialog.this.updateButtons();
            }
        });
        this.removeAllButton = new Button(centerComposite, 0);
        this.removeAllButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.removeAllButton.setText(Messages.ProjectAssociationDialog_removeAll);
        this.removeAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ProjectAssociationDialog.this.applicationIdCombo.getSelection();
                if (!selection.isEmpty()) {
                    ProjectAssociationDialog.this.appIdProjects.setSelection((ISelection)new StructuredSelection(((ProjectAssociation)selection.getFirstElement()).getAssignedProjects().toArray()));
                }
                ProjectAssociationDialog.this.removeSelected();
                ProjectAssociationDialog.this.updateButtons();
            }
        });
        Composite rightComposite = new Composite(columnComposite, 0);
        GridData right_gd = new GridData(4, 4, true, true);
        right_gd.widthHint = this.convertWidthInCharsToPixels(10);
        rightComposite.setLayoutData((Object)right_gd);
        rightComposite.setLayout((Layout)new GridLayout(1, false));
        label = new Label(rightComposite, 0);
        label.setText(Messages.ProjectAssociationDialog_applicationIdContentButton);
        this.createAppIdTree(rightComposite);
        this.progressMonitorPart = new ProgressMonitorPart(container, (Layout)new GridLayout());
        this.progressMonitorPart.setLayoutData((Object)new GridData(768));
        this.progressMonitorPart.setVisible(false);
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ProjectAssociationDialog.this.doLoad();
            }
        });
        this.updateButtons();
        return area;
    }

    private void createTopSection(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        container.setLayoutData((Object)new GridData(4, 128, true, false));
        ModifyListener messageResetter = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProjectAssociationDialog.this.setErrorMessage(null);
            }
        };
        Label serverURLLabel = new Label(container, 0);
        serverURLLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        serverURLLabel.setText(Messages.ProjectAssociationDialog_serverURL);
        this.serverURLText = new Text(container, 2048);
        this.serverURLText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.serverURLText.setText(InsightClientManager.getInstance().getServerUrl());
        this.serverURLText.addModifyListener(messageResetter);
        new Label(container, 0);
        this.createAuthGroup(container, messageResetter);
        Label lblApplicationId = new Label(container, 0);
        lblApplicationId.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblApplicationId.setText(Messages.ProjectAssociationDialog_applicationName);
        this.applicationIdCombo = new ComboViewer(container, 2048);
        this.applicationIdCombo.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.applicationIdCombo.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object o1, Object o2) {
                if (o1 instanceof ProjectAssociation && o2 instanceof ProjectAssociation) {
                    return ((ProjectAssociation)o1).compareTo((ProjectAssociation)o2);
                }
                return 0;
            }
        });
        this.applicationIdCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.applicationIdCombo.getCombo().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ProjectAssociationDialog.this.applicationIdCombo.getSelection();
                if (!selection.isEmpty()) {
                    ProjectAssociationDialog.this.appIdProjects.setInput(((ProjectAssociation)selection.getFirstElement()).getAssignedProjects());
                } else {
                    ProjectAssociationDialog.this.appIdProjects.setInput((Object)new Object[0]);
                }
                ProjectAssociationDialog.this.updateButtons();
                ProjectAssociationDialog.this.updateAdditionalScopeCheckboxes();
            }
        });
        ContentProposalAdapter adapter = new ContentProposalAdapter(this.applicationIdCombo.getControl(), (IControlContentAdapter)new ComboContentAdapter(){

            public void setControlContents(Control control, String text, int cursorPosition) {
                ProjectAssociationDialog.this.applicationIdCombo.setSelection((ISelection)new StructuredSelection((Object)ProjectAssociationDialog.this.projects.get(text)));
            }
        }, new IContentProposalProvider(){

            public IContentProposal[] getProposals(String contents, int position) {
                contents = contents.toLowerCase(Locale.ENGLISH);
                ArrayList<ProjectAssociation> matches = new ArrayList<ProjectAssociation>();
                for (ProjectAssociation assoc : ProjectAssociationDialog.this.projects.values()) {
                    if ((assoc.getAppName() == null || !assoc.getAppName().toLowerCase(Locale.ENGLISH).contains(contents)) && !assoc.getAppId().toLowerCase(Locale.ENGLISH).contains(contents)) continue;
                    matches.add(assoc);
                }
                IContentProposal[] proposals = new IContentProposal[matches.size()];
                int i = 0;
                while (i < matches.size()) {
                    final ProjectAssociation proposal = (ProjectAssociation)matches.get(i);
                    proposals[i] = new IContentProposal(){

                        public String getContent() {
                            return proposal.getAppId();
                        }

                        public int getCursorPosition() {
                            return proposal.getAppId().length();
                        }

                        public String getDescription() {
                            return null;
                        }

                        public String getLabel() {
                            return proposal.toString();
                        }
                    };
                    ++i;
                }
                return proposals;
            }
        }, null, null);
        adapter.setPropagateKeys(true);
        adapter.setProposalAcceptanceStyle(2);
        this.refreshButton = new Button(container, 0);
        this.refreshButton.setText(Messages.ProjectAssociationDialog_refreshBtn);
        this.refreshButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectAssociationDialog.this.doLoad();
            }
        });
        Label additionalScopesLabel = new Label(container, 0);
        additionalScopesLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        additionalScopesLabel.setText(Messages.ProjectAssociationDialog_additionalScopes);
        additionalScopesLabel.setToolTipText(Messages.ProjectAssociationDialog_additionalScopesToolTip);
        Composite checkboxesComposite = new Composite(container, 0);
        checkboxesComposite.setLayout((Layout)new GridLayout(3, false));
        checkboxesComposite.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        checkboxesComposite.setToolTipText(Messages.ProjectAssociationDialog_additionalScopesToolTip);
        this.providedCheckbox = new Button(checkboxesComposite, 32);
        this.providedCheckbox.setEnabled(false);
        this.providedCheckbox.setText(Messages.ProjectAssociationDialog_providedCheckbox);
        this.providedCheckbox.addSelectionListener((SelectionListener)new AdditionalScopeSelectionAdapter(AdditionalScope.PROVIDED));
        this.providedCheckbox.setToolTipText(Messages.ProjectAssociationDialog_additionalScopesToolTip);
        this.testCheckbox = new Button(checkboxesComposite, 32);
        this.testCheckbox.setEnabled(false);
        this.testCheckbox.setText(Messages.ProjectAssociationDialog_testCheckbox);
        this.testCheckbox.addSelectionListener((SelectionListener)new AdditionalScopeSelectionAdapter(AdditionalScope.TEST));
        this.testCheckbox.setToolTipText(Messages.ProjectAssociationDialog_additionalScopesToolTip);
        this.systemCheckbox = new Button(checkboxesComposite, 32);
        this.systemCheckbox.setEnabled(false);
        this.systemCheckbox.setText(Messages.ProjectAssociationDialog_systemCheckbox);
        this.systemCheckbox.addSelectionListener((SelectionListener)new AdditionalScopeSelectionAdapter(AdditionalScope.SYSTEM));
        this.systemCheckbox.setToolTipText(Messages.ProjectAssociationDialog_additionalScopesToolTip);
    }

    private void createAuthGroup(Composite parent, ModifyListener messageResetter) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        boolean pkiAuthentication = InsightClientManager.getInstance().isPkiAuthentication();
        this.pkiAuthenticationRadio = new Button((Composite)group, 16);
        this.pkiAuthenticationRadio.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.pkiAuthenticationRadio.setText(Messages.ProjectAssociationDialog_pkiAuthentication);
        this.pkiAuthenticationRadio.setSelection(pkiAuthentication);
        this.basicAuthenticationRadio = new Button((Composite)group, 16);
        this.basicAuthenticationRadio.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.basicAuthenticationRadio.setText(Messages.ProjectAssociationDialog_basicAuthentication);
        this.basicAuthenticationRadio.setSelection(!pkiAuthentication);
        final Label serverUsernameLabel = new Label((Composite)group, 0);
        GridData data = new GridData(131072, 0x1000000, false, false, 1, 1);
        data.horizontalIndent = 20;
        serverUsernameLabel.setLayoutData((Object)data);
        serverUsernameLabel.setText(Messages.ProjectAssociationDialog_serverUsername);
        this.serverUsernameText = new Text((Composite)group, 2048);
        this.serverUsernameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.serverUsernameText.setText(InsightClientManager.getInstance().getUsername());
        this.serverUsernameText.addModifyListener(messageResetter);
        if (!this.serverURLText.getText().isEmpty() && this.serverUsernameText.getText().isEmpty()) {
            this.serverUsernameText.setFocus();
        }
        final Label serverPasswordLabel = new Label((Composite)group, 0);
        data = new GridData(131072, 0x1000000, false, false, 1, 1);
        data.horizontalIndent = 20;
        serverPasswordLabel.setLayoutData((Object)data);
        serverPasswordLabel.setText(Messages.ProjectAssociationDialog_serverPassword);
        this.serverPasswordText = new Text((Composite)group, 0x400800);
        this.serverPasswordText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.serverPasswordText.setText(InsightClientManager.getInstance().getPassword());
        this.serverPasswordText.addModifyListener(messageResetter);
        this.persistCredentials = new Button((Composite)group, 32);
        data = new GridData(4, 0x1000000, true, false, 2, 1);
        data.horizontalIndent = 20;
        this.persistCredentials.setLayoutData((Object)data);
        this.persistCredentials.setText(Messages.ProjectAssociationDialog_persistCredentials);
        this.persistCredentials.setSelection(InsightClientManager.getInstance().isPersistCredentials());
        SelectionAdapter authSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean basicAuthEnabled = !ProjectAssociationDialog.this.pkiAuthenticationRadio.getSelection();
                ProjectAssociationDialog.this.serverUsernameText.setEnabled(basicAuthEnabled);
                serverUsernameLabel.setEnabled(basicAuthEnabled);
                ProjectAssociationDialog.this.serverPasswordText.setEnabled(basicAuthEnabled);
                serverPasswordLabel.setEnabled(basicAuthEnabled);
                ProjectAssociationDialog.this.persistCredentials.setEnabled(basicAuthEnabled);
            }
        };
        authSelectionListener.widgetSelected(null);
        this.basicAuthenticationRadio.addSelectionListener((SelectionListener)authSelectionListener);
        this.pkiAuthenticationRadio.addSelectionListener((SelectionListener)authSelectionListener);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.FINISH_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private void addSelected() {
        Set<IProject> projects = this.getSelected() == null ? null : this.getSelected().getAssignedProjects();
        this.appIdProjects.setInput(projects);
        Table table = this.workspaceProjects.getTable();
        int[] nArray = table.getSelectionIndices();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            Object data = table.getItem(i).getData();
            this.workspaceContent.remove(data);
            projects.add((IProject)data);
            ++n2;
        }
        this.workspaceProjects.refresh();
        this.applicationIdCombo.refresh();
        this.appIdProjects.setInput(projects);
    }

    private void removeSelected() {
        ProjectAssociation assoc = this.getSelected();
        Set<IProject> content = assoc.getAssignedProjects();
        Table table = this.appIdProjects.getTable();
        int[] nArray = table.getSelectionIndices();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            Object data = table.getItem(i).getData();
            this.workspaceContent.add((IProject)data);
            content.remove(data);
            ++n2;
        }
        if (content.isEmpty() && assoc.getAppName() == null) {
            this.projects.remove(assoc.getAppId());
            this.setMessage("");
        }
        this.appIdProjects.refresh();
        this.applicationIdCombo.refresh();
        this.workspaceProjects.refresh();
    }

    private Set<AdditionalScope> getAdditionalScopes() {
        ProjectAssociation selection = this.getSelected();
        return selection != null ? this.getAdditionalScopes(selection.getAppId()) : EnumSet.noneOf(AdditionalScope.class);
    }

    private Set<AdditionalScope> getAdditionalScopes(String appId) {
        EnumSet<AdditionalScope> result = EnumSet.noneOf(AdditionalScope.class);
        if (appId != null) {
            if (this.appIdAdditionalScopes.containsKey(appId)) {
                return this.appIdAdditionalScopes.get(appId);
            }
            Set<IProject> projects = this.getAppIdContent(appId);
            for (IProject project : projects) {
                Set<AdditionalScope> scopes = this.initialState.get((Object)project).additionalScopes;
                if (result.isEmpty()) {
                    result.addAll(scopes);
                    continue;
                }
                if (result.equals(scopes)) continue;
                String errorMessage = NLS.bind((String)Messages.ProjectAssociationDialog_unexpectedAdditionalScopes, (Object)((Object)result).toString(), (Object)(scopes != null ? scopes.toString() : "null"));
                this.setErrorMessage(errorMessage);
            }
            this.appIdAdditionalScopes.put(appId, result);
        }
        return result;
    }

    private ProjectAssociation getSelected() {
        IStructuredSelection selection = (IStructuredSelection)this.applicationIdCombo.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        return (ProjectAssociation)selection.getFirstElement();
    }

    private void updateButtons() {
        ProjectAssociation assoc = this.getSelected();
        boolean appIdSelected = assoc != null;
        this.addButton.setEnabled(appIdSelected && assoc.getAppName() != null && this.workspaceProjects.getTable().getSelectionCount() > 0);
        this.addAllButton.setEnabled(appIdSelected && assoc.getAppName() != null && this.workspaceProjects.getTable().getItemCount() > 0);
        this.removeButton.setEnabled(appIdSelected && this.appIdProjects.getTable().getSelectionCount() > 0);
        this.removeAllButton.setEnabled(appIdSelected && this.appIdProjects.getTable().getItemCount() > 0);
    }

    private void updateAdditionalScopeCheckboxes() {
        this.providedCheckbox.setSelection(false);
        this.testCheckbox.setSelection(false);
        this.systemCheckbox.setSelection(false);
        if (this.getSelected() != null) {
            this.providedCheckbox.setEnabled(true);
            this.testCheckbox.setEnabled(true);
            this.systemCheckbox.setEnabled(true);
            Set<AdditionalScope> scopes = this.getAdditionalScopes();
            for (AdditionalScope scope : scopes) {
                switch (scope) {
                    case PROVIDED: {
                        this.providedCheckbox.setSelection(true);
                        break;
                    }
                    case TEST: {
                        this.testCheckbox.setSelection(true);
                        break;
                    }
                    case SYSTEM: {
                        this.systemCheckbox.setSelection(true);
                    }
                }
            }
        } else {
            this.providedCheckbox.setEnabled(false);
            this.testCheckbox.setEnabled(false);
            this.systemCheckbox.setEnabled(false);
        }
    }

    protected boolean isResizable() {
        return true;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings sett = Activator.getDefault().getDialogSettings().getSection("appid");
        if (sett == null) {
            sett = Activator.getDefault().getDialogSettings().addNewSection("appid");
        }
        return sett;
    }

    private void createAppIdTree(Composite parent) {
        this.appIdProjects = new TableViewer(parent, 2050);
        this.appIdProjects.getTable().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.appIdProjects.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProjectAssociationDialog.this.updateButtons();
            }
        });
        AppearanceAwareLabelProvider javaElementLabelProvider = new AppearanceAwareLabelProvider(36421324767273L, 3);
        this.appIdProjects.setLabelProvider((IBaseLabelProvider)new DecoratingJavaLabelProvider((JavaUILabelProvider)javaElementLabelProvider));
        this.appIdProjects.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.appIdProjects.setUseHashlookup(true);
        this.appIdProjects.setComparator(new ViewerComparator());
        this.appIdProjects.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (ProjectAssociationDialog.this.removeAllButton.isEnabled()) {
                    ProjectAssociationDialog.this.removeSelected();
                }
            }
        });
    }

    private void createWorkspaceTree(Composite parent) {
        this.workspaceProjects = new TableViewer(parent, 2050);
        this.workspaceProjects.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        AppearanceAwareLabelProvider javaElementLabelProvider = new AppearanceAwareLabelProvider(36421324767273L, 3);
        this.workspaceProjects.setLabelProvider((IBaseLabelProvider)new DecoratingJavaLabelProvider((JavaUILabelProvider)javaElementLabelProvider));
        this.workspaceProjects.setUseHashlookup(true);
        this.workspaceProjects.setInput(this.workspaceContent);
        this.workspaceProjects.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProjectAssociationDialog.this.updateButtons();
            }
        });
        this.workspaceProjects.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (ProjectAssociationDialog.this.addAllButton.isEnabled()) {
                    ProjectAssociationDialog.this.addSelected();
                }
            }
        });
        this.workspaceProjects.setComparator(new ViewerComparator());
        this.workspaceProjects.getTable().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
    }

    private synchronized boolean updateApplicationList(ApplicationSummaryList applicationSummaryList, IProgressMonitor parentMonitor) {
        boolean invalidAppIds = false;
        if (!this.getShell().isDisposed() && applicationSummaryList != null) {
            ProjectAssociation assoc;
            boolean firstLoad = this.buildModel(parentMonitor);
            TreeMap<String, ProjectAssociation> updatedProjects = new TreeMap<String, ProjectAssociation>(String.CASE_INSENSITIVE_ORDER);
            for (ApplicationSummary applicationSummary : applicationSummaryList.getApplicationSummaries()) {
                String appId = applicationSummary.getPublicId();
                String appName = applicationSummary.getName();
                ProjectAssociation assoc2 = this.projects.get(appId);
                if (assoc2 == null) {
                    assoc2 = new ProjectAssociation(appId, appName);
                    assoc2.getAssignedProjects().addAll(this.getAppIdContent(assoc2.getAppId()));
                } else {
                    this.projects.remove(appId);
                    assoc2.setApplicationName(appName);
                }
                updatedProjects.put(appId, assoc2);
            }
            if (!this.projects.isEmpty()) {
                for (Map.Entry entry : this.projects.entrySet()) {
                    assoc = (ProjectAssociation)entry.getValue();
                    assoc.setApplicationName(null);
                    Iterator<IProject> it = assoc.getAssignedProjects().iterator();
                    while (it.hasNext()) {
                        IProject project = it.next();
                        if (this.initialState.containsKey(project)) continue;
                        this.workspaceContent.add(project);
                        it.remove();
                    }
                    if (assoc.getAssignedProjects().isEmpty()) continue;
                    updatedProjects.put((String)entry.getKey(), assoc);
                    invalidAppIds = true;
                }
            }
            if (firstLoad) {
                for (Map.Entry entry : this.appIdContent.entrySet()) {
                    if (updatedProjects.containsKey(entry.getKey())) continue;
                    assoc = new ProjectAssociation((String)entry.getKey(), null);
                    updatedProjects.put(assoc.getAppId(), assoc);
                    assoc.getAssignedProjects().addAll((Collection)entry.getValue());
                    invalidAppIds = true;
                }
            }
            this.projects = updatedProjects;
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (ProjectAssociationDialog.this.applicationIdCombo.getControl().isDisposed()) {
                        return;
                    }
                    ProjectAssociationDialog.this.applicationIdCombo.setInput(ProjectAssociationDialog.this.projects.values());
                    ProjectAssociationDialog.this.workspaceProjects.refresh();
                }
            });
        }
        return invalidAppIds;
    }

    private void doLoad() {
        try {
            this.setErrorMessage(null);
            this.applicationIdCombo.setInput((Object)Collections.EMPTY_LIST);
            ModalContext.run((IRunnableWithProgress)this.getRunnable(), (boolean)true, (IProgressMonitor)this.progressMonitorPart, (Display)this.getShell().getDisplay());
        }
        catch (InvocationTargetException e) {
            if (this.applicationIdCombo.getControl().isDisposed()) {
                return;
            }
            this.setErrorMessage(e.getMessage());
            StatusManager.getManager().handle((IStatus)new Status(4, "com.sonatype.clm.ide.eclipse", e.getMessage(), (Throwable)e));
        }
        catch (InterruptedException e) {
            this.setErrorMessage(Messages.ProjectAssociationDialog_unexpectedError);
            StatusManager.getManager().handle((IStatus)new Status(4, "com.sonatype.clm.ide.eclipse", Messages.ProjectAssociationDialog_unexpectedError, (Throwable)e));
            Thread.currentThread().interrupt();
        }
    }

    private IRunnableWithProgress getRunnable() {
        this.progressMonitorPart.setVisible(true);
        this.applicationIdCombo.getControl().setEnabled(false);
        this.refreshButton.setEnabled(false);
        final String serverUrl = this.serverURLText.getText();
        final String username = this.serverUsernameText.getText();
        final String password = this.serverPasswordText.getText();
        final boolean uiPkiAuthentication = this.pkiAuthenticationRadio.getSelection();
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(Messages.ProjectAssociationDialog_contactingServer, 10);
                try {
                    try {
                        if (serverUrl.isEmpty()) {
                            throw new URISyntaxException(serverUrl, "Empty URL");
                        }
                        monitor.worked(1);
                        UrlBuilder url = new UrlBuilder(serverUrl);
                        url.appendPath("rest/integration/applications");
                        url.appendQueryParam("goal", "EVALUATE_COMPONENT");
                        ApplicationSummaryList applicationSummaryList = uiPkiAuthentication ? InsightClientManager.getInstance().getClient().getPki(url.build(), ApplicationSummaryList.class) : InsightClientManager.getInstance().getClient().get(url.build(), username, password, ApplicationSummaryList.class);
                        monitor.worked(8);
                        final boolean invalidAppIds = ProjectAssociationDialog.this.updateApplicationList(applicationSummaryList, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if ((this).ProjectAssociationDialog.this.applicationIdCombo.getControl().isDisposed()) {
                                    return;
                                }
                                (this).ProjectAssociationDialog.this.applicationIdCombo.getControl().setEnabled(true);
                                if (invalidAppIds) {
                                    ProjectAssociationDialog.this.setMessage(Messages.ProjectAssociationDialog_invalidApps, 2);
                                } else {
                                    ProjectAssociationDialog.this.setMessage("");
                                }
                            }
                        });
                    }
                    catch (HttpResponseException e) {
                        String message = e.getStatusCode() == 401 ? Messages.ProjectAssociationDialog_invalidCredentials : (e.getStatusCode() == 503 ? Messages.ProjectAssociationDialog_server_down_maintainance : (e.getStatusCode() != 404 ? NLS.bind((String)Messages.ProjectAssociationDialog_error, (Object)e.getStatusCode(), (Object)e.getMessage()) : Messages.ProjectAssociationDialog_server_url_wrong));
                        throw new InvocationTargetException(e, message);
                    }
                    catch (HttpHostConnectException e) {
                        throw new InvocationTargetException(e, NLS.bind((String)Messages.ProjectAssociationDialog_hostError, (Object)e.getHost()));
                    }
                    catch (UnknownHostException e) {
                        throw new InvocationTargetException(e, NLS.bind((String)Messages.ProjectAssociationDialog_hostError, (Object)e.getMessage()));
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e, Messages.ProjectAssociationDialog_unexpectedError);
                    }
                    catch (URISyntaxException e) {
                        throw new InvocationTargetException(e, Messages.ProjectAssociationDialog_server_url_wrong);
                    }
                }
                catch (Throwable throwable) {
                    monitor.done();
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if ((this).ProjectAssociationDialog.this.progressMonitorPart.isDisposed()) {
                                return;
                            }
                            (this).ProjectAssociationDialog.this.progressMonitorPart.setVisible(false);
                            (this).ProjectAssociationDialog.this.refreshButton.setEnabled(true);
                        }
                    });
                    throw throwable;
                }
                monitor.done();
                Display.getDefault().asyncExec(new /* invalid duplicate definition of identical inner class */);
            }
        };
    }

    private class AdditionalScopeSelectionAdapter
    extends SelectionAdapter {
        private AdditionalScope additionalScope;

        public AdditionalScopeSelectionAdapter(AdditionalScope additionalScope) {
            this.additionalScope = additionalScope;
        }

        public void widgetSelected(SelectionEvent e) {
            Set<AdditionalScope> scopes = ProjectAssociationDialog.this.getAdditionalScopes();
            Button button = (Button)e.widget;
            if (button.getSelection()) {
                scopes.add(this.additionalScope);
            } else {
                scopes.remove((Object)this.additionalScope);
            }
            this.setAdditionalScopes(scopes);
        }

        private void setAdditionalScopes(Set<AdditionalScope> scopes) {
            ProjectAssociation selection = ProjectAssociationDialog.this.getSelected();
            if (selection != null) {
                String appId = selection.getAppId();
                ProjectAssociationDialog.this.appIdAdditionalScopes.put(appId, scopes);
            }
        }
    }
}

