/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.ide.eclipse.internal.ui;

import com.sonatype.insight.ide.eclipse.internal.ProjectConfigurationDTO;
import com.sonatype.insight.ide.eclipse.internal.helpers.ConfigHelper;
import com.sonatype.insight.ide.eclipse.internal.ui.Controller;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class ProjectRegistry {
    private final Map<IProject, String> assignedProjects;
    private final Controller controller;
    private final IResourceChangeListener resourceChangeListener;
    private final Queue<ProjectChangeDelta> deltas;
    private final ProjectsChangedJob updateJob;

    public ProjectRegistry(Controller controller) {
        this.controller = controller;
        this.assignedProjects = new ConcurrentHashMap<IProject, String>(128);
        this.resourceChangeListener = new ProjectsChangeListener();
        this.deltas = new ConcurrentLinkedQueue<ProjectChangeDelta>();
        this.updateJob = new ProjectsChangedJob();
    }

    private void schedule(ProjectChangeDelta delta) {
        if (!delta.additions.isEmpty() || !delta.removals.isEmpty()) {
            this.deltas.add(delta);
            this.updateJob.schedule();
        }
    }

    public void start() {
        IProject[] projects;
        this.assignedProjects.clear();
        ProjectChangeDelta delta = new ProjectChangeDelta();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isOpen()) {
                delta.additions.add(project);
            }
            ++n2;
        }
        this.schedule(delta);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener);
    }

    public void stop() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        this.updateJob.cancel();
    }

    public Set<IProject> getProjects() {
        return Collections.unmodifiableSet(this.assignedProjects.keySet());
    }

    public Set<String> getAppIds() {
        return new HashSet<String>(this.assignedProjects.values());
    }

    public String getAppId(IProject project) {
        return this.assignedProjects.get(project);
    }

    private static class ProjectChangeDelta {
        final Set<IProject> additions = new HashSet<IProject>();
        final Set<IProject> removals = new HashSet<IProject>();
    }

    private class ProjectsChangeListener
    implements IResourceChangeListener {
        private ProjectsChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (event.getType() == 2 || event.getType() == 4) {
                ProjectChangeDelta delta = new ProjectChangeDelta();
                delta.removals.add((IProject)event.getResource());
                ProjectRegistry.this.schedule(delta);
            } else if (event.getType() == 1) {
                ProjectChangeDelta delta = new ProjectChangeDelta();
                IResourceDelta[] iResourceDeltaArray = event.getDelta().getAffectedChildren();
                int n = iResourceDeltaArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResourceDelta[] fileDeltas;
                    IResourceDelta projectDelta = iResourceDeltaArray[n2];
                    IResourceDelta[] iResourceDeltaArray2 = fileDeltas = projectDelta.getAffectedChildren(7, 8);
                    int n3 = fileDeltas.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IResourceDelta fileDelta = iResourceDeltaArray2[n4];
                        if (".sonatype".equals(fileDelta.getResource().getName())) {
                            if (fileDelta.getKind() == 4) {
                                delta.removals.add(fileDelta.getResource().getProject());
                                delta.additions.add(fileDelta.getResource().getProject());
                                break;
                            }
                            if (fileDelta.getKind() == 2) {
                                delta.removals.add(fileDelta.getResource().getProject());
                                break;
                            }
                            if (fileDelta.getKind() != 1) break;
                            delta.additions.add(fileDelta.getResource().getProject());
                            break;
                        }
                        ++n4;
                    }
                    ++n2;
                }
                ProjectRegistry.this.schedule(delta);
            }
        }
    }

    private class ProjectsChangedJob
    extends Job {
        public ProjectsChangedJob() {
            super("");
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                ProjectChangeDelta delta = ProjectRegistry.this.deltas.poll();
                while (delta != null && !monitor.isCanceled()) {
                    IProject project;
                    Iterator<IProject> it = delta.removals.iterator();
                    while (it.hasNext()) {
                        project = it.next();
                        if (ProjectRegistry.this.assignedProjects.remove(project) != null) continue;
                        it.remove();
                    }
                    if (!delta.removals.isEmpty()) {
                        ProjectRegistry.this.controller.notifyProjectsRemoved(delta.removals);
                    }
                    it = delta.additions.iterator();
                    while (it.hasNext()) {
                        project = it.next();
                        ProjectConfigurationDTO projectConfigurationDTO = ConfigHelper.getProjectConfiguration(project);
                        String appId = projectConfigurationDTO.applicationId;
                        if (appId != null && ProjectRegistry.this.assignedProjects.put(project, appId) == null) continue;
                        it.remove();
                    }
                    if (!delta.additions.isEmpty()) {
                        ProjectRegistry.this.controller.notifyProjectsAdded(delta.additions);
                    }
                    delta = ProjectRegistry.this.deltas.poll();
                }
                IStatus iStatus = monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
                return iStatus;
            }
            finally {
                monitor.done();
            }
        }
    }
}

